/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompLimits;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.FanControl;
import org.lsst.ccs.subsystem.refrig.constants.CompAlert;
import org.lsst.ccs.subsystem.refrig.constants.CompSwConds;
import org.lsst.ccs.subsystem.refrig.constants.CompSwitches;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class Compressor
implements HasLifecycle {
    protected static final String COMP_LIMITS = "CompLimits";
    private static final int MIN_SW_STATE_SITS = 5;
    private static final Map<Integer, CompAlert> ccsAlertMap = new HashMap<Integer, CompAlert>();
    private static final Map<Integer, CompAlert> plcAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected CompPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected CompMaq20Device maq20Devc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FanControl fanControl;
    protected String discPressChan;
    protected String discTempChan;
    protected String suctTempChan;
    protected String cmprPowerChan;
    private static final Logger LOG;
    protected final CompState state;
    protected final SwitchDevice[] switchDevices;
    protected final int[] switchChannels;
    protected Channel discPress;
    protected Channel discTemp;
    protected boolean gotCommand = false;
    protected boolean stateChanged = false;
    private final LatchState[] savedLatchStates = new LatchState[10];
    protected CompLimits.LimitData[] limitData;
    protected final SwCondData[] condData = new SwCondData[13];
    private final SwCondState[] savedSwStates = new SwCondState[13];
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private final AlertEnableSwitch alertEnableSwitch = new AlertEnableSwitch();
    private int activeConds = 0;
    private boolean powerEnabled = false;
    private boolean alertsEnabled = false;

    public Compressor(CompState state) {
        this.state = state;
        this.switchDevices = new SwitchDevice[8];
        this.switchChannels = new int[8];
        for (int j = 0; j < 13; ++j) {
            this.condData[j] = new SwCondData();
        }
    }

    public void init() {
        CompAlert alert;
        int cond;
        this.alertService.registerAlert(CompAlert.PLC_DEAD.newAlert(this.name));
        Iterator iterator = this.state.getValidLatches().iterator();
        while (iterator.hasNext()) {
            cond = (Integer)iterator.next();
            alert = plcAlertMap.get(cond);
            this.alertService.registerAlert(alert.newAlert(this.name));
        }
        iterator = this.state.getValidSwConditions().iterator();
        while (iterator.hasNext()) {
            cond = (Integer)iterator.next();
            alert = ccsAlertMap.get(cond);
            this.alertService.registerAlert(alert.newAlert(this.name));
        }
    }

    public void postInit() {
        Channel cmprPower;
        Channel suctTemp;
        if (this.plutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"plutoDevc", (String)"not specified");
        }
        if (this.maq20Devc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maq20Devc", (String)"not specified");
        }
        Channel channel = this.discTemp = this.discTempChan != null ? this.channelMap.get(this.discTempChan) : null;
        if (this.discTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discTempChan", (String)"not specified or not defined");
        }
        this.condData[1].channel = this.discTemp;
        Channel channel2 = suctTemp = this.suctTempChan != null ? this.channelMap.get(this.suctTempChan) : null;
        if (suctTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctTempChan", (String)"not specified or not defined");
        }
        this.condData[2].channel = suctTemp;
        Channel channel3 = this.discPress = this.discPressChan != null ? this.channelMap.get(this.discPressChan) : null;
        if (this.discPress == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discPressChan", (String)"not specified or not defined");
        }
        this.condData[0].channel = this.discPress;
        Channel channel4 = cmprPower = this.cmprPowerChan != null ? this.channelMap.get(this.cmprPowerChan) : null;
        if (cmprPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"cmprPowerChan", (String)"not specified or not defined");
        }
        this.condData[3].channel = cmprPower;
        this.condData[5].immedCond = false;
        this.switchDevices[0] = this.plutoDevc;
        this.switchChannels[0] = 0;
        this.switchDevices[2] = this.plutoDevc;
        this.switchChannels[2] = 1;
        this.switchDevices[7] = this.alertEnableSwitch;
        this.state.setName(this.name);
        this.plutoDevc.setType(this.state.getType());
        this.maq20Devc.setType(this.state.getType());
    }

    public void postStart() {
        if (this.fanControl != null) {
            LOG.log(Level.INFO, "Starting fan speed controller for compressor {0}", this.name);
            this.fanControl.startLoop();
        }
    }

    public void setIndex(int index) {
        this.state.setIndex(index);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid switch names", level=0)
    public List<String> getSwitchNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iterator = this.state.getValidSwitches().iterator();
        while (iterator.hasNext()) {
            int swId = (Integer)iterator.next();
            names.add((String)CompSwitches.ID_MAP.get(swId));
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a compressor's switch state")
    public synchronized void setSwitchOn(@Argument(description="Switch name") String swName, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        this.gotCommand = true;
        Integer swId = (Integer)CompSwitches.NAME_MAP.get(swName);
        if (swId == null || !this.state.getValidSwitches().contains(swId)) {
            throw new RefrigException("Invalid switch name: " + swName);
        }
        if (swId != 0 || !on || this.activeConds == 0) {
            this.setSwitch(swId, on);
            if (swId == 0) {
                this.powerEnabled = on;
                this.alertEnableSwitch.setSwitchOn(0, on);
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a compressor's latches")
    public synchronized void resetLatches() {
        this.gotCommand = true;
        this.plutoDevc.resetLatches();
    }

    public synchronized boolean updateSystem() {
        this.checkLimits();
        return this.updateState();
    }

    public CompState getState() {
        return this.state;
    }

    public void setPlateTempLow(boolean on) {
        this.condData[5].newImmedCond = on;
    }

    private synchronized void checkLimits() {
        Iterator iterator = this.state.getValidSwConditions().iterator();
        while (iterator.hasNext()) {
            int cond = (Integer)iterator.next();
            SwCondData cd = this.condData[cond];
            if (cd.immedCond != null && cd.newImmedCond != cd.immedCond) {
                cd.immedCond = cd.newImmedCond;
                if (cd.immedCond.booleanValue()) {
                    cd.swState = SwCondState.ACTIVE;
                    this.setCondition(cond);
                    continue;
                }
                cd.swState = SwCondState.CLEAR;
                this.clearCondition(cond);
                continue;
            }
            if (cd.channel == null) continue;
            CompLimits.LimitData ld = this.limitData[cond];
            double value = cd.channel.getValue();
            if (cd.channel2 != null) {
                value = Math.abs(value - cd.channel2.getValue());
            }
            if (Double.isNaN(value)) continue;
            long endTime = cd.endTime;
            SwCondState swState = cd.swState;
            if (!ld.isLower && value > ld.immedLimit || ld.isLower && value < ld.immedLimit) {
                endTime = -1L;
                swState = SwCondState.ACTIVE;
            } else if (!ld.isLower && value > ld.delayLimit || ld.isLower && value < ld.delayLimit) {
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + (long)ld.delayTime;
                    swState = SwCondState.DLYPEND;
                }
                if (endTime >= 0L && (ld.delayTime < 0 && this.state.getConditionState(14) == ConditionState.YES || ld.delayTime >= 0 && System.currentTimeMillis() > endTime)) {
                    endTime = -1L;
                    swState = SwCondState.DLYACTV;
                }
            } else {
                endTime = 0L;
                swState = SwCondState.CLEAR;
            }
            if (swState != cd.provSwState) {
                cd.provCount = 0;
                cd.provSwState = swState;
            }
            if (++cd.provCount < 5 || cd.provSwState == cd.swState) continue;
            cd.value = value;
            cd.swState = cd.provSwState;
            cd.endTime = endTime;
            if (endTime < 0L) {
                this.setCondition(cond);
                continue;
            }
            this.clearCondition(cond);
        }
    }

    protected synchronized boolean updateState() {
        CompressorState oldCompState;
        boolean changed = this.gotCommand;
        this.gotCommand = false;
        Boolean active = this.plutoDevc.isPLCActive();
        CompressorState compState = active == null ? CompressorState.OFFLINE : (active == false ? CompressorState.PLC_DEAD : null);
        Iterator iterator = this.state.getValidSwitches().iterator();
        while (iterator.hasNext()) {
            int sw = (Integer)iterator.next();
            Boolean on = this.switchDevices[sw].isSwitchOn(this.switchChannels[sw]);
            SwitchState swState = on == null ? SwitchState.OFFLINE : (on != false ? SwitchState.ON : SwitchState.OFF);
            if (swState == this.state.getSwitchState(sw)) continue;
            this.state.setSwitchState(sw, swState);
            changed = true;
        }
        boolean cmprPowered = false;
        Iterator sw = this.state.getValidConditions().iterator();
        while (sw.hasNext()) {
            int cond = (Integer)sw.next();
            ConditionState condState = this.plutoDevc.getConditionState(cond);
            if (cond == 3 && condState != ConditionState.NO) {
                cmprPowered = true;
            }
            if (condState == this.state.getConditionState(cond)) continue;
            this.state.setConditionState(cond, condState);
            changed = true;
        }
        this.alertEnableSwitch.setSwitchOn(0, this.alertsEnabled);
        sw = this.state.getValidLatches().iterator();
        while (sw.hasNext()) {
            LatchState oldLatchState;
            int cond = (Integer)sw.next();
            LatchState latchState = this.plutoDevc.getLatchState(cond);
            if (latchState != (oldLatchState = this.state.getLatchState(cond))) {
                this.state.setLatchState(cond, latchState);
                changed = true;
            }
            LatchState savedLatchState = this.savedLatchStates[cond];
            if (this.alertsEnabled) {
                if ((savedLatchState == null || latchState == savedLatchState) && (savedLatchState != null || latchState == oldLatchState)) continue;
                this.raisePlcAlert(cond, latchState, savedLatchState == null ? oldLatchState : savedLatchState);
                this.savedLatchStates[cond] = null;
                continue;
            }
            if (savedLatchState != null || latchState == oldLatchState) continue;
            this.savedLatchStates[cond] = oldLatchState;
        }
        sw = this.state.getValidSwConditions().iterator();
        while (sw.hasNext()) {
            SwCondState oldSwState;
            SwCondState swState;
            int cond = (Integer)sw.next();
            SwCondData cd = this.condData[cond];
            CompLimits.LimitData ld = this.limitData[cond];
            SwCondState swCondState = swState = ld.noShutoff && this.powerEnabled ? SwCondState.CLEAR : cd.swState;
            if (compState == null && (swState == SwCondState.ACTIVE || swState == SwCondState.DLYACTV)) {
                compState = CompressorState.SW_DSAB;
            }
            if (swState != (oldSwState = this.state.getSwConditionState(cond))) {
                this.state.setSwConditionState(cond, swState);
                changed = true;
            }
            SwCondState savedSwState = this.savedSwStates[cond];
            if (this.alertsEnabled) {
                if ((savedSwState == null || swState == savedSwState) && (savedSwState != null || swState == oldSwState)) continue;
                this.raiseCcsAlert(cond, cd.value, ld, swState);
                this.savedSwStates[cond] = null;
                continue;
            }
            if (savedSwState != null || swState == oldSwState) continue;
            this.savedSwStates[cond] = oldSwState;
        }
        if (compState == null) {
            compState = this.state.getConditionState(2) == ConditionState.YES ? CompressorState.WAITING : (this.state.getConditionState(3) == ConditionState.YES ? CompressorState.RUNNING : (this.state.getConditionState(11) == ConditionState.NO ? CompressorState.HW_DSAB : CompressorState.STOPPED));
        }
        boolean bl = this.stateChanged = compState != (oldCompState = this.state.getCompressorState());
        if (this.stateChanged) {
            if (compState == CompressorState.PLC_DEAD) {
                this.raiseAlert(CompAlert.PLC_DEAD, AlertState.ALARM, this.name + " PLC has died: error code = " + this.plutoDevc.getErrorCode());
            } else if (oldCompState == CompressorState.PLC_DEAD) {
                this.lowerAlert(CompAlert.PLC_DEAD, this.name + " PLC is alive");
            }
            this.state.setCompressorState(compState);
            changed = true;
        }
        if (this.powerEnabled && !cmprPowered) {
            this.disable();
        }
        return changed;
    }

    private void raisePlcAlert(int cond, LatchState latchState, LatchState oldLatchState) {
        CompAlert alert = plcAlertMap.get(cond);
        if (latchState == LatchState.ACTIVE) {
            this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
        } else if (latchState == LatchState.WARNING) {
            this.raiseAlert(alert, AlertState.WARNING, this.name + " PLC warning condition set");
        } else {
            if (latchState == LatchState.LATCHED && oldLatchState == LatchState.CLEAR) {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
            }
            this.lowerAlert(alert, this.name + " PLC error condition cleared");
        }
    }

    private void raiseCcsAlert(int cond, double value, CompLimits.LimitData ld, SwCondState swState) {
        CompAlert alert = ccsAlertMap.get(cond);
        boolean isImmed = this.condData[cond].immedCond != null;
        String sValue = String.format("%.1f", value);
        switch (swState) {
            case ACTIVE: {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS immediate error condition set" + (isImmed ? "" : ": value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.immedLimit));
                break;
            }
            case DLYACTV: {
                String timeText = ld.delayTime >= 0 ? " for " + ld.delayTime / 1000 + " sec" : " and compressor on for 8 hours";
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS delayed error condition set: value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.delayLimit + timeText);
                break;
            }
            case DLYPEND: {
                this.raiseAlert(alert, AlertState.WARNING, this.name + " CCS delayed error condition pending: value (" + sValue + (ld.isLower ? ") < " : ") > ") + ld.delayLimit);
                break;
            }
            default: {
                this.lowerAlert(alert, this.name + " CCS error condition cleared" + (isImmed ? "" : ": value = " + sValue));
            }
        }
    }

    protected void setSwitch(int sw, boolean on) throws RefrigException {
        this.switchDevices[sw].setSwitchOn(this.switchChannels[sw], on);
    }

    private void setCondition(int cond) {
        LOG.log(Level.FINE, "{0} compressor encountered \"{1}\" condition", new Object[]{this.name, CompSwConds.DESCS[cond]});
        if (!this.limitData[cond].noShutoff) {
            this.disable();
        }
        this.activeConds |= 1 << cond;
    }

    private void clearCondition(int cond) {
        this.activeConds &= ~(1 << cond);
    }

    private void disable() {
        try {
            this.setSwitch(0, false);
            this.powerEnabled = false;
        }
        catch (RefrigException e) {
            LOG.log(Level.SEVERE, "Error shutting off {0} compressor: {1}", new Object[]{this.name, e});
        }
    }

    private void raiseAlert(CompAlert alert, AlertState state, String cond) {
        this.activeAlertMap.put(alert.getId(this.name), true);
        this.alertService.raiseAlert(alert.newAlert(this.name), state, cond);
    }

    private void lowerAlert(CompAlert alert, String cond) {
        if (this.activeAlertMap.put(alert.getId(this.name), false) == Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(this.name), AlertState.NOMINAL, cond);
        }
    }

    protected boolean areEqual(double value1, double value2) {
        return value1 == value2 || Double.isNaN(value1) && Double.isNaN(value2);
    }

    static {
        ccsAlertMap.put(0, CompAlert.DISC_PRESS_HIGH);
        ccsAlertMap.put(1, CompAlert.DISC_TEMP_HIGH);
        ccsAlertMap.put(3, CompAlert.COMP_POWER_HIGH);
        ccsAlertMap.put(7, CompAlert.LIQD_TEMP_HIGH);
        ccsAlertMap.put(6, CompAlert.OIL_LEVEL_LOW);
        ccsAlertMap.put(2, CompAlert.SUCT_TEMP_LOW);
        ccsAlertMap.put(4, CompAlert.PHASE_TEMP_HIGH);
        ccsAlertMap.put(5, CompAlert.CRYO_TEMP_LOW);
        ccsAlertMap.put(8, CompAlert.PRESS_DIFF_HIGH);
        ccsAlertMap.put(9, CompAlert.DISC_TEMP_LOW);
        plcAlertMap = new HashMap<Integer, CompAlert>();
        plcAlertMap.put(3, CompAlert.DISC_PRESS_HIGH_PLC);
        plcAlertMap.put(0, CompAlert.DISC_TEMP_HIGH_PLC);
        plcAlertMap.put(4, CompAlert.COMP_POWER_HIGH_PLC);
        plcAlertMap.put(2, CompAlert.LIQD_TEMP_HIGH_PLC);
        plcAlertMap.put(9, CompAlert.OIL_LEVEL_LOW_PLC);
        plcAlertMap.put(1, CompAlert.SUCT_TEMP_LOW_PLC);
        plcAlertMap.put(8, CompAlert.AFTER_TEMP_HIGH_PLC);
        plcAlertMap.put(7, CompAlert.SENS_READ_BAD_PLC);
        plcAlertMap.put(6, CompAlert.SMOKE_DETC_PLC);
        plcAlertMap.put(5, CompAlert.EXT_PERMIT_PLC);
        LOG = Logger.getLogger(Compressor.class.getName());
    }

    public static class SwCondData {
        protected Channel channel = null;
        protected Channel channel2 = null;
        private Boolean immedCond = null;
        private boolean newImmedCond = false;
        private double value = 0.0;
        private long endTime = 0L;
        private SwCondState swState = SwCondState.CLEAR;
        private SwCondState provSwState = SwCondState.CLEAR;
        private int provCount = 0;
    }

    class AlertEnableSwitch
    implements SwitchDevice {
        AlertEnableSwitch() {
        }

        @Override
        public void setSwitchOn(int chan, boolean on) {
            Compressor.this.alertsEnabled = Compressor.this.powerEnabled ? true : on;
        }

        @Override
        public Boolean isSwitchOn(int chan) {
            return Compressor.this.alertsEnabled;
        }
    }

    public static interface SwitchDevice {
        public void setSwitchOn(int var1, boolean var2) throws RefrigException;

        public Boolean isSwitchOn(int var1);
    }
}

