package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.bk.Model9130;

/**
 *  Handles a B&K model 9130 power supply device.
 *
 *  @author Owen Saxton
 */
public class BK9130Device extends PowerDevice {


    /**
     *  Constructor.
     */
    public BK9130Device()
    {
        super("B&K Model 9130", new Model9130(), NETWORK_CONN_INVALID, 1, 3);
        settlingTime = 100;   // Wait time (ms) needed to get good current reading after setting voltage
    }

}
