import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.refrig.PrototypeColdPlateSubsystem
import org.lsst.ccs.subsystem.refrig.SimMaq20Device
import org.lsst.ccs.subsystem.refrig.ConfiguredAverageChannel;
import org.lsst.ccs.subsystem.refrig.PcpPowerDevice
import org.lsst.ccs.subsystem.refrig.PcpPowerControl
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice
import org.lsst.ccs.subsystem.refrig.SimCompPlutoDevice
import org.lsst.ccs.monitor.Channel;

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    plutoDevice = SimCompPlutoDevice
    pOffset500 = 0.0
    pScale500 = 1.0
} else {
    maq20Device = Maq20Device
    plutoDevice = PcpPlutoDevice
    pOffset500 = -125.0;
    pScale500 = 31250.0
}

CCSBuilder builder = ["prototype-cold-plate"]

builder.main (PrototypeColdPlateSubsystem, powerChans: [0, 2, 1] /* -Y, +Y, center*/) {

  /**
    * Maq20 modules in order of DIN number in LCA-19722-A:
    * DIN 09, 10, 11, 12, 20, 21; then added 16, 15 for heaters
    */
    Maq20 (maq20Device, modules: ["RTD","RTD","RTD","RTD","IS","RTD","VS","VO"]) {

        HtrPower (PcpPowerDevice)
        
        MinusYHtr (PcpPowerControl, ident: 0, inVoltage: "6:0:V5:150", outVoltage: "7:0:VP5:150",
                   inCurrent: "6:1:V5:7", outCurrent: "7:1:VP5:7", inEnabled: "6:6:V40:20", maxCurrent: 6.0)

        CenterHtr (PcpPowerControl, ident: 1, inVoltage: "6:2:V10:60", outVoltage: "7:2:VP10:60",
                   inCurrent: "6:3:V10:20", outCurrent: "7:3:VP10:20", inEnabled: "6:7:V40:8", maxCurrent: 24.0)

        PlusYHtr (PcpPowerControl, ident: 2, inVoltage: "6:4:V5:150", outVoltage: "7:4:VP5:150",
                  inCurrent: "6:5:V5:8", outCurrent: "7:5:VP5:8", inEnabled: "6:8:V40:20", maxCurrent: 6.0)
    }        

    Pluto   (plutoDevice)

    "Maq20/PSupply" (Channel, description: "ColdPlate supply pressure",
                      devcName: "Maq20", units: "psia", format: ".2f",
                      subtype: "MA4_20", type: "4", hwChan: 0,
                      offset: pOffset500, scale: pScale500,
                      checkLo:"none", checkHi:"none")

    "Maq20/PReturn" (Channel, description: "ColdPlate return pressure",
                      devcName: "Maq20", units: "psia", format: ".2f",
                      subtype: "MA4_20", type: "4", hwChan: 1,
                      offset: pOffset500, scale: pScale500,
                      checkLo:"none", checkHi:"none")

    "Maq20/TSupply" (Channel, description: "Coolant input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 0,
                      checkLo:"none", checkHi:"none")

    "Maq20/TCircuit1In"  (Channel, description: "Circuit 1 input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 2,
                      checkLo:"none", checkHi:"none")

    "Maq20/TCircuit2In" (Channel, description: "Circuit 2 input temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 4,
                      checkLo:"none", checkHi:"none")

    "Maq20/TCircuit1Out" (Channel, description: "Circuit 1 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    "Maq20/TCircuit2Out" (Channel, description: "Circuit 2 output temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 5,
                      checkLo:"none", checkHi:"none")

    "Maq20/TReturn" (Channel, description: "Coolant return temperature",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "5", hwChan: 1,
                      checkLo:"none", checkHi:"none")

    "Maq20/TColdBarAvg" (ConfiguredAverageChannel, units: "\u00b0C", format: ".2f",
                      description: "Average Temperature Cold Bar RTDs",
                      checkLo:"none", checkHi:"none")

    "Pluto/RTD00" (Channel, description: "Temperature, Bar 0 position 0", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:0", scale: 0.01, offset: -120.0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD10" (Channel, description: "Temperature, Bar 0 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD20" (Channel, description: "Temperature, Bar 0 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 1,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD30" (Channel, description: "Temperature, Bar 0 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 2,
                      checkLo:"none", checkHi:"none")

    "Pluto/RTD01" (Channel, description: "Temperature, Bar 1 position 0", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:1", scale: 0.01, offset: -120.0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD11" (Channel, description: "Temperature, Bar 1 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD21" (Channel, description: "Temperature, Bar 1 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 4,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD31" (Channel, description: "Temperature, Bar 1 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "0", hwChan: 5,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD02" (Channel, description: "Temperature, Bar 2 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD12" (Channel, description: "Temperature, Bar 2 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 1,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD22" (Channel, description: "Temperature, Bar 2 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 2,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD32" (Channel, description: "Temperature, Bar 2 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD03" (Channel, description: "Temperature, Bar 3 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 4,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD13" (Channel, description: "Temperature, Bar 3 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "2", hwChan: 5,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD23" (Channel, description: "Temperature, Bar 3 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD33" (Channel, description: "Temperature, Bar 3 position 3",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 1,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD04" (Channel, description: "Temperature, Bar 4 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 2,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD14" (Channel, description: "Temperature, Bar 4 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD24" (Channel, description: "Temperature, Bar 4 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 4,
                      checkLo:"none", checkHi:"none")

    "Pluto/RTD34" (Channel, description: "Temperature, Bar 4 position 3", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:2", scale: 0.01, offset: -120.0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD05" (Channel, description: "Temperature, Bar 5 position 0",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "1", hwChan: 5,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD15" (Channel, description: "Temperature, Bar 5 position 1",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 0,
                      checkLo:"none", checkHi:"none")

    "Maq20/RTD25" (Channel, description: "Temperature, Bar 5 position 2",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 1,
                      checkLo:"none", checkHi:"none")

    "Pluto/RTD35" (Channel, description: "Temperature, Bar 5 position 3", units: "\u00b0C", format: ".2f",
                      devcName: "Pluto", hwChan: 0, type: "ADDREG:3", scale: 0.01, offset: -120.0,
                      checkLo:"none", checkHi:"none")

    "Maq20/AmbientTemp"  (Channel, description: "Temperature outside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 2,
                      checkLo:"none", checkHi:"none")

    "Maq20/InteriorTemp" (Channel, description: "Temperature inside enclosure",
                      devcName: "Maq20", units: "\u00b0C", format: ".2f",
                      subtype: "R200", type: "3", hwChan: 3,
                      checkLo:"none", checkHi:"none")

    "Heaters/MinusYHtr_V" (Channel, description: "-Y Heater Voltage", units: "Volts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "VOLTAGE",
                           checkLo:"none", checkHi:"none")

    "Heaters/MinusYHtr_I" (Channel, description: "-Y Heater Current", units: "Amps", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "CURRENT",
                           checkLo:"none", checkHi:"none")

    "Heaters/MinusYHtr_P" (Channel, description: "-Y Heater Power", units: "Watts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 0, type: "POWER",
                           checkLo:"none", checkHi:"none")

    "Heaters/CenterHtr_V" (Channel, description: "Center Heater Voltage", units: "Volts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "VOLTAGE",
                           checkLo:"none", checkHi:"none")

    "Heaters/CenterHtr_I" (Channel, description: "Center Heater Current", units: "Amps", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "CURRENT",
                           checkLo:"none", checkHi:"none")

    "Heaters/CenterHtr_P" (Channel, description: "Center Heater Power", units: "Watts", format: ".1f",
                           devcName: "Maq20/HtrPower", hwChan: 1, type: "POWER",
                           checkLo:"none", checkHi:"none")

    "Heaters/PlusYHtr_V" (Channel, description: "+Y Heater Voltage", units: "Volts", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "VOLTAGE",
                          checkLo:"none", checkHi:"none")

    "Heaters/PlusYHtr_I" (Channel, description: "+Y Heater Current", units: "Amps", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "CURRENT",
                          checkLo:"none", checkHi:"none")

    "Heaters/PlusYHtr_P" (Channel, description: "+Y Heater Power", units: "Watts", format: ".1f",
                          devcName: "Maq20/HtrPower", hwChan: 2, type: "POWER",
                          checkLo:"none", checkHi:"none")

}
