/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.services.AgentPropertiesService;

public class BootUtils {
    private static Properties inputBuildProperties;

    private BootUtils() {
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static ComponentLookup buildComponentLookupFromDescription(String fullDescription, String config, String alias) throws Exception {
        return BootUtils.buildComponentLookupFromDescription(fullDescription, config, alias, null);
    }

    public static ComponentLookup buildComponentLookupFromDescription(Map<String, String> args, String alias) throws Exception {
        return BootUtils.buildComponentLookupFromDescription(args, alias, null);
    }

    public static ComponentLookup buildComponentLookupFromDescription(String fullDescription, String config, String alias, Properties buildProperties) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        if (fullDescription != null) {
            args.put("descriptionName", fullDescription);
        }
        if (config != null) {
            args.put("startupConfig", config);
        }
        return BootUtils.buildComponentLookupFromDescription(args, alias, buildProperties);
    }

    public static ComponentLookup buildComponentLookupFromDescription(Map<String, String> args, String alias, Properties buildProperties) throws Exception {
        inputBuildProperties = buildProperties;
        String config = args.get("startupConfig");
        String fullDescription = args.get("descriptionName");
        if (config != null) {
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
        }
        Properties dynamicAgentProperties = AgentPropertiesService.getDynamicAgentProperties();
        for (String token : dynamicAgentProperties.stringPropertyNames()) {
            SubstitutionTokenUtils.addSubstitutionToken((String)token, (String)dynamicAgentProperties.getProperty(token));
        }
        if (alias != null && !alias.isEmpty()) {
            alias = SubstitutionTokenUtils.resolveSubstitutionTokens((String)alias);
            SubstitutionTokenUtils.addSubstitutionToken((String)"alias", (String)alias);
        }
        String desc = fullDescription;
        if (fullDescription != null && !fullDescription.isEmpty()) {
            if (fullDescription.contains(".")) {
                desc = fullDescription.substring(fullDescription.lastIndexOf(".") + 1);
            }
            SubstitutionTokenUtils.addSubstitutionToken((String)"description", (String)desc);
        }
        Properties finalBuildProperties = ConfigurationService.getBuildProperties(desc, config);
        ComponentLookup lookup = ComponentNodeBuilder.buildComponentNode(args, (Properties)finalBuildProperties);
        return lookup;
    }

    public static Subsystem getSubsystemFromLookup(ComponentLookup componentLookup, String alias) throws Exception {
        ComponentLookup componentLookupService;
        Subsystem subsystem;
        String agentName;
        ComponentNode topNode = componentLookup.getTopComponentNode();
        Object topObj = topNode.getComponent();
        String string = agentName = alias != null ? alias : CCSBuilder.getSubsystemName();
        if (Subsystem.class.isAssignableFrom(topObj.getClass())) {
            subsystem = (Subsystem)topObj;
            if (agentName != null) {
                subsystem.setAgentName(agentName);
            }
            componentLookupService = componentLookup;
            componentLookupService.setComponentNodeName(componentLookupService.getTopComponentNode(), subsystem.getName());
        } else {
            subsystem = new Subsystem(agentName, AgentInfo.AgentType.WORKER);
            ComponentNode subsystemNode = new ComponentNode(subsystem.getName(), (Object)subsystem);
            componentLookupService = new ComponentLookup(subsystemNode);
            subsystemNode.getTags().putAll(componentLookup.getTopComponentNode().getTags());
            componentLookupService.addComponentNodeToLookup(componentLookupService.getTopComponentNode(), componentLookup.getTopComponentNode());
        }
        subsystem.populateComponentLookup(componentLookupService);
        return subsystem;
    }

    public static Subsystem getSubsystemFromFile(String fullDescription, String config, String alias) throws Exception {
        return BootUtils.getSubsystemFromFile(fullDescription, config, alias, new Properties());
    }

    public static Subsystem getSubsystemFromFile(String fullDescription, String config, String alias, Properties buildProperties) throws Exception {
        ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(fullDescription, config, alias, buildProperties);
        return BootUtils.getSubsystemFromLookup(lookup, alias);
    }

    public static void main(String[] argv) throws Exception {
        String descriptionName = argv[0];
        Subsystem s = BootUtils.getSubsystemFromFile(descriptionName);
        System.exit(0);
    }

    public static Properties getInputBuildProperties() {
        return inputBuildProperties;
    }
}

