/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class CompMaq20Device
extends Maq20Device
implements Compressor.SwitchDevice {
    public static final int SW_OIL_SEP_HEATER = 1;
    public static final int NUM_COLD_SWITCHES = 1;
    public static final int SW_COOLANT_VALVE = 1;
    public static final int SW_ORIFICE_VALVE = 2;
    public static final int SW_BYPASS_VALVE = 3;
    public static final int SW_SURGE_HEATER = 4;
    public static final int NUM_CRYO_SWITCHES = 4;
    public static final int CHAN_HGB_VALVE = 0;
    public static final int CHAN_EEPR_VALVE = 1;
    public static final int CHAN_COOLANT_VALVE = 2;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20DiscControl discCtrl;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl anlgCtrl;
    private static final Logger LOG = Logger.getLogger(CompMaq20Device.class.getName());
    private boolean gotValveError = false;

    public void setType(int type) {
        if (this.discCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 discrete control", (String)"not defined");
        }
        if (type == 0 && this.anlgCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 analog control", (String)"not defined");
        }
    }

    @Override
    public void setSwitchOn(int sw, boolean on) throws RefrigException {
        try {
            this.discCtrl.setLineOn(sw, on);
        }
        catch (DriverException e) {
            throw new RefrigException(e.getMessage());
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.discCtrl.isLineOn(sw);
    }

    public void setValvePosition(int chan, double posn) throws RefrigException {
        double value = 10.0 * Math.min(Math.max(posn, 0.0), 1.0);
        try {
            this.anlgCtrl.writeValue(chan, value);
            this.gotValveError = false;
        }
        catch (DriverException e) {
            if (!this.gotValveError) {
                throw new RefrigException("Error setting valve position for " + this.getPath() + ": " + (Object)((Object)e));
            }
            this.gotValveError = true;
        }
    }

    public double getValvePosition(int chan) {
        try {
            double value = this.anlgCtrl.readValue(chan) / 10.0;
            this.gotValveError = false;
            return value;
        }
        catch (DriverException e) {
            if (!this.gotValveError) {
                LOG.log(Level.SEVERE, "Error getting valve position for {0}: {1}", new Object[]{this.getPath(), e});
            }
            this.gotValveError = true;
            return Double.NaN;
        }
    }
}

