/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.auxelex.HeaterPS;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class HeaterPsDevice
extends PowerDevice {
    public static final int TYPE_VOLTAGE = 0;
    public static final int TYPE_CURRENT = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_TOTAL_POWER = 3;
    public static final int TYPE_TEMP = 4;
    public static final int TYPE_MAIN_VOLTS = 5;
    public static final int TYPE_MAIN_CURR = 6;
    public static final int TYPE_MAIN_POWER = 7;
    public static final int TYPE_MAIN_TEMP = 8;
    public static final int TYPE_MAIN_STATUS = 9;
    private static final int N_HW_CHANS = 12;
    private static final int N_SET_CHANS = 6;
    private static final int CRYO_CHANNEL_FIRST = 0;
    private static final int COLD_CHANNEL_FIRST = 6;
    private static final String NODE = "node";
    private static final Set<Integer>[] channelSets;
    private static final Map<String, Integer> typeMap;
    @ConfigurationParameter(name="node", category="Refrig", isFinal=true)
    private volatile Integer node;
    @ConfigurationParameter(category="Refrig", maxLength=6)
    private double[] coldPowerWeights = new double[6];
    @ConfigurationParameter(category="Refrig", maxLength=6)
    private double[] cryoPowerWeights = new double[6];
    private static final Logger LOG;
    private final HeaterPS htr = new HeaterPS();
    private final double[] powerValues = new double[7];
    private final double[] powerWeights = new double[12];
    private final double[] totalWeight = new double[7];
    private final BlockingQueue<Double>[] powerQueues = new BlockingQueue[12];
    private final PowerThread[] powerThreads = new PowerThread[12];
    private final BlockingQueue<Integer>[] returnQueues = new BlockingQueue[7];
    private final double[] currents = new double[12];
    private final double[] voltages = new double[12];
    private final boolean[] outputs = new boolean[12];
    private boolean initError = false;

    public HeaterPsDevice() {
        super("Heater PS", null, 0, 0, 0);
        this.connType = DriverConstants.ConnType.NET;
        this.devcId = "";
        this.settlingTime = 1000;
        this.setColdPowerWeights(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        this.setCryoPowerWeights(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
    }

    @Override
    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)NODE, (String)"is missing");
        }
        for (int chan = 0; chan < 12; ++chan) {
            this.powerQueues[chan] = new ArrayBlockingQueue<Double>(1);
            this.powerThreads[chan] = new PowerThread(chan, this.powerQueues[chan]);
            this.powerThreads[chan].setDaemon(true);
            this.powerThreads[chan].start();
        }
        for (int chanSet = 0; chanSet < 7; ++chanSet) {
            this.returnQueues[chanSet] = new ArrayBlockingQueue<Integer>(channelSets[chanSet].size());
            for (int chan : channelSets[chanSet]) {
                this.powerThreads[chan].addReturnQueue(this.returnQueues[chanSet]);
            }
        }
        this.fullName = this.getPath() + " (Heater power supply: " + this.node + ")";
    }

    @ConfigurationParameterChanger
    public final void setColdPowerWeights(double[] weights) {
        this.checkWeights("cold", weights);
        System.arraycopy(weights, 0, this.coldPowerWeights, 0, 6);
        System.arraycopy(weights, 0, this.powerWeights, 6, 6);
        this.setTotalWeight(1);
        this.setTotalWeight(2);
        this.setTotalWeight(3);
        this.setTotalWeight(4);
        this.setTotalWeight(5);
        this.setTotalWeight(6);
    }

    @ConfigurationParameterChanger
    public final void setCryoPowerWeights(double[] weights) {
        this.checkWeights("cryo", weights);
        System.arraycopy(weights, 0, this.cryoPowerWeights, 0, 6);
        System.arraycopy(weights, 0, this.powerWeights, 0, 6);
        this.setTotalWeight(0);
    }

    private void checkWeights(String section, double[] weights) {
        if (weights.length != 6) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)(section + "PowerWeights"), (String)"must have exactly 6 elements");
        }
        for (double value : weights) {
            if (!(value < 0.0)) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)(section + "PowerWeights"), (String)"element must not be negative");
        }
    }

    private void setTotalWeight(int chanSet) {
        this.totalWeight[chanSet] = 0.0;
        for (int chan : channelSets[chanSet]) {
            int n = chanSet;
            this.totalWeight[n] = this.totalWeight[n] + this.powerWeights[chan];
        }
        if (this.totalWeight[chanSet] == 0.0) {
            this.totalWeight[chanSet] = 1.0;
        }
    }

    @Override
    protected void initialize() {
        try {
            this.htr.open(this.node.intValue(), 8193);
            this.htr.setMainPowerOn(true);
            this.htr.setSwitchPeriod(500);
            this.setOnline(true);
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.htr.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void close() {
        try {
            this.htr.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
        for (int j = 0; j < 12; ++j) {
            this.currents[j] = 0.0;
        }
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int numChan;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        int n = iType == 0 || iType == 1 || iType == 2 ? 12 : (numChan = iType == 3 ? 7 : 1);
        if (hwChan < 0 || hwChan >= numChan) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        return new int[]{iType, 0};
    }

    @Override
    protected void readChannelGroup() {
        if (!this.isOnline()) {
            return;
        }
        try {
            for (int chan = 0; chan < 12; ++chan) {
                this.currents[chan] = this.htr.readCurrent(chan);
                this.voltages[chan] = this.htr.getVoltage(chan);
                this.outputs[chan] = this.htr.getOutput(chan);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading currents & voltages from {0}: {1}", new Object[]{this.fullName, e});
            this.setOnline(false);
        }
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.isOnline()) {
            try {
                switch (type) {
                    case 0: {
                        value = this.outputs[hwChan] ? this.voltages[hwChan] : 0.0;
                        break;
                    }
                    case 1: {
                        value = this.currents[hwChan];
                        break;
                    }
                    case 2: {
                        value = this.outputs[hwChan] ? this.voltages[hwChan] * this.currents[hwChan] : 0.0;
                        break;
                    }
                    case 3: {
                        value = 0.0;
                        for (int chan : channelSets[hwChan]) {
                            value += this.outputs[chan] ? this.voltages[chan] * this.currents[chan] : 0.0;
                        }
                        break;
                    }
                    case 4: {
                        value = this.htr.readBoardTemperature();
                        break;
                    }
                    case 5: {
                        value = this.htr.readMainVoltage();
                        break;
                    }
                    case 6: {
                        value = this.htr.readMainCurrent();
                        break;
                    }
                    case 7: {
                        value = this.htr.readMainVoltage() * this.htr.readMainCurrent();
                        break;
                    }
                    case 8: {
                        value = this.htr.readMainTemperature();
                        break;
                    }
                    case 9: {
                        value = this.htr.readMainStatus();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading value from {0}: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public void enableOutput(int chanSet, boolean enable) {
        for (int chan : channelSets[chanSet]) {
            super.enableOutput(chan, enable);
        }
    }

    @Override
    public boolean isEnabled(int chanSet) {
        boolean enabled = false;
        for (int chan : channelSets[chanSet]) {
            enabled |= super.isEnabled(chan);
        }
        return enabled;
    }

    @Override
    public void setPower(int chanSet, double value) {
        this.powerValues[chanSet] = value;
        int count = 0;
        for (int chan : channelSets[chanSet]) {
            try {
                this.powerQueues[chan].put(value * this.powerWeights[chan] / this.totalWeight[chanSet]);
                ++count;
            }
            catch (InterruptedException interruptedException) {}
        }
        while (count-- > 0) {
            try {
                this.returnQueues[chanSet].take();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void setChannelPower(int chan, double value) {
        super.setPower(chan, value);
    }

    @Override
    protected void maintainPower() {
        for (int chanSet = 0; chanSet < 7; ++chanSet) {
            double value = this.powerValues[chanSet];
            if (value == 0.0) continue;
            this.setPower(chanSet, value);
        }
    }

    @Override
    public boolean hasVoltError(int chanSet) {
        boolean state = false;
        for (int chan : channelSets[chanSet]) {
            state |= super.hasVoltError(chan);
        }
        return state;
    }

    @Override
    public boolean hasNoLoad(int chanSet) {
        boolean state = false;
        for (int chan : channelSets[chanSet]) {
            state |= super.hasNoLoad(chan);
        }
        return state;
    }

    @Override
    public void setOutput(int chan, boolean value) throws DriverException {
        this.htr.setOutput(chan, value);
    }

    @Override
    public boolean getOutput(int chan) throws DriverException {
        return this.htr.getOutput(chan);
    }

    @Override
    public void setVoltage(int chan, double value) throws DriverException {
        this.htr.setVoltage(chan, value);
    }

    @Override
    public double readVoltage(int chan) throws DriverException {
        return this.htr.getVoltage(chan);
    }

    @Override
    public void setCurrent(int chan, double value) {
    }

    @Override
    public double readCurrent(int chan) throws DriverException {
        return this.htr.readCurrent(chan);
    }

    public void setBulkPowerOn(boolean on) {
        try {
            this.htr.setMainPowerOn(on);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting bulk PS state for {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public Boolean isBulkPowerOn() {
        if (this.isOnline()) {
            try {
                return (this.htr.getMainIoStatus() & 1) != 0;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading bulk PS state from {0}: {1}", new Object[]{this.fullName, e});
            }
        }
        return null;
    }

    static {
        int chan;
        channelSets = new Set[7];
        for (int chanSet = 0; chanSet < 7; ++chanSet) {
            HeaterPsDevice.channelSets[chanSet] = new HashSet<Integer>();
        }
        for (chan = 0; chan < 6; ++chan) {
            channelSets[0].add(chan);
        }
        for (chan = 6; chan < 12; ++chan) {
            channelSets[1].add(chan);
        }
        channelSets[2].add(6);
        channelSets[3].add(11);
        for (chan = 7; chan < 11; ++chan) {
            channelSets[4].add(chan);
        }
        channelSets[5].add(7);
        channelSets[5].add(8);
        channelSets[6].add(9);
        channelSets[6].add(10);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        typeMap.put("POWER", 2);
        typeMap.put("TOTALPOWER", 3);
        typeMap.put("TEMP", 4);
        typeMap.put("MAINVOLTS", 5);
        typeMap.put("MAINCURR", 6);
        typeMap.put("MAINPOWER", 7);
        typeMap.put("MAINTEMP", 8);
        typeMap.put("MAINSTAT", 9);
        LOG = Logger.getLogger(HeaterPsDevice.class.getName());
    }

    class PowerThread
    extends Thread {
        private final int chan;
        private final BlockingQueue dataQueue;
        private final List<BlockingQueue> returnQueues = new ArrayList<BlockingQueue>();

        PowerThread(int chan, BlockingQueue dataQueue) {
            this.chan = chan;
            this.dataQueue = dataQueue;
        }

        public void addReturnQueue(BlockingQueue returnQueue) {
            this.returnQueues.add(returnQueue);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    HeaterPsDevice.this.setChannelPower(this.chan, (Double)this.dataQueue.take());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Iterator<BlockingQueue> iterator = this.returnQueues.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    BlockingQueue queue = iterator.next();
                    queue.offer(this.chan);
                }
                break;
            }
        }
    }
}

