package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;

/**
 *  Handles a simulated Dataforth Maq20 system discrete output module.
 *
 *  @author Owen Saxton
 */
public class SimMaq20DiscControl extends Maq20DiscControl {

    /**
     *  Data fields.
     */
    private final Map<Integer, Boolean> chanMap = new HashMap<>();


    /**
     *  Life-cycle initialization.
     */
    @Override
    public void init()
    {
    }


    /**
     *  Sets the state of an output line.
     *
     *  @param  chan  The channel number
     *  @param  on    Whether to set on
     */
    @Override
    public void setLineOn(int chan, boolean on)
    {
        chanMap.put(chan, on);
    }


    /**
     *  Gets the state of an output line.
     *
     *  @param  chan  The channel number
     *  @return  Whether line is on
     */
    @Override
    public Boolean isLineOn(int chan)
    {
        return chanMap.getOrDefault(chan, false);
    }

}
