/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TrimHeaterControl;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalAlert;
import org.lsst.ccs.subsystem.refrig.constants.ThermalConstants;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class ThermalMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener,
ClearAlertHandler {
    private static final String THERMAL_LIMITS = "ThermalLimits";
    private static final int UPDATE_STATE_INTVL = 1000;
    private static final List<Set<Integer>> validTrimHeaterSets = new ArrayList<Set<Integer>>();
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, TrimHeaterControl> tempControlMap = new HashMap<String, TrimHeaterControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, PowerDevice> powerDeviceMap = new HashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private volatile double coldTempLimit = 40.0;
    private String[] auxPowerNames;
    private String[] coldTempNames;
    private static final Logger LOG;
    private Set<Integer> trimHeaterSet;
    private final Set<Integer> auxHeaterSet = new HashSet<Integer>();
    private final TrimHeater[] trimHeaters = new TrimHeater[7];
    private final AuxHeater[] auxHeaters = new AuxHeater[3];
    private final List<Channel> coldTemps = new ArrayList<Channel>();
    private final ThermalState thermalState = new ThermalState();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private int highTempCount = 0;
    private ColdState refrigColdState = ColdState.UNKNOWN;
    private String refrigGroup = null;

    public ThermalMain() {
        super("thermal", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("thermal-state", () -> this.updateThermalState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.thermalState.setTickMillis(this.getTickPeriod());
        this.refrigGroup = RefrigUtils.getGroupName((AgentInfo)this.subsys.getAgentInfo());
        HashSet<Integer> heaters = new HashSet<Integer>();
        for (TrimHeaterControl trimHeaterControl : this.tempControlMap.values()) {
            int htr = trimHeaterControl.getPowerChannel();
            heaters.add(htr);
            this.trimHeaters[htr] = new TrimHeater(trimHeaterControl, trimHeaterControl.getPowerDevice(), htr);
        }
        for (Set set : validTrimHeaterSets) {
            if (!set.equals(heaters)) continue;
            this.trimHeaterSet = set;
            break;
        }
        if (this.trimHeaterSet == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"trim heater loop set", (String)"is not a valid one");
        }
        this.thermalState.setTrimHeaters(this.trimHeaterSet.toArray(this.thermalState.getTrimHeaters()));
        if (this.auxPowerNames == null) {
            LOG.info("No auxiliary heater devices specified");
        } else if (this.auxPowerNames.length > 3) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)"contains more than 3 items");
        } else {
            for (int htr = 0; htr < 3; ++htr) {
                PowerDevice power;
                String string;
                String string2 = string = htr < this.auxPowerNames.length ? this.auxPowerNames[htr] : null;
                if (string == null) {
                    LOG.log(Level.INFO, "Auxiliary heater {0} has not been specified", htr);
                    continue;
                }
                String[] words = string.split(":");
                if (words.length > 2) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains invalid item: " + string));
                }
                if ((power = this.powerDeviceMap.get(words[0])) == null) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains non-power item: " + words[0]));
                }
                int channel = 0;
                if (words.length == 2) {
                    try {
                        channel = Integer.decode(words[1]);
                    }
                    catch (NumberFormatException e) {
                        ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains invalid channel: " + words[1]));
                    }
                }
                this.auxHeaterSet.add(htr);
                this.auxHeaters[htr] = new AuxHeater(power, channel);
            }
        }
        this.thermalState.setAuxHeaters(this.auxHeaterSet.toArray(this.thermalState.getAuxHeaters()));
        if (this.coldTempNames == null) {
            LOG.severe("No cold-plate temperature monitoring channels specified");
        } else {
            for (String coldName : this.coldTempNames) {
                Channel chan = this.allChannels.get(coldName);
                if (chan == null) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"coldTempNames", (String)"contains non-channel item");
                }
                this.coldTemps.add(chan);
            }
        }
    }

    public void postStart() {
        Object heater;
        for (int htr : this.trimHeaterSet) {
            heater = this.trimHeaters[htr];
            this.thermalState.setTrimHeaterState(htr, !((TrimHeater)heater).powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (((TrimHeater)heater).powerDevc.isEnabled(((TrimHeater)heater).powerChan) ? TrimHeaterState.POWER : TrimHeaterState.OFF));
            ((TrimHeater)heater).tempCtrl.setPower(this.thermalState.getTrimHeaterPower(htr));
            ((TrimHeater)heater).tempCtrl.setTemp(this.thermalState.getPlateTemperature(htr));
        }
        for (int htr : this.auxHeaterSet) {
            heater = this.auxHeaters[htr];
            if (heater == null) continue;
            this.thermalState.setAuxHeaterState(htr, !((AuxHeater)heater).powerDevc.isOnline() ? AuxHeaterState.OFFLINE : (((AuxHeater)heater).powerDevc.isEnabled(((AuxHeater)heater).powerChan) ? AuxHeaterState.ON : AuxHeaterState.OFF));
        }
        LOG.info("Thermal control system started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            if (!this.refrigGroup.equals(RefrigUtils.getGroupName((AgentInfo)agent))) continue;
            this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType") || !this.refrigGroup.equals(RefrigUtils.getGroupName((AgentInfo)agent))) continue;
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        this.refrigColdState = (ColdState)msg.getState().getState(ColdState.class);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state", level=0)
    public ThermalState getSystemState() {
        return this.thermalState;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.thermalState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater operation state")
    public void setTrimHeaterState(int htr, TrimHeaterOpState state) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                TrimHeaterOpState oldState = this.thermalState.getTrimHeaterOpState(htr);
                if (state != oldState & this.thermalState.getTrimHeaterState(htr) != TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, state);
                    heater.tempCtrl.setOpState(state);
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power set point")
    public void setTrimHeaterPower(int htr, double power) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setTrimHeaterPower(htr, power);
                heater.tempCtrl.setPower(power);
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a plate temperature set point")
    public void setPlateTemperature(int htr, double temp) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setPlateTemperature(htr, temp);
                heater.tempCtrl.setTemp(temp);
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power enabled state")
    public void setAuxHeaterState(int htr, int value) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                this.getAuxHeater(htr);
                AuxHeaterState oldState = this.thermalState.getAuxHeaterState(htr);
                if (oldState != AuxHeaterState.OFFLINE && oldState != AuxHeaterState.DISABLD) {
                    AuxHeaterState newState;
                    AuxHeaterState auxHeaterState = newState = value != 0 ? AuxHeaterState.ON : AuxHeaterState.OFF;
                    if (newState != oldState) {
                        this.thermalState.setAuxHeaterState(htr, newState);
                        this.setAuxHeaterPower(htr);
                    }
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power set point")
    public void setAuxHeaterPower(int htr, double value) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                this.getAuxHeater(htr);
                this.thermalState.setAuxHeaterPower(htr, value);
                this.setAuxHeaterPower(htr);
            }
            finally {
                this.publishState();
            }
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.thermalState));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThermalState() {
        boolean coldHigh = false;
        for (Channel chan : this.coldTemps) {
            coldHigh |= chan.getValue() > this.coldTempLimit;
        }
        if (coldHigh) {
            coldHigh &= ++this.highTempCount >= 3;
        } else {
            this.highTempCount = 0;
        }
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            TrimHeaterState state;
            boolean changed = false;
            for (int htr : this.trimHeaterSet) {
                TrimHeaterState oldState;
                TrimHeater heater = this.trimHeaters[htr];
                state = coldHigh && htr != 0 ? TrimHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (heater.tempCtrl.isOverTemp() ? TrimHeaterState.OVRTEMP : (!heater.powerDevc.isEnabled(heater.powerChan) ? TrimHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? TrimHeaterState.VOLTERR : (heater.powerDevc.hasNoLoad(heater.powerChan) ? TrimHeaterState.NOLOAD : (this.thermalState.getTrimHeaterOpState(htr) == TrimHeaterOpState.TEMP ? TrimHeaterState.TEMP : TrimHeaterState.POWER))))));
                if (state == (oldState = this.thermalState.getTrimHeaterState(htr))) continue;
                this.thermalState.setTrimHeaterState(htr, state);
                if (state == TrimHeaterState.DISABLD) {
                    this.thermalState.setTrimHeaterOpState(htr, TrimHeaterOpState.OFF);
                    heater.tempCtrl.setOpState(TrimHeaterOpState.OFF);
                }
                changed = true;
            }
            boolean coldCompsOff = this.refrigColdState == ColdState.BOTH_OFF || this.refrigColdState == ColdState.UNKNOWN;
            for (int htr : this.auxHeaterSet) {
                AuxHeater heater = this.auxHeaters[htr];
                state = coldHigh || coldCompsOff ? AuxHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? AuxHeaterState.OFFLINE : (!heater.powerDevc.isEnabled(heater.powerChan) ? AuxHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? AuxHeaterState.VOLTERR : (heater.powerDevc.hasNoLoad(heater.powerChan) ? AuxHeaterState.NOLOAD : AuxHeaterState.ON))));
                if (state == this.thermalState.getAuxHeaterState(htr)) continue;
                this.thermalState.setAuxHeaterState(htr, (AuxHeaterState)state);
                this.setAuxHeaterPower(htr);
                changed = true;
            }
            if (changed) {
                this.publishState();
                if (coldHigh) {
                    this.raiseAlert(ThermalAlert.COLD_TEMP_HIGH, AlertState.ALARM, "At least one cold-plate RTD is above " + this.coldTempLimit + " C");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_TEMP_HIGH, "No cold-plate RTD is above " + this.coldTempLimit + " C");
                }
                if (coldCompsOff) {
                    this.raiseAlert(ThermalAlert.COLD_COMP_OFF, AlertState.ALARM, "Both cold compressors are turned off");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_COMP_OFF, "At least one cold compressor is back on");
                }
            }
        }
    }

    private void setAuxHeaterPower(int htr) {
        AuxHeater heater = this.auxHeaters[htr];
        if (ThermalConstants.auxOnStates.contains(this.thermalState.getAuxHeaterState(htr))) {
            heater.powerDevc.enableOutput(heater.powerChan, true);
            heater.powerDevc.setPower(heater.powerChan, this.thermalState.getAuxHeaterPower(htr));
        } else {
            heater.powerDevc.enableOutput(heater.powerChan, false);
        }
    }

    private void raiseAlert(ThermalAlert alert, AlertState state, String cond) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), true);
        if (wasActive != Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(), state, cond);
        }
    }

    private void lowerAlert(ThermalAlert alert, String cond) {
        Boolean wasActive = this.activeAlertMap.put(alert.getId(), false);
        if (wasActive == Boolean.TRUE) {
            this.alertService.raiseAlert(alert.newAlert(), AlertState.NOMINAL, cond);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    private TrimHeater getTrimHeater(int htr) throws RefrigException {
        if (!this.trimHeaterSet.contains(htr)) {
            throw new RefrigException("Invalid trim heater number: " + htr);
        }
        return this.trimHeaters[htr];
    }

    private AuxHeater getAuxHeater(int htr) throws RefrigException {
        if (!this.auxHeaterSet.contains(htr)) {
            throw new RefrigException("Invalid auxiliary heater number: " + htr);
        }
        return this.auxHeaters[htr];
    }

    static {
        LinkedHashSet<Integer> trimSet = new LinkedHashSet<Integer>();
        trimSet.add(1);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(4);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        trimSet = new LinkedHashSet();
        trimSet.add(3);
        trimSet.add(6);
        trimSet.add(5);
        trimSet.add(2);
        trimSet.add(0);
        validTrimHeaterSets.add(trimSet);
        LOG = Logger.getLogger(ThermalMain.class.getName());
    }

    static class AuxHeater {
        PowerDevice powerDevc;
        int powerChan;

        AuxHeater(PowerDevice powerDevc, int powerChan) {
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }

    static class TrimHeater {
        TrimHeaterControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;

        TrimHeater(TrimHeaterControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

