/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class SimCompMaq20Device
extends CompMaq20Device {
    private static final Logger LOG = Logger.getLogger(SimCompMaq20Device.class.getName());
    private final boolean[] coldSwitches = new boolean[1];
    private final boolean[] cryoSwitches = new boolean[4];
    private boolean[] switches;
    private final Map<String, Integer> channelMap = new HashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();
    private final Map<Integer, Double> valveMap = new HashMap<Integer, Double>();

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan >= 100) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        return new int[]{index, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return this.channelValues.get(type) + 0.2 * (Math.random() - 0.5);
    }

    @Override
    public void setType(int type) {
        this.switches = type == 0 ? this.coldSwitches : this.cryoSwitches;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw - 1] = on;
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw - 1];
    }

    @Override
    public void setValvePosition(int valve, double posn) {
        this.valveMap.put(valve, posn);
    }

    @Override
    public double getValvePosition(int valve) {
        Double value = this.valveMap.get(valve);
        return value == null ? 0.0 : value;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

