/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.A1000Device;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.constants.ColdCompValves;
import org.lsst.ccs.subsystem.refrig.constants.VfdState;
import org.lsst.ccs.subsystem.refrig.data.ColdCompState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class ColdCompressor
extends Compressor {
    private static final int[] maqChannels = new int[3];
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private A1000Device vfdDevc;
    private static final Logger LOG;
    private final ColdCompState coldState = (ColdCompState)this.getState();

    public ColdCompressor() {
        super((CompState)new ColdCompState());
    }

    @Override
    public void postInit() {
        if (this.vfdDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vfdDevc", (String)"not specified");
        }
        super.postInit();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the valid valve names", level=0)
    public List<String> getValveNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String vName : ColdCompValves.NAME_MAP.keySet()) {
            names.add(vName);
        }
        return names;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's valve position")
    public synchronized void setValvePosition(@Argument(description="Valve name") String valve, @Argument(description="Valve position") double posn) throws RefrigException {
        this.gotCommand = true;
        Integer valveId = (Integer)ColdCompValves.NAME_MAP.get(valve);
        if (valveId == null) {
            throw new RefrigException("Invalid cold valve name: " + valve);
        }
        this.maq20Devc.setValvePosition(maqChannels[valveId], posn);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's VFD frequency")
    public synchronized void setVfdFrequency(@Argument(description="Frequency") double freq) throws RefrigException {
        this.gotCommand = true;
        this.vfdDevc.setFrequency(freq);
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a cold compressor's VFD fault")
    public synchronized void resetVfdFault() throws RefrigException {
        this.gotCommand = true;
        this.vfdDevc.resetFault();
    }

    @Override
    protected synchronized boolean updateState() {
        VfdState vfdState;
        boolean changed = super.updateState();
        for (int valveId = 0; valveId < 3; ++valveId) {
            double posn = this.maq20Devc.getValvePosition(maqChannels[valveId]);
            if (this.areEqual(posn, this.coldState.getValvePosition(valveId))) continue;
            this.coldState.setValvePosition(valveId, posn);
            changed = true;
        }
        double freq = this.vfdDevc.getFrequency();
        if (!this.areEqual(freq, this.coldState.getVfdFrequency())) {
            this.coldState.setVfdFrequency(freq);
            changed = true;
        }
        if ((vfdState = this.vfdDevc.getState()) != this.coldState.getVfdState()) {
            this.coldState.setVfdState(vfdState);
            changed = true;
        }
        return changed;
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        ClearAlertHandler.ClearAlertCode code = this.vfdDevc.canClearAlert(alert);
        return code == null ? super.canClearAlert(alert) : code;
    }

    static {
        ColdCompressor.maqChannels[0] = 0;
        ColdCompressor.maqChannels[1] = 2;
        ColdCompressor.maqChannels[2] = 1;
        LOG = Logger.getLogger(ColdCompressor.class.getName());
    }
}

