/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.data.HexState;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;

public class HexMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    private static final Logger LOG = Logger.getLogger(HexMain.class.getName());
    private final HexState state = new HexState();
    private String refrigGroup;
    @ConfigurationParameter(isFinal=true)
    private volatile double rtnToEvapOffset = 0.3;

    public HexMain() {
        super("hex", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        String useFull = this.propertiesService.getAgentProperty("org.lsst.ccs.use.full.paths");
        if (useFull == null || !useFull.equals("true")) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"org.lsst.ccs.use.full.paths", (String)"not defined as true");
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("hexType", HexMain.class.getCanonicalName());
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.refrigGroup = RefrigUtils.getGroupName((AgentInfo)this.subsys.getAgentInfo());
    }

    public void postStart() {
        LOG.info("Heat exchanger subsystem started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            if (!RefrigUtils.getGroupName((AgentInfo)agent).equals(this.refrigGroup)) continue;
            this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType") || !RefrigUtils.getGroupName((AgentInfo)agent).equals(this.refrigGroup)) continue;
            this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        int tickMillis;
        StatusSubsystemData sd = (StatusSubsystemData)msg;
        if (sd.getDataKey().equals("UpdatePeriod") && (tickMillis = ((UpdatePeriod)sd.getSubsystemData().getValue()).getTickMillis()) != this.getTickPeriod()) {
            this.setTickPeriod(tickMillis);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the heat exchanger state", level=0)
    public HexState getSystemState() {
        this.state.setTickMillis(this.getTickPeriod());
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    private void publishState() {
        this.state.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("HexState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    double getRtnToEvapOffset() {
        return this.rtnToEvapOffset;
    }
}

