/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.A1000Device;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompMaq20PWMControl;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.FanControl;
import org.lsst.ccs.subsystem.refrig.constants.CompAlert;
import org.lsst.ccs.subsystem.refrig.constants.CompSwConds;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class Compressor
implements HasLifecycle {
    private static final String COMP_LIMITS = "CompLimits";
    private static final int MIN_SW_STATE_SITS = 5;
    private static final Map<Integer, CompAlert> ccsAlertMap = new HashMap<Integer, CompAlert>();
    private static final Map<Integer, CompAlert> plcAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompMaq20Device maq20Devc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private A1000Device vfdDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CompMaq20PWMControl pwmControl;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FanControl fanControl;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discPressImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discPressDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int discPressDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int discTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double suctTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double cmprPowerImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double cmprPowerDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int cmprPowerDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double phaseSepTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int phaseSepTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double liquidTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double liquidTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int liquidTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double coldTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double pressDiffImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discTempLowImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double orificeOffPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double orificeOnPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double heaterTempLimit;
    protected String discPressChan;
    protected String discTempChan;
    protected String suctPressChan;
    protected String suctTempChan;
    protected String cmprPowerChan;
    protected String phaseSepTempChan;
    protected String liquidTempChan;
    private static final Logger LOG;
    private final CompState state;
    private final SwitchDevice[] switchDevices;
    private final int[] switchChannels;
    private final int type;
    private Channel discPress;
    private Channel discTemp;
    private Channel suctPress;
    private Channel suctTemp;
    private Channel cmprPower;
    private Channel phaseSepTemp;
    private Channel liquidTemp;
    private int activeConds = 0;
    private boolean gotCommand = false;
    private final LatchState[] savedLatchStates = new LatchState[10];
    private final LimitData[] limitData = new LimitData[10];
    private final SwCondState[] savedSwStates = new SwCondState[10];
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private final AlertEnableSwitch alertEnableSwitch = new AlertEnableSwitch();
    private boolean powerEnabled = false;
    private boolean alertsEnabled = false;

    public Compressor(CompState state) {
        this.state = state;
        this.type = state.getType();
        this.switchDevices = new SwitchDevice[8];
        this.switchChannels = new int[8];
        for (int j = 0; j < 10; ++j) {
            this.limitData[j] = new LimitData();
        }
    }

    public void postInit() {
        if (this.plutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"plutoDevc", (String)"not specified");
        }
        if (this.maq20Devc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maq20Devc", (String)"not specified");
        }
        if (this.type == 0 && this.vfdDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vfdDevc", (String)"not specified");
        }
        if (this.discTempChan != null) {
            this.discTemp = this.channelMap.get(this.discTempChan);
        }
        if (this.discTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discTempChan", (String)"not specified or not defined");
        }
        if (this.suctTempChan != null) {
            this.suctTemp = this.channelMap.get(this.suctTempChan);
        }
        if (this.suctTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctTempChan", (String)"not specified or not defined");
        }
        if (this.discPressChan != null) {
            this.discPress = this.channelMap.get(this.discPressChan);
        }
        if (this.discPress == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discPressChan", (String)"not specified or not defined");
        }
        if (this.cmprPowerChan != null) {
            this.cmprPower = this.channelMap.get(this.cmprPowerChan);
        }
        if (this.cmprPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"cmprPowerChan", (String)"not specified or not defined");
        }
        this.limitData[0].channel = this.discPress;
        this.limitData[1].channel = this.discTemp;
        this.limitData[2].channel = this.suctTemp;
        this.limitData[2].isLower = true;
        this.limitData[2].delayLimit = Double.NaN;
        this.limitData[3].channel = this.cmprPower;
        this.switchDevices[0] = this.plutoDevc;
        this.switchChannels[0] = 0;
        this.switchDevices[2] = this.plutoDevc;
        this.switchChannels[2] = 1;
        this.switchDevices[7] = this.alertEnableSwitch;
        if (this.type == 0) {
            if (this.liquidTempChan != null) {
                this.liquidTemp = this.channelMap.get(this.liquidTempChan);
            }
            if (this.liquidTemp == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"liquidTempChan", (String)"not specified or not defined");
            }
            this.limitData[7].channel = this.liquidTemp;
        } else {
            this.limitData[0].delayTime = -1;
            if (this.phaseSepTempChan != null) {
                this.phaseSepTemp = this.channelMap.get(this.phaseSepTempChan);
            }
            if (this.phaseSepTemp == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"phaseSepTempChan", (String)"not specified or not defined");
            }
            if (this.suctPressChan != null) {
                this.suctPress = this.channelMap.get(this.suctPressChan);
            }
            if (this.suctPress == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctPressChan", (String)"not specified or not defined");
            }
            this.limitData[4].channel = this.phaseSepTemp;
            this.limitData[4].immedLimit = Double.NaN;
            this.limitData[9].channel = this.discTemp;
            this.limitData[9].isLower = true;
            this.limitData[9].noShutoff = true;
            this.limitData[9].delayLimit = Double.NaN;
            this.limitData[8].channel = this.discPress;
            this.limitData[8].channel2 = this.suctPress;
            this.limitData[8].noShutoff = true;
            this.limitData[8].delayLimit = Double.NaN;
            this.switchDevices[1] = this.plutoDevc;
            this.switchChannels[1] = 2;
            this.switchDevices[3] = this.maq20Devc;
            this.switchChannels[3] = 2;
            this.switchDevices[4] = this.maq20Devc;
            this.switchChannels[4] = 1;
            this.switchDevices[5] = this.maq20Devc;
            this.switchChannels[5] = 3;
            this.switchDevices[6] = this.maq20Devc;
            this.switchChannels[6] = 4;
        }
        this.state.setName(this.name);
        this.plutoDevc.setType(this.type);
        this.maq20Devc.setType(this.type);
        if (this.fanControl != null) {
            LOG.log(Level.INFO, "Compressor {0} has an associated fan speed controller", this.name);
        }
    }

    @ConfigurationParameterChanger
    public void setDiscPressImmedLimit(double value) {
        this.discPressImmedLimit = value;
        this.limitData[0].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayLimit(double value) {
        this.discPressDelayLimit = value;
        this.limitData[0].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayTime(int value) {
        this.discPressDelayTime = value;
        if (this.type == 0) {
            this.limitData[0].delayTime = 1000 * value;
        }
    }

    @ConfigurationParameterChanger
    public void setDiscTempImmedLimit(double value) {
        this.discTempImmedLimit = value;
        this.limitData[1].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayLimit(double value) {
        this.discTempDelayLimit = value;
        this.limitData[1].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayTime(int value) {
        this.discTempDelayTime = value;
        this.limitData[1].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setSuctTempImmedLimit(double value) {
        this.suctTempImmedLimit = value;
        this.limitData[2].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerImmedLimit(double value) {
        this.cmprPowerImmedLimit = value;
        this.limitData[3].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayLimit(double value) {
        this.cmprPowerDelayLimit = value;
        this.limitData[3].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayTime(int value) {
        this.cmprPowerDelayTime = value;
        this.limitData[3].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempImmedLimit(double value) {
        this.liquidTempImmedLimit = value;
        if (this.type == 0) {
            this.limitData[7].immedLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayLimit(double value) {
        this.liquidTempDelayLimit = value;
        if (this.type == 0) {
            this.limitData[7].delayLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayTime(int value) {
        this.liquidTempDelayTime = value;
        if (this.type == 0) {
            this.limitData[7].delayTime = 1000 * value;
        }
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayLimit(double value) {
        this.phaseSepTempDelayLimit = value;
        if (this.type == 1) {
            this.limitData[4].delayLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayTime(int value) {
        this.phaseSepTempDelayTime = value;
        if (this.type == 1) {
            this.limitData[4].delayTime = 1000 * value;
        }
    }

    @ConfigurationParameterChanger
    public void setDiscTempLowImmedLimit(double value) {
        this.discTempLowImmedLimit = value;
        this.limitData[9].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setPressDiffImmedLimit(double value) {
        this.pressDiffImmedLimit = value;
        this.limitData[8].immedLimit = value;
    }

    public void setIndex(int index) {
        this.state.setIndex(index);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    @Command(type=Command.CommandType.ACTION, description="Set a compressor's switch state")
    public synchronized void setSwitchOn(@Argument(description="Switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        this.gotCommand = true;
        if (!this.state.getValidSwitches().contains(sw)) {
            throw new RefrigException("Invalid switch number: " + sw);
        }
        if (sw != 0 || !on || this.activeConds == 0) {
            this.setSwitch(sw, on);
            if (sw == 0) {
                this.powerEnabled = on;
            }
        }
        if (sw == 0) {
            this.alertEnableSwitch.setSwitchOn(0, on);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a compressor's latches")
    public synchronized void resetLatches() {
        this.gotCommand = true;
        this.plutoDevc.resetLatches();
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's bypass valve")
    public synchronized void setBypassValve(@Argument(description="Valve position") double posn) throws RefrigException {
        this.gotCommand = true;
        if (this.type != 0) {
            throw new RefrigException("Compressor type must be COLD");
        }
        this.maq20Devc.setBypassValve(posn);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's coolant valve")
    public synchronized void setCoolantValve(@Argument(description="Valve position") double posn) throws RefrigException {
        this.gotCommand = true;
        if (this.type != 0) {
            throw new RefrigException("Compressor type must be COLD");
        }
        this.maq20Devc.setCoolantValve(posn);
    }

    @Command(type=Command.CommandType.ACTION, description="Set a cold compressor's VFD frequency")
    public synchronized void setVfdFrequency(@Argument(description="Valve position") double freq) throws RefrigException {
        this.gotCommand = true;
        if (this.type != 0) {
            throw new RefrigException("Compressor type must be COLD");
        }
        this.vfdDevc.setFrequency(freq);
    }

    public synchronized boolean updateSystem() {
        this.checkLimits();
        boolean changed = this.updateState();
        return changed;
    }

    public CompState getState() {
        return this.state;
    }

    private synchronized void checkLimits() {
        for (int cond : this.state.getValidSwConditions()) {
            LimitData ld = this.limitData[cond];
            if (ld.channel == null) continue;
            double value = ld.channel.getValue();
            if (ld.channel2 != null) {
                value = Math.abs(value - ld.channel2.getValue());
            }
            long endTime = ld.endTime;
            SwCondState swState = ld.swState;
            if (!ld.isLower && value > ld.immedLimit || ld.isLower && value < ld.immedLimit) {
                endTime = -1L;
                swState = SwCondState.ACTIVE;
            } else if (!ld.isLower && value > ld.delayLimit || ld.isLower && value < ld.delayLimit) {
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + (long)ld.delayTime;
                    swState = SwCondState.DLYPEND;
                }
                if (endTime >= 0L && (ld.delayTime < 0 && this.state.getConditionState(14) == ConditionState.YES || ld.delayTime >= 0 && System.currentTimeMillis() > endTime)) {
                    endTime = -1L;
                    swState = SwCondState.DLYACTV;
                }
            } else {
                endTime = 0L;
                swState = SwCondState.CLEAR;
            }
            if (swState != ld.provSwState) {
                ld.provCount = 0;
                ld.provSwState = swState;
            }
            if (++ld.provCount < 5 || ld.provSwState == ld.swState) continue;
            ld.value = value;
            ld.swState = ld.provSwState;
            ld.endTime = endTime;
            if (endTime < 0L) {
                this.setCondition(cond);
                continue;
            }
            this.clearCondition(cond);
        }
    }

    private synchronized boolean updateState() {
        boolean stateChanged;
        Enum swState;
        boolean changed = this.gotCommand;
        this.gotCommand = false;
        CompressorState compState = this.plutoDevc.isPLCActive() == Boolean.FALSE ? CompressorState.PLC_DEAD : null;
        for (int sw : this.state.getValidSwitches()) {
            Boolean on = this.switchDevices[sw].isSwitchOn(this.switchChannels[sw]);
            swState = on == null ? SwitchState.OFFLINE : (on != false ? SwitchState.ON : SwitchState.OFF);
            if (swState == this.state.getSwitchState(sw)) continue;
            this.state.setSwitchState(sw, (SwitchState)swState);
            changed = true;
        }
        this.powerEnabled = true;
        for (int cond : this.state.getValidConditions()) {
            ConditionState condState = this.plutoDevc.getConditionState(cond);
            if (condState == ConditionState.OFF && compState == null) {
                compState = CompressorState.OFFLINE;
            }
            if (cond == 3 && condState != ConditionState.YES) {
                this.powerEnabled = false;
            }
            if (condState == this.state.getConditionState(cond)) continue;
            this.state.setConditionState(cond, condState);
            changed = true;
        }
        this.alertEnableSwitch.setSwitchOn(0, this.alertsEnabled);
        for (int cond : this.state.getValidLatches()) {
            LatchState oldLatchState;
            LatchState latchState = this.plutoDevc.getLatchState(cond);
            if (latchState != (oldLatchState = this.state.getLatchState(cond))) {
                this.state.setLatchState(cond, latchState);
                changed = true;
            }
            LatchState savedLatchState = this.savedLatchStates[cond];
            if (this.alertsEnabled) {
                if ((savedLatchState == null || latchState == savedLatchState) && (savedLatchState != null || latchState == oldLatchState)) continue;
                this.raisePlcAlert(cond, latchState, savedLatchState == null ? oldLatchState : savedLatchState);
                this.savedLatchStates[cond] = null;
                continue;
            }
            if (savedLatchState != null || latchState == oldLatchState) continue;
            this.savedLatchStates[cond] = oldLatchState;
        }
        for (int cond : this.state.getValidSwConditions()) {
            SwCondState oldSwState;
            LimitData ld = this.limitData[cond];
            Enum enum_ = swState = ld.noShutoff && this.powerEnabled ? SwCondState.CLEAR : ld.swState;
            if (compState == null && (swState == SwCondState.ACTIVE || swState == SwCondState.DLYACTV)) {
                compState = CompressorState.SW_DSAB;
            }
            if (swState != (oldSwState = this.state.getSwConditionState(cond))) {
                this.state.setSwConditionState(cond, (SwCondState)swState);
                changed = true;
            }
            SwCondState savedSwState = this.savedSwStates[cond];
            if (this.alertsEnabled) {
                if ((savedSwState == null || swState == savedSwState) && (savedSwState != null || swState == oldSwState)) continue;
                this.raiseCcsAlert(cond, ld, (SwCondState)swState);
                this.savedSwStates[cond] = null;
                continue;
            }
            if (savedSwState != null || swState == oldSwState) continue;
            this.savedSwStates[cond] = oldSwState;
        }
        if (compState == null) {
            compState = this.state.getConditionState(2) == ConditionState.YES ? CompressorState.WAITING : (this.state.getConditionState(3) == ConditionState.YES ? CompressorState.RUNNING : (this.state.getConditionState(11) == ConditionState.NO ? CompressorState.HW_DSAB : CompressorState.STOPPED));
        }
        boolean bl = stateChanged = compState != this.state.getCompressorState();
        if (stateChanged) {
            this.state.setCompressorState(compState);
            changed = true;
        }
        if (this.type == 0) {
            double freq;
            double posn = this.maq20Devc.getBypassValve();
            if (!this.areEqual(posn, this.state.getBypassValve())) {
                this.state.setBypassValve(posn);
                changed = true;
            }
            if (!this.areEqual(freq = this.vfdDevc.getFrequency(), this.state.getVfdFrequency())) {
                this.state.setVfdFrequency(freq);
                changed = true;
            }
            if (!this.areEqual(posn = this.maq20Devc.getCoolantValve(), this.state.getCoolantValve())) {
                this.state.setCoolantValve(posn);
                changed = true;
            }
        }
        if (this.type == 1) {
            this.controlCryoValves(compState == CompressorState.RUNNING, stateChanged);
            this.controlCryoFan(compState == CompressorState.RUNNING, stateChanged);
            this.controlCryoHeater();
        }
        return changed;
    }

    private void raisePlcAlert(int cond, LatchState latchState, LatchState oldLatchState) {
        CompAlert alert = plcAlertMap.get(cond);
        if (latchState == LatchState.ACTIVE) {
            this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
        } else if (latchState == LatchState.WARNING) {
            this.raiseAlert(alert, AlertState.WARNING, this.name + " PLC warning condition set");
        } else {
            if (latchState == LatchState.LATCHED && oldLatchState == LatchState.CLEAR) {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
            }
            this.lowerAlert(alert, this.name + " PLC error condition cleared");
        }
    }

    private void raiseCcsAlert(int cond, LimitData ld, SwCondState swState) {
        CompAlert alert = ccsAlertMap.get(cond);
        String value = String.format("%.1f", ld.value);
        if (swState == SwCondState.ACTIVE) {
            this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS immediate error condition set: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.immedLimit);
        } else if (swState == SwCondState.DLYACTV) {
            String timeText = ld.delayTime >= 0 ? " for " + ld.delayTime / 1000 + " sec" : " and compressor on for 8 hours";
            this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS delayed error condition set: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.delayLimit + timeText);
        } else if (swState == SwCondState.DLYPEND) {
            this.raiseAlert(alert, AlertState.WARNING, this.name + " CCS delayed error condition pending: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.delayLimit);
        } else {
            this.lowerAlert(alert, this.name + " CCS error condition cleared: value = " + value);
        }
    }

    private void controlCryoValves(boolean compOn, boolean changed) {
        try {
            if (compOn) {
                double press = this.limitData[0].channel.getValue();
                if (press > this.orificeOffPress) {
                    this.setSwitch(3, false);
                } else if (press < this.orificeOnPress) {
                    this.setSwitch(3, true);
                }
            }
            if (changed) {
                if (compOn) {
                    this.setSwitch(5, false);
                } else {
                    this.setSwitch(3, false);
                }
                this.setSwitch(4, !compOn);
            }
        }
        catch (RefrigException e) {
            LOG.log(Level.SEVERE, "Error operating {0} compressor valves: {1}", new Object[]{this.name, e});
        }
    }

    private void controlCryoHeater() {
        double temp = this.discTemp.getValue();
        if (temp > this.heaterTempLimit && this.state.getSwitchState(1) == SwitchState.ON) {
            LOG.log(Level.WARNING, "Turning {0} compressor heater off - discharge temperature ({1}) > {2}", new Object[]{this.name, temp, this.heaterTempLimit});
            try {
                this.setSwitch(1, false);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error operating {0} compressor heater: {1}", new Object[]{this.name, e});
            }
        }
    }

    private void controlCryoFan(boolean compOn, boolean changed) {
        if (changed && this.pwmControl != null) {
            if (compOn) {
                this.pwmControl.enable();
            } else {
                this.pwmControl.disable();
            }
        }
    }

    private void setSwitch(int sw, boolean on) throws RefrigException {
        this.switchDevices[sw].setSwitchOn(this.switchChannels[sw], on);
    }

    private void setCondition(int cond) {
        LOG.log(Level.FINE, "{0} compressor encountered \"{1}\" condition", new Object[]{this.name, CompSwConds.DESCS[cond]});
        if (!this.limitData[cond].noShutoff) {
            try {
                this.setSwitchOn(0, false);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error shutting off {0} compressor: {1}", new Object[]{this.name, e});
            }
        }
        this.activeConds |= 1 << cond;
    }

    private void clearCondition(int cond) {
        this.activeConds &= ~(1 << cond);
    }

    private void raiseAlert(CompAlert alert, AlertState state, String cond) {
        this.activeAlertMap.put(alert.getId(this.name), true);
        this.alertService.raiseAlert(alert.newAlert(this.name), state, cond);
    }

    private void lowerAlert(CompAlert alert, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(this.name), false);
        if (active != null && active.booleanValue()) {
            this.alertService.raiseAlert(alert.newAlert(this.name), AlertState.NOMINAL, cond);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    private boolean areEqual(double value1, double value2) {
        return value1 == value2 || Double.isNaN(value1) && Double.isNaN(value2);
    }

    static {
        ccsAlertMap.put(0, CompAlert.DISC_PRESS_HIGH);
        ccsAlertMap.put(1, CompAlert.DISC_TEMP_HIGH);
        ccsAlertMap.put(3, CompAlert.COMP_POWER_HIGH);
        ccsAlertMap.put(7, CompAlert.LIQD_TEMP_HIGH);
        ccsAlertMap.put(6, CompAlert.OIL_LEVEL_LOW);
        ccsAlertMap.put(2, CompAlert.SUCT_TEMP_LOW);
        ccsAlertMap.put(4, CompAlert.PHASE_TEMP_HIGH);
        ccsAlertMap.put(5, CompAlert.CRYO_TEMP_LOW);
        ccsAlertMap.put(8, CompAlert.PRESS_DIFF_HIGH);
        ccsAlertMap.put(9, CompAlert.DISC_TEMP_LOW);
        plcAlertMap = new HashMap<Integer, CompAlert>();
        plcAlertMap.put(3, CompAlert.DISC_PRESS_HIGH_PLC);
        plcAlertMap.put(0, CompAlert.DISC_TEMP_HIGH_PLC);
        plcAlertMap.put(4, CompAlert.COMP_POWER_HIGH_PLC);
        plcAlertMap.put(2, CompAlert.LIQD_TEMP_HIGH_PLC);
        plcAlertMap.put(9, CompAlert.OIL_LEVEL_LOW_PLC);
        plcAlertMap.put(1, CompAlert.SUCT_TEMP_LOW_PLC);
        plcAlertMap.put(8, CompAlert.AFTER_TEMP_HIGH_PLC);
        plcAlertMap.put(7, CompAlert.SENS_READ_BAD_PLC);
        plcAlertMap.put(6, CompAlert.SMOKE_DETC_PLC);
        plcAlertMap.put(5, CompAlert.EXT_PERMIT_PLC);
        LOG = Logger.getLogger(Compressor.class.getName());
    }

    public static class LimitData {
        private Channel channel = null;
        private Channel channel2 = null;
        private boolean isLower = false;
        private boolean noShutoff = false;
        private double immedLimit = 0.0;
        private double delayLimit = 0.0;
        private int delayTime = 0;
        private double value = 0.0;
        private long endTime = 0L;
        private SwCondState swState = SwCondState.CLEAR;
        private SwCondState provSwState = SwCondState.CLEAR;
        private int provCount = 0;
    }

    class AlertEnableSwitch
    implements SwitchDevice {
        AlertEnableSwitch() {
        }

        @Override
        public void setSwitchOn(int chan, boolean on) {
            Compressor.this.alertsEnabled = Compressor.this.powerEnabled ? true : on;
        }

        @Override
        public Boolean isSwitchOn(int chan) {
            return Compressor.this.alertsEnabled;
        }
    }

    public static interface SwitchDevice {
        public void setSwitchOn(int var1, boolean var2) throws RefrigException;

        public Boolean isSwitchOn(int var1);
    }
}

