/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.yaskawa.A1000;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class A1000Device
extends Device {
    public static final int CHAN_FREQUENCY = 0;
    public static final int CHAN_CURRENT = 1;
    public static final int CHAN_VOLTAGE = 2;
    public static final int NUM_CHANS = 3;
    private static final double INPUT_VOLTAGE = 380.0;
    @ConfigurationParameter(category="Device", isFinal=true)
    private String devcName;
    @ConfigurationParameter(category="Device", isFinal=true)
    private int baudRate = 0;
    @ConfigurationParameter(category="Device", isFinal=true)
    private int address = 0;
    private static final Logger LOG = Logger.getLogger(A1000Device.class.getName());
    private final A1000 a1000 = new A1000();
    private boolean initError = false;
    private final int MAX_READ = 16;

    protected void initDevice() {
        super.configure(this.mon);
        if (this.devcName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"devcName", (String)"is missing");
        }
        this.fullName = "A1000 VFD (" + this.devcName + ":" + this.address + ")";
    }

    protected void initialize() {
        try {
            this.a1000.open(this.devcName, this.address, this.baudRate);
            try {
                if ((this.a1000.getDriveStatus() & 1) == 0) {
                    this.initParams();
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error initializing {0} parameters: {1}", new Object[]{this.fullName, e});
            }
            this.setOnline(true);
            this.initSensors();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
        }
        catch (DriverException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.a1000.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.a1000.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public void setFrequency(double freq) throws RefrigException {
        try {
            this.a1000.setFrequency(freq);
        }
        catch (DriverException e) {
            this.setOnline(false);
            throw new RefrigException("Error setting frequency for " + this.getPath() + ": " + (Object)((Object)e));
        }
    }

    public double getFrequency() {
        double value = Double.NaN;
        if (this.isOnline()) {
            try {
                value = this.a1000.getFrequencyApp();
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error getting frequency for {0}: {1}", new Object[]{this.getPath(), e});
                this.setOnline(false);
            }
        }
        return value;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        String quantity = null;
        if (this.online) {
            try {
                switch (hwChan) {
                    case 0: {
                        quantity = "frequency";
                        value = this.a1000.readFrequency();
                        break;
                    }
                    case 1: {
                        quantity = "current";
                        value = this.a1000.readCurrent();
                        break;
                    }
                    case 2: {
                        quantity = "voltage";
                        value = this.a1000.readVoltage();
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading VFD {0}: {1}", new Object[]{quantity, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    @Command(description="Initialize parameters")
    public void initParams() throws DriverException {
        this.a1000.setAccessLevel(A1000.AccessLevel.FULL);
        this.a1000.setRunCmndFwdRev(true);
        this.a1000.setRunProg(A1000.RunProg.RUN_ONLY);
        this.a1000.setStopMethod(A1000.StopMethod.COAST);
        this.a1000.setControlMode(A1000.ControlMode.VF);
        this.a1000.setErrorAction(A1000.ErrorAction.ALARM_ONLY);
        this.a1000.setFaultDetected(false);
        this.a1000.setInputVoltage(380.0);
        this.a1000.setVfSelection(A1000.VfSelection.HZ50);
        this.a1000.setVoltageUnits(A1000.VoltageUnits.TENTHS);
        this.a1000.setEnterRequired(false);
        this.a1000.setReversePermitted(false);
        this.a1000.setRunCmndSrc(A1000.RunCmndSrc.MODBUS);
        this.a1000.setFreqRefSrc(A1000.FreqRefSrc.MODBUS);
        this.a1000.enterParameters();
        this.a1000.runForward();
        this.a1000.runForward();
    }

    @Command(description="Read a register")
    public String readRegister(@Argument(description="Register to read") int number) throws DriverException {
        return String.format("%04x: %04x", number, this.a1000.readRegister((short)number));
    }

    @Command(description="Read a set of registers")
    public String readRegisters(@Argument(description="First register to read") int number, @Argument(description="Number of registers to read") int count) {
        StringBuilder text = new StringBuilder();
        int lineSize = 8;
        int nRead = 0;
        try {
            while (nRead < count) {
                short[] reply = this.a1000.readRegisters((short)number, (short)Math.min(count - nRead, 16));
                int j = 0;
                while (j < reply.length) {
                    if (nRead % lineSize == 0) {
                        if (nRead != 0) {
                            text.append("\n");
                        }
                        text.append(String.format("%04x:", number));
                    }
                    text.append(String.format(" %04x", reply[j]));
                    ++j;
                    ++nRead;
                    ++number;
                }
            }
        }
        catch (DriverException e) {
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append("***** Got read error: ").append(e.getMessage());
        }
        return text.toString();
    }

    @Command(description="Show node address")
    public int showNodeAddress() throws DriverException {
        return this.a1000.getNodeAddress();
    }

    @Command(description="Show baud rate")
    public String showBaudRate() throws DriverException {
        return this.a1000.getBaudRate().toString().substring(1);
    }

    @Command(description="Show parity")
    public A1000.Parity showParity() throws DriverException {
        return this.a1000.getParity();
    }

    @Command(description="Show access level")
    public A1000.AccessLevel showAccessLevel() throws DriverException {
        return this.a1000.getAccessLevel();
    }

    @Command(description="Show control mode")
    public A1000.ControlMode showControlMode() throws DriverException {
        return this.a1000.getControlMode();
    }

    @Command(description="Show whether enter required")
    public boolean isEnterRequired() throws DriverException {
        return this.a1000.isEnterRequired();
    }

    @Command(description="Show communications error action")
    public A1000.ErrorAction showErrorAction() throws DriverException {
        return this.a1000.getErrorAction();
    }

    @Command(description="Show whether fault detected")
    public boolean isFaultDetected() throws DriverException {
        return this.a1000.isFaultDetected();
    }

    @Command(description="Show frequency reference source")
    public A1000.FreqRefSrc showFreqRefSrc() throws DriverException {
        return this.a1000.getFreqRefSrc();
    }

    @Command(description="Show input voltage")
    public double showInputVoltage() throws DriverException {
        return this.a1000.getInputVoltage();
    }

    @Command(description="Show whether reverse permitted")
    public boolean isReversePermitted() throws DriverException {
        return this.a1000.isReversePermitted();
    }

    @Command(description="Show whether run command style is forward/reverse")
    public boolean isRunCmndFwdRev() throws DriverException {
        return this.a1000.isRunCmndFwdRev();
    }

    @Command(description="Show run command source")
    public A1000.RunCmndSrc showRunCmndSrc() throws DriverException {
        return this.a1000.getRunCmndSrc();
    }

    @Command(description="Show run/program interaction")
    public A1000.RunProg showRunProg() throws DriverException {
        return this.a1000.getRunProg();
    }

    @Command(description="Show the stop method")
    public A1000.StopMethod showStopMethod() throws DriverException {
        return this.a1000.getStopMethod();
    }

    @Command(description="Show V/f profile selection")
    public A1000.VfSelection showVfSelection() throws DriverException {
        return this.a1000.getVfSelection();
    }

    @Command(description="Show voltge units")
    public A1000.VoltageUnits showVoltageUnits() throws DriverException {
        return this.a1000.getVoltageUnits();
    }

    @Command(description="Show the reference frequency")
    public double showFrequency() throws DriverException {
        return this.a1000.getFrequency();
    }

    @Command(description="Show the applied reference frequency")
    public double showFrequencyApp() throws DriverException {
        return this.a1000.getFrequencyApp();
    }

    @Command(description="Read the frequency")
    public double readFrequency() throws DriverException {
        return this.a1000.readFrequency();
    }

    @Command(description="Read the current")
    public double readCurrent() throws DriverException {
        return this.a1000.readCurrent();
    }

    @Command(description="Read the voltage")
    public double readVoltage() throws DriverException {
        return this.a1000.readVoltage();
    }

    @Command(description="Read the bus voltage")
    public double readBusVoltage() throws DriverException {
        return this.a1000.readBusVoltage();
    }

    @Command(description="Show the drive status")
    public String showDriveStatus() throws DriverException {
        return String.format("0x%02x", this.a1000.getDriveStatus());
    }

    @Command(level=50, description="Write a set of registers")
    public void writeRegisters(@Argument(description="First register to write") int number, int ... values) throws DriverException {
        int count = values.length;
        if (count == 0) {
            throw new DriverException("No values supplied");
        }
        short[] sValues = new short[count];
        for (int j = 0; j < count; ++j) {
            sValues[j] = (short)values[j];
        }
        this.a1000.writeRegisters((short)number, sValues);
    }

    @Command(level=50, description="Enter parameters")
    public void enterParameters() throws DriverException {
        this.a1000.enterParameters();
    }

    @Command(level=50, description="Save parameters")
    public void saveParameters() throws DriverException {
        this.a1000.saveParameters();
    }

    @Command(level=50, description="Set node address")
    public void setNodeAddress(@Argument(description="Node address") int address) throws DriverException {
        this.a1000.setNodeAddress(address);
    }

    @Command(level=50, description="Set baud rate")
    public void setBaudRate(@Argument(description="Baud rate enum") A1000.BaudRate baudRate) throws DriverException {
        this.a1000.setBaudRate(baudRate);
    }

    @Command(level=50, description="Set parity")
    public void setParity(@Argument(description="Parity enum") A1000.Parity parity) throws DriverException {
        this.a1000.setParity(parity);
    }

    @Command(level=50, description="Set access level")
    public void setAccessLevel(@Argument(description="Access level enum") A1000.AccessLevel level) throws DriverException {
        this.a1000.setAccessLevel(level);
    }

    @Command(level=50, description="Set control mode")
    public void setControlMode(@Argument(description="Control mode enum") A1000.ControlMode mode) throws DriverException {
        this.a1000.setControlMode(mode);
    }

    @Command(level=50, description="Set whether enter required")
    public void setEnterRequired(@Argument(description="Whether enter required") boolean required) throws DriverException {
        this.a1000.setEnterRequired(required);
    }

    @Command(level=50, description="Set communications error action")
    public void setErrorAction(@Argument(description="Error action enum") A1000.ErrorAction action) throws DriverException {
        this.a1000.setErrorAction(action);
    }

    @Command(level=50, description="Set whether fault detected")
    public void setFaultDetected(@Argument(description="Whether fault detected") boolean detect) throws DriverException {
        this.a1000.setFaultDetected(detect);
    }

    @Command(level=50, description="Set frequency reference source")
    public void setFreqRefSrc(@Argument(description="Freq refc source enum") A1000.FreqRefSrc source) throws DriverException {
        this.a1000.setFreqRefSrc(source);
    }

    @Command(level=50, description="Set the input voltage")
    public void setInputVoltage(@Argument(description="The voltage") double voltage) throws DriverException {
        this.a1000.setInputVoltage(voltage);
    }

    @Command(level=50, description="Set whether reverse permitted")
    public void setReversePermitted(@Argument(description="Whether reverse permitted") boolean permit) throws DriverException {
        this.a1000.setReversePermitted(permit);
    }

    @Command(level=50, description="Set whether run command style is forward/reverse")
    public void setRunCmndFwdRev(@Argument(description="Whether forward/reverse") boolean fwdRev) throws DriverException {
        this.a1000.setRunCmndFwdRev(fwdRev);
    }

    @Command(level=50, description="Set run command source")
    public void setRunCmndSrc(@Argument(description="Run cmnd source enum") A1000.RunCmndSrc source) throws DriverException {
        this.a1000.setRunCmndSrc(source);
    }

    @Command(level=50, description="Set run/program interaction")
    public void setRunProg(@Argument(description="Run/program enum") A1000.RunProg runProg) throws DriverException {
        this.a1000.setRunProg(runProg);
    }

    @Command(level=50, description="Set the stop method")
    public void setStopMethod(@Argument(description="Stop method enum") A1000.StopMethod method) throws DriverException {
        this.a1000.setStopMethod(method);
    }

    @Command(level=50, description="Set V/f profile selection")
    public void setVfSelection(@Argument(description="V/f selection enum") A1000.VfSelection select) throws DriverException {
        this.a1000.setVfSelection(select);
    }

    @Command(level=50, description="Set voltage units")
    public void setVoltageUnits(@Argument(description="Voltage units enum") A1000.VoltageUnits units) throws DriverException {
        this.a1000.setVoltageUnits(units);
    }

    @Command(level=50, description="Run the motor forwards")
    public void runForward() throws DriverException {
        this.a1000.runForward();
    }

    @Command(level=50, description="Run the motor in reverse")
    public void runReverse() throws DriverException {
        this.a1000.runReverse();
    }

    @Command(level=50, description="Stop the motor")
    public void stop() throws DriverException {
        this.a1000.stop();
    }
}

