/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.A1000Device;

public class SimA1000Device
extends A1000Device {
    private static final Logger LOG = Logger.getLogger(SimA1000Device.class.getName());
    private double frequency;

    @Override
    protected void initDevice() {
    }

    @Override
    protected void initialize() {
        this.setOnline(true);
    }

    @Override
    protected void close() {
    }

    @Override
    public void setFrequency(double freq) {
        this.frequency = freq;
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            switch (hwChan) {
                case 0: {
                    value = this.frequency;
                    break;
                }
                case 1: {
                    value = 1.0;
                    break;
                }
                case 2: {
                    value = 380.0;
                }
            }
        }
        return value;
    }
}

