import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.refrig.HexMain
import org.lsst.ccs.subsystem.refrig.EnthalpyExchangeChannel
import org.lsst.ccs.subsystem.refrig.SubCoolingChannel
import org.lsst.ccs.subsystem.refrig.SuperHeatChannel
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.refrig.SimMaq20Device
import org.lsst.ccs.monitor.Channel

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    offsetLow = 0.0
    scaleLow = 1.0
    offsetHigh = 0.0
    scaleHigh = 1.0
}
else {
    maq20Device = Maq20Device
    offsetLow = -125.0;
    scaleLow = 31250.0
    offsetHigh = -187.5
    scaleHigh = 46875.0
} 

CCSBuilder builder = ["hex"]

builder.main (HexMain) {

    maq20 = "Maq20"
    maq20x = "Maq20x"

    "$maq20"  (maq20Device, modules: ["RTD", "RTD", "RTD", "RTD", "RTD", "RTD", "RTD", "IS", "IS"])

    "$maq20x" (maq20Device, modules: ["TTC"])

    "Cold1/SupplyTmp"   (Channel, description: "Supply Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20x, hwChan: 4, type: "0", subtype: "T220")

    "Cold1/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "6", subtype: "R200")

    "Cold1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "6", subtype: "R200")

    "Cold1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "6", subtype: "R200")

    "Cold1/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "8", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cold1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "8", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cold1/SuperHeat"   (SuperHeatChannel, description: "Cold1 SuperHeat", units: "\u00b0C", format: ".2f",
                        devcName: maq20, evapExitTempChannel: ref("Cold1/EvapExitTmp"), returnPressureChannel:ref("Cold1/ReturnPrs"))

    "Cold1/SupplySubCooling" (SubCoolingChannel, description: "Cold1 Supply SubCooling", units: "\u00b0C", format: ".2f",
                              dischargePressureChannel: ref("Cold1/SupplyPrs"), liquidTempChannel:ref("Cold1/SupplyTmp"))

    "Cold1/EnthalpyExch" (EnthalpyExchangeChannel, description: "Enthalpy Exchange", units: "kJ/kG", format: ".2f",
                          supplyTempChannel: ref("Cold1/SupplyTmp"), preExpnTempChannel: ref("Cold1/PreExpnTmp"),
                          r507aSpecHeat: 1.43)

    "Cold2/SupplyTmp"   (Channel, description: "Supply Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20x, hwChan: 5, type: "0", subtype: "T220")

    "Cold2/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "6", subtype: "R200")

    "Cold2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "6", subtype: "R200")

    "Cold2/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "6", subtype: "R200")

    "Cold2/SupplyPrs"   (Channel, description: "Supply Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "8", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cold2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "8", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cold2/SuperHeat"   (SuperHeatChannel, description: "Cold2 SuperHeat", units: "\u00b0C", format: ".2f",
                        devcName: maq20, evapExitTempChannel: ref("Cold2/EvapExitTmp"), returnPressureChannel:ref("Cold2/ReturnPrs"))

    "Cold2/SupplySubCooling"   (SubCoolingChannel, description: "Cold2 Supply SubCooling", units: "\u00b0C", format: ".2f",
                        dischargePressureChannel: ref("Cold2/SupplyPrs"), liquidTempChannel:ref("Cold2/SupplyTmp"))

    "Cold2/EnthalpyExch" (EnthalpyExchangeChannel, description: "Enthalpy Exchange", units: "kJ/kG", format: ".2f",
                          supplyTempChannel: ref("Cold2/SupplyTmp"), preExpnTempChannel: ref("Cold2/PreExpnTmp"),
                          r507aSpecHeat: 1.43)

    "Cryo5/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "4", subtype: "R200")

    "Cryo5/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "4", subtype: "R200")

    "Cryo5/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "4", subtype: "R200")

    "Cryo5/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "4", subtype: "R200")

    "Cryo5/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "4", subtype: "R200")

    "Cryo5/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "4", subtype: "R200")

    "Cryo5/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 12, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo5/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 13, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo5/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 14, type: "7", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cryo6/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "5", subtype: "R200")

    "Cryo6/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "5", subtype: "R200")

    "Cryo6/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "5", subtype: "R200")

    "Cryo6/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "5", subtype: "R200")

    "Cryo6/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "5", subtype: "R200")

    "Cryo6/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "5", subtype: "R200")

    "Cryo6/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 15, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo6/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "8", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo6/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "8", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cryo4/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "3", subtype: "R200")

    "Cryo4/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "3", subtype: "R200")

    "Cryo4/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "3", subtype: "R200")

    "Cryo4/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "3", subtype: "R200")

    "Cryo4/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "3", subtype: "R200")

    "Cryo4/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "3", subtype: "R200")

    "Cryo4/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 9, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo4/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 10, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo4/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 11, type: "7", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cryo3/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "2", subtype: "R200")

    "Cryo3/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "2", subtype: "R200")

    "Cryo3/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "2", subtype: "R200")

    "Cryo3/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "2", subtype: "R200")

    "Cryo3/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "2", subtype: "R200")

    "Cryo3/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "2", subtype: "R200")

    "Cryo3/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 6, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo3/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 7, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo3/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 8, type: "7", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cryo2/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "1", subtype: "R200")

    "Cryo2/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "1", subtype: "R200")

    "Cryo2/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "1", subtype: "R200")

    "Cryo2/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "1", subtype: "R200")

    "Cryo2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "1", subtype: "R200")

    "Cryo2/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "1", subtype: "R200")

    "Cryo2/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo2/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "7", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

    "Cryo1/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "0", subtype: "R200")

    "Cryo1/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "0", subtype: "R200")

    "Cryo1/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "0", subtype: "R200")

    "Cryo1/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "0", subtype: "R200")

    "Cryo1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "0", subtype: "R200")

    "Cryo1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "0", subtype: "R200")

    "Cryo1/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo1/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "7", subtype: "MA4_20", offset: offsetHigh, scale: scaleHigh)

    "Cryo1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "7", subtype: "MA4_20", offset: offsetLow, scale: scaleLow)

}
