/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.common.data.MonitorTask;
import org.lsst.ccs.subsystem.refrig.data.HexState;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;

public class HexMain
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @ConfigurationParameter(isFinal=true)
    private volatile double rtnToEvapOffset = 0.3;
    private static final Logger LOG = Logger.getLogger(HexMain.class.getName());
    private final HexState hexState = new HexState();
    private String refrigGroup;
    private MonitorTaskControl monitorControl;
    private Map<String, MonitorTask> monitorTaskMap;

    public HexMain() {
        super("hex", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        String useFull = this.propertiesService.getAgentProperty("org.lsst.ccs.use.full.paths");
        if (useFull == null || !useFull.equals("true")) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"org.lsst.ccs.use.full.paths", (String)"not defined as true");
        }
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("hex-state", () -> this.publishUpdatedHexState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("hexType", HexMain.class.getCanonicalName());
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.refrigGroup = RefrigUtils.getGroupName((AgentInfo)this.subsys.getAgentInfo());
        this.monitorTaskMap = this.monitorControl.getMonitorTaskMap();
    }

    public void postStart() {
        LOG.info("Heat exchanger subsystem started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            if (!RefrigUtils.getGroupName((AgentInfo)agent).equals(this.refrigGroup)) continue;
            this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType") || !RefrigUtils.getGroupName((AgentInfo)agent).equals(this.refrigGroup)) continue;
            this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        int tickMillis;
        StatusSubsystemData sd = (StatusSubsystemData)msg;
        if (sd.getDataKey().equals("UpdatePeriod") && (tickMillis = ((UpdatePeriod)sd.getSubsystemData().getValue()).getTickMillis()) != this.monitorControl.getPublishPeriod()) {
            this.monitorControl.setPublishPeriod(tickMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description="Get the heat exchanger state", level=0)
    public HexState getSystemState() {
        HexState hexState = this.hexState;
        synchronized (hexState) {
            this.hexState.setTickMillis(this.monitorControl.getPublishPeriod());
            this.hexState.clearMonitorTasks();
            for (MonitorTask task : this.monitorTaskMap.values()) {
                this.hexState.addMonitorTask(task);
            }
            return this.hexState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishUpdatedHexState() {
        HexState hexState = this.hexState;
        synchronized (hexState) {
            boolean changed = this.monitorControl.hasPeriodChanged();
            this.hexState.clearMonitorTasks();
            for (MonitorTask task : this.monitorTaskMap.values()) {
                if (!task.hasChanged()) continue;
                this.hexState.addMonitorTask(task);
                changed = true;
            }
            if (changed) {
                this.hexState.setTickMillis(this.monitorControl.getPublishPeriod());
                this.publishSubsystemDataOnStatusBus(new KeyValueData("HexState", (Serializable)this.hexState));
            }
        }
    }

    double getRtnToEvapOffset() {
        return this.rtnToEvapOffset;
    }
}

