/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.annotations.Command;

class PressureTemperatureUtils {
    private static final double STANDARD_PRESSURE = 14.7;
    private static final Logger LOG = Logger.getLogger(PressureTemperatureUtils.class.getName());
    private static final TreeMap<Double, Double> pressSatTempMap = new TreeMap();
    private static boolean failedToLoadMap = false;

    PressureTemperatureUtils() {
    }

    public static double getStandardPressure() {
        return 14.7;
    }

    @Command(type=Command.CommandType.QUERY, description="Show the content of the pressure/temperature table")
    public static String printPressureTemperatureMap() {
        StringBuffer sb = new StringBuffer();
        sb.append("Pressure").append("\t").append("Temperature").append("\n");
        for (Map.Entry<Double, Double> e : pressSatTempMap.entrySet()) {
            sb.append(e.getKey()).append("\t").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, description="Evaluate superHeat give pressure and temperature")
    static double evaluateSaturationTemperature(double pRead) {
        if (failedToLoadMap) {
            throw new RuntimeException("Failed to lad pressure/temperature map");
        }
        Map.Entry<Double, Double> floorEntry = pressSatTempMap.floorEntry(pRead -= PressureTemperatureUtils.getStandardPressure());
        Map.Entry<Double, Double> ceilingEntry = pressSatTempMap.ceilingEntry(pRead);
        if (floorEntry == null || ceilingEntry == null) {
            return Double.NaN;
        }
        double pLow = floorEntry.getKey();
        double tLow = floorEntry.getValue();
        double pHigh = ceilingEntry.getKey();
        double tHigh = ceilingEntry.getValue();
        double tSat = Math.abs((pRead - pLow) / (pHigh - pLow)) * tHigh + Math.abs((pRead - pHigh) / (pHigh - pLow)) * tLow;
        return tSat;
    }

    static {
        try (InputStream is = BootstrapResourceUtils.getBootstrapResource((String)"r507-rtnPrs-satTmp.txt");){
            if (is == null) {
                throw new RuntimeException("Could not open file r507-rtnPrs-satTmp.txt");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = reader.readLine().trim();
                while (line != null) {
                    line = reader.readLine();
                    if (line == null || line.startsWith("#") || line.isEmpty()) continue;
                    String[] split = line.trim().split("\\s+");
                    if (split.length != 2) {
                        throw new IllegalArgumentException("Cannot split line " + line);
                    }
                    Double pressure = Double.parseDouble(split[0]);
                    Double temp = Double.parseDouble(split[1]);
                    pressSatTempMap.put(pressure, temp);
                }
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            failedToLoadMap = true;
        }
    }
}

