package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

/**
 * A Derived channel to calculate sub cooling
 * 
 * @author The LSST CCS Team
 */
public class SubCoolingChannel extends DerivedChannel {
    
    private Channel dischargePressureChannel;
    private Channel liquidTempChannel;
    
    @Override
    public void build() {
        
        if ( dischargePressureChannel == null || liquidTempChannel == null ) {
            throw new RuntimeException("Both evapExitTemp and returnPressure channels must be defined and not null. "+dischargePressureChannel+" "+liquidTempChannel);
        }
        super.build(); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public double evaluateDerivedValue() {
        double tRead = liquidTempChannel.getValue();
        double pRead = dischargePressureChannel.getValue();
        if ( Double.isNaN(pRead) || Double.isNaN(tRead) ) {
            return Double.NaN;
        }
        
        double result = PressureTemperatureUtils.evaluateSaturationTemperature(pRead) - tRead;
        return result;
    }

    
}
