/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.HeaterPIControl;
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalAlert;
import org.lsst.ccs.subsystem.refrig.constants.ThermalConstants;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class ThermalMain
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener,
ClearAlertHandler {
    private static final String THERMAL_LIMITS = "ThermalLimits";
    private static final int POWER_SET_INTVL = 5000;
    private static final int UPDATE_STATE_INTVL = 1000;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, HeaterPIControl> tempControlMap = new HashMap<String, HeaterPIControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, PowerDevice> powerDeviceMap = new HashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @ConfigurationParameter(category="ThermalLimits", isFinal=true)
    private double coldTempLimit = 40.0;
    private String coldTempCtrl;
    private String cryoTempCtrl;
    private String[] auxPowerNames;
    private String[] coldTempNames;
    private static final Logger LOG = Logger.getLogger(ThermalMain.class.getName());
    private final TrimHeater[] trimHeaters = new TrimHeater[2];
    private final AuxHeater[] auxHeaters = new AuxHeater[3];
    private final List<Channel> coldTemps = new ArrayList<Channel>();
    private final ThermalState thermalState = new ThermalState();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private int highTempCount = 0;
    private ColdState refrigColdState = ColdState.UNKNOWN;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("heater-power", () -> this.maintainHeaterPower()).withPeriod(Duration.ofMillis(5000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("thermal-state", () -> this.updateThermalState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        int htr;
        this.propertiesService.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.thermalState.setTickMillis(this.getTickPeriod());
        for (htr = 0; htr < 2; ++htr) {
            HeaterPIControl ctrl = this.tempControlMap.get(htr == 0 ? this.coldTempCtrl : this.cryoTempCtrl);
            if (ctrl == null) {
                String type = htr == 0 ? "cold" : "cryo";
                LOG.log(Level.SEVERE, "No {0}-plate temperature controller (or heater control) specified", type);
                continue;
            }
            this.trimHeaters[htr] = new TrimHeater(ctrl, ctrl.getPowerDevice(), ctrl.getPowerChannel());
        }
        if (this.auxPowerNames == null) {
            LOG.info("No auxiliary heater devices specified");
        } else if (this.auxPowerNames.length > 3) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)"contains more than 3 items");
        } else {
            for (htr = 0; htr < 3; ++htr) {
                PowerDevice power;
                String desc;
                String string = desc = htr < this.auxPowerNames.length ? this.auxPowerNames[htr] : null;
                if (desc == null) {
                    LOG.log(Level.INFO, "Auxiliary heater {0} has not been specified", htr);
                    continue;
                }
                String[] words = desc.split(":");
                if (words.length > 2) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains invalid item: " + desc));
                }
                if ((power = this.powerDeviceMap.get(words[0])) == null) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains non-power item: " + words[0]));
                }
                int channel = 0;
                if (words.length == 2) {
                    try {
                        channel = Integer.decode(words[1]);
                    }
                    catch (NumberFormatException e) {
                        ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"auxPowerNames", (String)("contains invalid channel: " + words[1]));
                    }
                }
                this.auxHeaters[htr] = new AuxHeater(power, channel);
            }
        }
        if (this.coldTempNames == null) {
            LOG.severe("No cold-plate temperature monitoring channels specified");
        } else {
            for (String coldName : this.coldTempNames) {
                Channel chan = this.allChannels.get(coldName);
                if (chan == null) {
                    ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"coldTempNames", (String)"contains non-channel item");
                }
                this.coldTemps.add(chan);
            }
        }
    }

    public void postStart() {
        Object heater;
        int htr;
        for (htr = 0; htr < 2; ++htr) {
            heater = this.trimHeaters[htr];
            if (heater == null) continue;
            this.thermalState.setTrimHeaterState(htr, !((TrimHeater)heater).powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (((TrimHeater)heater).powerDevc.isEnabled(((TrimHeater)heater).powerChan) ? TrimHeaterState.POWER : TrimHeaterState.OFF));
        }
        for (htr = 0; htr < 3; ++htr) {
            heater = this.auxHeaters[htr];
            if (heater == null) continue;
            this.thermalState.setAuxHeaterState(htr, !((AuxHeater)heater).powerDevc.isOnline() ? AuxHeaterState.OFFLINE : (((AuxHeater)heater).powerDevc.isEnabled(((AuxHeater)heater).powerChan) ? AuxHeaterState.ON : AuxHeaterState.OFF));
        }
        LOG.info("Thermal control system started");
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            String agentName = agent.getName();
            this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
            break;
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("compressorType")) continue;
            this.subsys.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        this.refrigColdState = (ColdState)msg.getState().getState(ColdState.class);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state")
    public ThermalState getSystemState() {
        return this.thermalState;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.thermalState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Enables/disables a cold trim heater section")
    public void enableColdSection(int section, boolean enable) throws DriverException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.trimHeaters[0];
                if (heater != null) {
                    this.thermalState.enableColdSection(section, enable);
                    ((HeaterPsDevice)heater.powerDevc).enableColdSection(section, enable);
                    this.setTrimHeaterPower(0);
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater state")
    public void setTrimHeaterState(int htr, int value) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                TrimHeaterState oldState = this.thermalState.getTrimHeaterState(htr);
                if (oldState != TrimHeaterState.OFFLINE && oldState != TrimHeaterState.DISABLD) {
                    TrimHeaterState newState;
                    TrimHeaterState trimHeaterState = value == 0 ? TrimHeaterState.OFF : (newState = value > 0 ? TrimHeaterState.POWER : TrimHeaterState.TEMP);
                    if (newState != oldState) {
                        this.thermalState.setTrimHeaterState(htr, newState);
                        this.setTrimHeaterPower(htr);
                    }
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a trim heater power set point")
    public void setTrimHeaterPower(int htr, double power) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setTrimHeaterPower(htr, power);
                if (ThermalConstants.trimPowerStates.contains(this.thermalState.getTrimHeaterState(htr))) {
                    heater.powerDevc.setPower(heater.powerChan, power);
                    heater.startPower = power;
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a plate temperature set point")
    public void setPlateTemperature(int htr, double temp) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                TrimHeater heater = this.getTrimHeater(htr);
                this.thermalState.setPlateTemperature(htr, temp);
                heater.tempCtrl.setTemp(temp);
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power enabled state")
    public void setAuxHeaterState(int htr, int value) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                AuxHeaterState oldState = this.thermalState.getAuxHeaterState(htr);
                if (oldState != AuxHeaterState.OFFLINE && oldState != AuxHeaterState.DISABLD) {
                    AuxHeaterState newState;
                    AuxHeaterState auxHeaterState = newState = value != 0 ? AuxHeaterState.ON : AuxHeaterState.OFF;
                    if (newState != oldState) {
                        this.thermalState.setAuxHeaterState(htr, newState);
                        this.setAuxHeaterPower(htr);
                    }
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set an aux heater power set point")
    public void setAuxHeaterPower(int htr, double value) throws RefrigException {
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            try {
                this.thermalState.setAuxHeaterPower(htr, value);
                this.setAuxHeaterPower(htr);
            }
            finally {
                this.publishState();
            }
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.thermalState));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThermalState() {
        boolean coldHigh = false;
        for (Channel chan : this.coldTemps) {
            coldHigh |= chan.getValue() > this.coldTempLimit;
        }
        if (coldHigh) {
            coldHigh &= ++this.highTempCount >= 3;
        } else {
            this.highTempCount = 0;
        }
        ThermalState thermalState = this.thermalState;
        synchronized (thermalState) {
            boolean changed = false;
            for (int htr = 0; htr < 2; ++htr) {
                TrimHeaterState state;
                TrimHeater heater = this.trimHeaters[htr];
                if (heater == null) continue;
                TrimHeaterState oldState = this.thermalState.getTrimHeaterState(htr);
                boolean isTemp = ThermalConstants.trimTempStates.contains(oldState);
                TrimHeaterState trimHeaterState = coldHigh && htr == 0 ? TrimHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? TrimHeaterState.OFFLINE : (!heater.powerDevc.isEnabled(heater.powerChan) ? TrimHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? (isTemp ? TrimHeaterState.VOLTERR_ : TrimHeaterState.VOLTERR) : (heater.powerDevc.hasNoLoad(heater.powerChan) ? (isTemp ? TrimHeaterState.NOLOAD_ : TrimHeaterState.NOLOAD) : (state = isTemp ? TrimHeaterState.TEMP : TrimHeaterState.POWER)))));
                if (state == oldState) continue;
                this.thermalState.setTrimHeaterState(htr, state);
                this.setTrimHeaterPower(htr);
                changed = true;
            }
            boolean coldCompsOff = this.refrigColdState == ColdState.BOTH_OFF || this.refrigColdState == ColdState.UNKNOWN;
            for (int htr = 0; htr < 3; ++htr) {
                AuxHeaterState state;
                AuxHeater heater = this.auxHeaters[htr];
                if (heater == null) continue;
                AuxHeaterState auxHeaterState = coldHigh || coldCompsOff ? AuxHeaterState.DISABLD : (!heater.powerDevc.isOnline() ? AuxHeaterState.OFFLINE : (!heater.powerDevc.isEnabled(heater.powerChan) ? AuxHeaterState.OFF : (heater.powerDevc.hasVoltError(heater.powerChan) ? AuxHeaterState.VOLTERR : (state = heater.powerDevc.hasNoLoad(heater.powerChan) ? AuxHeaterState.NOLOAD : AuxHeaterState.ON))));
                if (state == this.thermalState.getAuxHeaterState(htr)) continue;
                this.thermalState.setAuxHeaterState(htr, state);
                this.setAuxHeaterPower(htr);
                changed = true;
            }
            if (changed) {
                this.publishState();
                if (coldHigh) {
                    this.raiseAlert(ThermalAlert.COLD_TEMP_HIGH, AlertState.ALARM, "At least one cold-plate RTD is above " + this.coldTempLimit + " C");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_TEMP_HIGH, "No cold-plate RTD is above " + this.coldTempLimit + " C");
                }
                if (coldCompsOff) {
                    this.raiseAlert(ThermalAlert.COLD_COMP_OFF, AlertState.ALARM, "Both cold compressors are turned off");
                } else {
                    this.lowerAlert(ThermalAlert.COLD_COMP_OFF, "At least one cold compressor is back on");
                }
            }
        }
    }

    private void maintainHeaterPower() {
        Object heater;
        int htr;
        for (htr = 0; htr < 2; ++htr) {
            if (!ThermalConstants.trimPowerStates.contains(this.thermalState.getTrimHeaterState(htr))) continue;
            heater = this.trimHeaters[htr];
            ((TrimHeater)heater).powerDevc.maintainPower(((TrimHeater)heater).powerChan);
        }
        for (htr = 0; htr < 3; ++htr) {
            if (!ThermalConstants.auxOnStates.contains(this.thermalState.getAuxHeaterState(htr))) continue;
            heater = this.auxHeaters[htr];
            ((AuxHeater)heater).powerDevc.maintainPower(((AuxHeater)heater).powerChan);
        }
    }

    private void setTrimHeaterPower(int htr) {
        TrimHeaterState state = this.thermalState.getTrimHeaterState(htr);
        TrimHeater heater = this.trimHeaters[htr];
        if (ThermalConstants.trimPowerStates.contains(state)) {
            heater.tempCtrl.stop();
            heater.powerDevc.enableOutput(heater.powerChan, true);
            double loadPower = this.thermalState.getTrimHeaterPower(htr);
            heater.powerDevc.setPower(heater.powerChan, loadPower);
            heater.startPower = loadPower;
        } else if (ThermalConstants.trimTempStates.contains(state)) {
            heater.powerDevc.enableOutput(heater.powerChan, true);
            if (heater.startPower == null) {
                heater.tempCtrl.restart();
            } else {
                heater.tempCtrl.start(heater.startPower);
                heater.startPower = null;
            }
        } else {
            heater.tempCtrl.stop();
            heater.powerDevc.enableOutput(heater.powerChan, false);
        }
    }

    private void setAuxHeaterPower(int htr) {
        AuxHeater heater = this.auxHeaters[htr];
        if (ThermalConstants.auxOnStates.contains(this.thermalState.getAuxHeaterState(htr))) {
            heater.powerDevc.enableOutput(heater.powerChan, true);
            heater.powerDevc.setPower(heater.powerChan, this.thermalState.getAuxHeaterPower(htr));
        } else {
            heater.powerDevc.enableOutput(heater.powerChan, false);
        }
    }

    private void raiseAlert(ThermalAlert alert, AlertState state, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(), true);
        if (active == null || !active.booleanValue()) {
            this.alertService.raiseAlert(alert.newAlert(), state, cond);
        }
    }

    private void lowerAlert(ThermalAlert alert, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(), false);
        if (active != null && active.booleanValue()) {
            this.alertService.raiseAlert(alert.newAlert(), AlertState.NOMINAL, cond);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    private TrimHeater getTrimHeater(int htr) throws RefrigException {
        if (htr < 0 || htr >= 2) {
            throw new RefrigException("Invalid trim heater number: " + htr);
        }
        TrimHeater heater = this.trimHeaters[htr];
        if (heater == null) {
            throw new RefrigException("Trim heater " + htr + " not defined");
        }
        return heater;
    }

    private AuxHeater getAuxHeater(int htr) throws RefrigException {
        if (htr < 0 || htr >= 3) {
            throw new RefrigException("Invalid auxiliary heater number: " + htr);
        }
        AuxHeater heater = this.auxHeaters[htr];
        if (heater == null) {
            throw new RefrigException("Auxiliary heater " + htr + " not defined");
        }
        return heater;
    }

    static class AuxHeater {
        PowerDevice powerDevc;
        int powerChan;

        AuxHeater(PowerDevice powerDevc, int powerChan) {
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }

    static class TrimHeater {
        HeaterPIControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;
        Double startPower = 0.0;

        TrimHeater(HeaterPIControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

