/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.FanControl;
import org.lsst.ccs.subsystem.refrig.constants.CompAlert;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwCondState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class Compressor
implements HasLifecycle {
    private static final String COMP_LIMITS = "CompLimits";
    private static final int MIN_SW_STATE_SITS = 3;
    private static final Map<Integer, CompAlert> ccsAlertMap = new HashMap<Integer, CompAlert>();
    private static final Map<Integer, CompAlert> plcAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompMaq20Device maq20Devc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private FanControl fanControl;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discPressImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discPressDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int discPressDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double discTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int discTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double suctTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double cmprPowerImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double cmprPowerDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int cmprPowerDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double phaseSepTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int phaseSepTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double liquidTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double liquidTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    int liquidTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double coldTempImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double orificeOffPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    double orificeOnPress;
    protected String discPressChan;
    protected String discTempChan;
    protected String suctTempChan;
    protected String cmprPowerChan;
    protected String phaseSepTempChan;
    protected String liquidTempChan;
    private static final Logger LOG;
    private final CompState state;
    private final SwitchDevice[] switchDevices;
    private final int[] switchChannels;
    private final int type;
    private Channel discPress;
    private Channel discTemp;
    private Channel suctTemp;
    private Channel cmprPower;
    private Channel phaseSepTemp;
    private Channel liquidTemp;
    private int activeConds = 0;
    private final LimitData[] limitData = new LimitData[8];
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();

    public Compressor(CompState state) {
        this.state = state;
        this.type = state.getType();
        this.switchDevices = new SwitchDevice[7];
        this.switchChannels = new int[7];
        for (int j = 0; j < 8; ++j) {
            this.limitData[j] = new LimitData();
        }
    }

    public void postInit() {
        if (this.plutoDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"plutoDevc", (String)"not specified");
        }
        if (this.maq20Devc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maq20Devc", (String)"not specified");
        }
        if (this.discTempChan != null) {
            this.discTemp = this.channelMap.get(this.discTempChan);
        }
        if (this.discTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discTempChan", (String)"not specified or not defined");
        }
        if (this.suctTempChan != null) {
            this.suctTemp = this.channelMap.get(this.suctTempChan);
        }
        if (this.suctTemp == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"suctTempChan", (String)"not specified or not defined");
        }
        if (this.discPressChan != null) {
            this.discPress = this.channelMap.get(this.discPressChan);
        }
        if (this.discPress == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"discPressChan", (String)"not specified or not defined");
        }
        if (this.cmprPowerChan != null) {
            this.cmprPower = this.channelMap.get(this.cmprPowerChan);
        }
        if (this.cmprPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"cmprPowerChan", (String)"not specified or not defined");
        }
        this.limitData[0].channel = this.discPress;
        this.limitData[1].channel = this.discTemp;
        this.limitData[2].channel = this.suctTemp;
        this.limitData[2].isLower = true;
        this.limitData[2].delayLimit = Double.NaN;
        this.limitData[3].channel = this.cmprPower;
        if (this.type == 0) {
            this.limitData[0].channel = this.discPress;
            if (this.liquidTempChan != null) {
                this.liquidTemp = this.channelMap.get(this.liquidTempChan);
            }
            if (this.liquidTemp == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"liquidTempChan", (String)"not specified or not defined");
            }
            this.limitData[7].channel = this.liquidTemp;
            this.switchDevices[0] = this.plutoDevc;
            this.switchChannels[0] = 0;
            this.switchDevices[2] = this.plutoDevc;
            this.switchChannels[2] = 1;
        } else {
            this.limitData[0].delayTime = -1;
            if (this.phaseSepTempChan != null) {
                this.phaseSepTemp = this.channelMap.get(this.phaseSepTempChan);
            }
            if (this.phaseSepTemp == null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"phaseSepTempChan", (String)"not specified or not defined");
            }
            this.limitData[4].channel = this.phaseSepTemp;
            this.limitData[4].immedLimit = Double.NaN;
            this.switchDevices[0] = this.plutoDevc;
            this.switchChannels[0] = 0;
            this.switchDevices[2] = this.plutoDevc;
            this.switchChannels[2] = 1;
            this.switchDevices[1] = this.plutoDevc;
            this.switchChannels[1] = 2;
            this.switchDevices[3] = this.maq20Devc;
            this.switchChannels[3] = 2;
            this.switchDevices[4] = this.maq20Devc;
            this.switchChannels[4] = 1;
            this.switchDevices[5] = this.maq20Devc;
            this.switchChannels[5] = 3;
            this.switchDevices[6] = this.maq20Devc;
            this.switchChannels[6] = 4;
        }
        this.state.setName(this.name);
        this.plutoDevc.setType(this.type);
        this.maq20Devc.setType(this.type);
        if (this.fanControl != null) {
            LOG.log(Level.INFO, "Compressor {0} has an associated fan speed controller", this.name);
        }
    }

    public void postStart() {
        if (this.fanControl != null) {
            this.fanControl.startLoop(0.0);
        }
    }

    @ConfigurationParameterChanger
    public void setDiscPressImmedLimit(double value) {
        this.discPressImmedLimit = value;
        this.limitData[0].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayLimit(double value) {
        this.discPressDelayLimit = value;
        this.limitData[0].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscPressDelayTime(int value) {
        this.discPressDelayTime = value;
        if (this.type == 0) {
            this.limitData[0].delayTime = 1000 * value;
        }
    }

    @ConfigurationParameterChanger
    public void setDiscTempImmedLimit(double value) {
        this.discTempImmedLimit = value;
        this.limitData[1].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayLimit(double value) {
        this.discTempDelayLimit = value;
        this.limitData[1].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempDelayTime(int value) {
        this.discTempDelayTime = value;
        this.limitData[1].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setSuctTempImmedLimit(double value) {
        this.suctTempImmedLimit = value;
        this.limitData[1].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerImmedLimit(double value) {
        this.cmprPowerImmedLimit = value;
        this.limitData[3].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayLimit(double value) {
        this.cmprPowerDelayLimit = value;
        this.limitData[3].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setCmprPowerDelayTime(int value) {
        this.cmprPowerDelayTime = value;
        this.limitData[3].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setLiquidTempImmedLimit(double value) {
        this.liquidTempImmedLimit = value;
        if (this.type == 0) {
            this.limitData[7].immedLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayLimit(double value) {
        this.liquidTempDelayLimit = value;
        if (this.type == 0) {
            this.limitData[7].delayLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setLiquidTempDelayTime(int value) {
        this.liquidTempDelayTime = value;
        if (this.type == 0) {
            this.limitData[7].delayTime = 1000 * value;
        }
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayLimit(double value) {
        this.phaseSepTempDelayLimit = value;
        if (this.type == 1) {
            this.limitData[4].delayLimit = value;
        }
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayTime(int value) {
        this.phaseSepTempDelayTime = value;
        if (this.type == 1) {
            this.limitData[4].delayTime = 1000 * value;
        }
    }

    public void setIndex(int index) {
        this.state.setIndex(index);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    @Command(type=Command.CommandType.ACTION, description="Set a compressor's switch state")
    public synchronized void setSwitchOn(@Argument(description="Switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        if (!this.state.getValidSwitches().contains(sw)) {
            throw new RefrigException("Invalid switch number: " + sw);
        }
        if (sw == 0 && on && this.activeConds != 0) {
            return;
        }
        this.setSwitch(sw, on);
        if (sw == 0) {
            this.setValves(on);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a compressor's latches")
    public void resetLatches() {
        this.plutoDevc.resetLatches();
    }

    public synchronized boolean updateState() {
        boolean changed = false;
        CompressorState compState = null;
        Iterator iterator = this.state.getValidSwitches().iterator();
        while (iterator.hasNext()) {
            int sw = (Integer)iterator.next();
            Boolean on = this.switchDevices[sw].isSwitchOn(this.switchChannels[sw]);
            SwitchState swState = on == null ? SwitchState.OFFLINE : (on != false ? SwitchState.ON : SwitchState.OFF);
            if (swState == this.state.getSwitchState(sw)) continue;
            this.state.setSwitchState(sw, swState);
            changed = true;
        }
        iterator = this.state.getValidLatches().iterator();
        while (iterator.hasNext()) {
            int cond = (Integer)iterator.next();
            LatchState latchState = this.plutoDevc.getLatchState(cond);
            if (latchState == this.state.getLatchState(cond)) continue;
            this.state.setLatchState(cond, latchState);
            CompAlert alert = plcAlertMap.get(cond);
            if (latchState == LatchState.ACTIVE) {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " PLC error condition set");
            } else if (latchState == LatchState.WARNING) {
                this.raiseAlert(alert, AlertState.WARNING, this.name + " PLC warning condition set");
            } else {
                this.lowerAlert(alert, this.name + " PLC error condition cleared");
            }
            changed = true;
        }
        boolean poweredOff = false;
        Iterator iterator2 = this.state.getValidConditions().iterator();
        while (iterator2.hasNext()) {
            int cond = (Integer)iterator2.next();
            ConditionState condState = this.plutoDevc.getConditionState(cond);
            if (condState == ConditionState.OFF) {
                compState = CompressorState.OFFLINE;
            }
            if (condState == this.state.getConditionState(cond)) continue;
            if (cond == 3 && condState != ConditionState.YES) {
                poweredOff = true;
            }
            this.state.setConditionState(cond, condState);
            changed = true;
        }
        if (poweredOff && this.state.getConditionState(1) == ConditionState.YES) {
            this.setValves(false);
        }
        iterator2 = this.state.getValidSwConditions().iterator();
        while (iterator2.hasNext()) {
            int cond = (Integer)iterator2.next();
            LimitData ld = this.limitData[cond];
            if (ld.swState == this.state.getSwConditionState(cond)) continue;
            this.state.setSwConditionState(cond, ld.swState);
            CompAlert alert = ccsAlertMap.get(cond);
            String value = String.format("%.1f", ld.value);
            if (ld.swState == SwCondState.ACTIVE) {
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS immediate error condition set: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.immedLimit);
            } else if (ld.swState == SwCondState.DLYACTV) {
                String timeText = ld.delayTime >= 0 ? " for " + ld.delayTime / 1000 + " sec" : " and compressor on for 6 hours";
                this.raiseAlert(alert, AlertState.ALARM, this.name + " CCS delayed error condition set: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.delayLimit + timeText);
            } else if (ld.swState == SwCondState.DLYPEND) {
                this.raiseAlert(alert, AlertState.WARNING, this.name + " CCS delayed error condition pending: value (" + value + (ld.isLower ? ") < " : ") > ") + ld.delayLimit);
            } else {
                this.lowerAlert(alert, this.name + " CCS error condition cleared: value = " + value);
            }
            changed = true;
        }
        if (compState == null && this.activeConds != 0) {
            compState = CompressorState.SW_DSAB;
        }
        if (compState == null) {
            CompressorState compressorState = this.state.getConditionState(2) == ConditionState.YES ? CompressorState.WAITING : (this.state.getConditionState(3) == ConditionState.YES ? CompressorState.RUNNING : (compState = this.state.getConditionState(11) == ConditionState.NO ? CompressorState.HW_DSAB : CompressorState.STOPPED));
        }
        if (compState != this.state.getCompressorState()) {
            this.state.setCompressorState(compState);
            changed = true;
        }
        return changed;
    }

    public CompState getState() {
        return this.state;
    }

    public synchronized void checkLimits() {
        for (int cond = 0; cond < 8; ++cond) {
            LimitData ld = this.limitData[cond];
            if (ld.channel == null) continue;
            ld.value = ld.channel.getValue();
            long endTime = ld.endTime;
            SwCondState swState = ld.provSwState;
            if (!ld.isLower && ld.value > ld.immedLimit || ld.isLower && ld.value < ld.immedLimit) {
                endTime = -1L;
                swState = SwCondState.ACTIVE;
            } else if (!ld.isLower && ld.value > ld.delayLimit || ld.isLower && ld.value < ld.delayLimit) {
                if (endTime == 0L) {
                    endTime = System.currentTimeMillis() + (long)ld.delayTime;
                    swState = SwCondState.DLYPEND;
                }
                if (endTime >= 0L && (ld.delayTime < 0 && this.state.getConditionState(14) == ConditionState.YES || ld.delayTime >= 0 && System.currentTimeMillis() > endTime)) {
                    endTime = -1L;
                    swState = SwCondState.DLYACTV;
                }
            } else {
                endTime = 0L;
                swState = SwCondState.CLEAR;
            }
            if (swState != ld.provSwState) {
                ld.provCount = 1;
                ld.provSwState = swState;
                continue;
            }
            if (++ld.provCount < 3 || ld.provSwState == ld.swState) continue;
            ld.swState = ld.provSwState;
            ld.endTime = endTime;
            if (endTime < 0L) {
                this.setCondition(cond);
                continue;
            }
            this.clearCondition(cond);
        }
    }

    public synchronized void controlValves() {
        if (this.type != 1) {
            return;
        }
        if (this.plutoDevc.getConditionState(3) != ConditionState.YES) {
            return;
        }
        double press = this.limitData[0].channel.getValue();
        try {
            if (press > this.orificeOffPress) {
                this.setSwitch(3, false);
            } else if (press < this.orificeOnPress) {
                this.setSwitch(3, true);
            }
        }
        catch (RefrigException e) {
            LOG.log(Level.SEVERE, "Error operating {0} orifice valve: {1}", new Object[]{this.name, e});
        }
    }

    private void setSwitch(int sw, boolean on) throws RefrigException {
        this.switchDevices[sw].setSwitchOn(this.switchChannels[sw], on);
    }

    private void setCondition(int cond) {
        if (this.activeConds == 0) {
            try {
                this.setSwitch(0, false);
                this.setValves(false);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error shutting off {0} compressor: {1}", new Object[]{this.name, e});
            }
        }
        this.activeConds |= 1 << cond;
    }

    private void clearCondition(int cond) {
        this.activeConds &= ~(1 << cond);
    }

    private void setValves(boolean on) {
        if (this.type == 1) {
            try {
                this.setSwitch(5, false);
                this.setSwitch(3, on);
            }
            catch (RefrigException e) {
                LOG.log(Level.SEVERE, "Error operating {0} compressor valves: {1}", new Object[]{this.name, e});
            }
        }
    }

    private void raiseAlert(CompAlert alert, AlertState state, String cond) {
        this.activeAlertMap.put(alert.getId(this.name), true);
        this.alertService.raiseAlert(alert.newAlert(this.name), state, cond);
    }

    private void lowerAlert(CompAlert alert, String cond) {
        Boolean active = this.activeAlertMap.put(alert.getId(this.name), false);
        if (active != null && active.booleanValue()) {
            this.alertService.raiseAlert(alert.newAlert(this.name), AlertState.NOMINAL, cond);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    static {
        ccsAlertMap.put(0, CompAlert.DISC_PRESS_HIGH);
        ccsAlertMap.put(1, CompAlert.DISC_TEMP_HIGH);
        ccsAlertMap.put(3, CompAlert.COMP_POWER_HIGH);
        ccsAlertMap.put(7, CompAlert.LIQD_TEMP_HIGH);
        ccsAlertMap.put(6, CompAlert.OIL_LEVEL_LOW);
        ccsAlertMap.put(2, CompAlert.SUCT_TEMP_LOW);
        ccsAlertMap.put(4, CompAlert.PHASE_TEMP_HIGH);
        ccsAlertMap.put(5, CompAlert.CRYO_TEMP_LOW);
        plcAlertMap = new HashMap<Integer, CompAlert>();
        plcAlertMap.put(3, CompAlert.DISC_PRESS_HIGH_PLC);
        plcAlertMap.put(0, CompAlert.DISC_TEMP_HIGH_PLC);
        plcAlertMap.put(4, CompAlert.COMP_POWER_HIGH_PLC);
        plcAlertMap.put(2, CompAlert.LIQD_TEMP_HIGH_PLC);
        plcAlertMap.put(9, CompAlert.OIL_LEVEL_LOW_PLC);
        plcAlertMap.put(1, CompAlert.SUCT_TEMP_LOW_PLC);
        plcAlertMap.put(8, CompAlert.AFTER_TEMP_HIGH_PLC);
        plcAlertMap.put(7, CompAlert.SENS_READ_BAD_PLC);
        plcAlertMap.put(6, CompAlert.SMOKE_DETC_PLC);
        plcAlertMap.put(5, CompAlert.EXT_PERMIT_PLC);
        LOG = Logger.getLogger(Compressor.class.getName());
    }

    public static class LimitData {
        private Channel channel = null;
        private boolean isLower = false;
        private double immedLimit = 0.0;
        private double delayLimit = 0.0;
        private int delayTime = 0;
        private double value = 0.0;
        private long endTime = 0L;
        private SwCondState swState = SwCondState.CLEAR;
        private SwCondState provSwState = SwCondState.CLEAR;
        private int provCount = 0;
    }

    public static interface SwitchDevice {
        public void setSwitchOn(int var1, boolean var2) throws RefrigException;

        public Boolean isSwitchOn(int var1);
    }
}

