/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class CompSimPlutoDevice
extends CompPlutoDevice {
    private static final Map<String, Integer> latchMap = new LinkedHashMap<String, Integer>();
    private static final Map<String, Integer> conditionMap;
    private final boolean[] coldSwitches = new boolean[2];
    private final boolean[] cryoSwitches = new boolean[3];
    private final LatchState[] latches = new LatchState[10];
    private final ConditionState[] conditions = new ConditionState[16];
    private boolean[] switches;
    private long powerTime = 0L;
    private final Map<String, Integer> channelMap = new LinkedHashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();

    public CompSimPlutoDevice() {
        Arrays.fill(this.latches, LatchState.CLEAR);
        Arrays.fill(this.conditions, ConditionState.YES);
        this.conditions[1] = ConditionState.NO;
        this.conditions[2] = ConditionState.NO;
        this.conditions[3] = ConditionState.NO;
    }

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        return new int[]{index, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return this.channelValues.get(type);
    }

    @Override
    public void setType(int type) {
        this.switches = type == 0 ? this.coldSwitches : this.cryoSwitches;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
        if (sw == 0) {
            if (on) {
                this.powerTime = System.currentTimeMillis() + 30000L;
                this.conditions[1] = ConditionState.YES;
                if (this.areLatchesClear()) {
                    this.conditions[2] = ConditionState.YES;
                    this.conditions[3] = ConditionState.YES;
                }
            } else {
                this.powerTime = 0L;
                this.conditions[1] = ConditionState.NO;
                this.conditions[2] = ConditionState.NO;
                this.conditions[3] = ConditionState.NO;
            }
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (this.powerTime != 0L && System.currentTimeMillis() >= this.powerTime) {
            this.conditions[2] = ConditionState.NO;
            this.powerTime = 0L;
        }
        return this.switches[sw];
    }

    @Override
    public LatchState getLatchState(int cond) {
        return this.latches[cond];
    }

    @Override
    public ConditionState getConditionState(int cond) {
        return this.conditions[cond];
    }

    @Override
    public void resetLatches() {
        for (int cond = 0; cond < this.latches.length; ++cond) {
            LatchState state = this.latches[cond];
            this.latches[cond] = state == LatchState.LATCHED ? LatchState.CLEAR : state;
        }
        if (this.switches[0] && this.areLatchesClear()) {
            this.conditions[3] = ConditionState.YES;
        }
    }

    private boolean areLatchesClear() {
        boolean clear = true;
        for (LatchState state : this.latches) {
            if (state == LatchState.CLEAR) continue;
            clear = false;
            break;
        }
        return clear;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of latched condition names")
    public String getLatchNames() {
        return latchMap.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition active")
    public void setLatchActive(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.ACTIVE;
        this.conditions[3] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition latched")
    public void setLatchLatched(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.LATCHED;
        this.conditions[3] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION, description="Put a latched condition into warning state")
    public void setLatchWarning(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[this.getLatch((String)cond)] = LatchState.WARNING;
    }

    private int getLatch(String name) throws RefrigException {
        Integer cond = latchMap.get(name);
        if (cond == null) {
            throw new RefrigException("Unknown latched condition name: " + name);
        }
        return cond;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of condition names")
    public String getConditionNames() {
        return conditionMap.keySet().toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the state of a condition")
    public void setCondition(@Argument(description="Running condition name") String cond, @Argument(description="Condition on state") boolean set) throws RefrigException {
        Integer condNum = conditionMap.get(cond);
        if (condNum == null) {
            throw new RefrigException("Unknown condition name: " + cond);
        }
        if (condNum != 3) {
            this.conditions[condNum.intValue()] = set ? ConditionState.YES : ConditionState.NO;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }

    static {
        latchMap.put("AfterTmp", 8);
        latchMap.put("DischPrs", 3);
        latchMap.put("DischTmp", 0);
        latchMap.put("ExtPermit", 5);
        latchMap.put("LiquidTmp", 2);
        latchMap.put("OilLevel", 9);
        latchMap.put("Power", 4);
        latchMap.put("SensValid", 7);
        latchMap.put("SmokeDetc", 6);
        latchMap.put("SuctnTmp", 1);
        conditionMap = new LinkedHashMap<String, Integer>();
        conditionMap.put("CmpEnabled", 1);
        conditionMap.put("CmpOn6Hrs", 14);
        conditionMap.put("CmpPowered", 3);
        conditionMap.put("CmpWaiting", 2);
        conditionMap.put("CurrentValid", 9);
        conditionMap.put("CurrSensErr", 13);
        conditionMap.put("DiscPrsValid", 7);
        conditionMap.put("DiscTmpValid", 4);
        conditionMap.put("KeySwitchOn", 0);
        conditionMap.put("LatchesClear", 11);
        conditionMap.put("LiqdTmpValid", 6);
        conditionMap.put("OilLvlValid", 15);
        conditionMap.put("PowerLedOn", 12);
        conditionMap.put("SuctPrsValid", 8);
        conditionMap.put("SuctTmpValid", 5);
        conditionMap.put("VoltageValid", 10);
    }
}

