/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.drivers.auxelex.HeaterConv;
import org.lsst.ccs.drivers.auxelex.LTC2945;
import org.lsst.ccs.drivers.auxelex.LambdaPS;
import org.lsst.ccs.drivers.auxelex.SA56004;
import org.lsst.ccs.drivers.auxelex.Srp;
import org.lsst.ccs.drivers.commons.DriverException;

public class HeaterPS
extends Srp {
    public static final int NUM_HEATERS = 12;
    public static final int MIN_SWITCH_PERIOD = 100;
    public static final int MAX_SWITCH_PERIOD = 500;
    private static final int REG_CONTROL_BASE = 0;
    private static final int CONTROL_INCREMENT = 2;
    private static final int REG_MONITOR_BASE = 65536;
    private static final int BULK_CHAN = 0;
    private static final int REG_LAMBDA_BASE = 131072;
    private static final int REG_LAMBDA_IO = 137216;
    private static final double SHUNT_020 = 0.02;
    private static final double MIN_SOURCE_VOLTS = 1.0;
    private static final List<Srp.BoardType> validTypes = new ArrayList<Srp.BoardType>();
    private final LTC2945 adc;
    private final LambdaPS bulk;
    private final SA56004 temp;
    private final HeaterConv conv = new HeaterConv();
    private int switchPeriod = 500;

    public HeaterPS() {
        this.setValidBoardTypes(validTypes);
        this.adc = new LTC2945(this, 65536);
        this.bulk = new LambdaPS(this, 131072, 1);
        this.temp = new SA56004(this);
    }

    @Override
    public void open(int node) throws DriverException {
        super.open(node);
        this.conv.setNode(node);
    }

    @Override
    public void open(String host) throws DriverException {
        super.open(host);
        this.conv.setNode(this.getIpAddress()[3]);
    }

    public void setSwitchPeriod(int period) throws DriverException {
        if (period < 100 || period > 500) {
            throw new DriverException("Switch period must be between 100 and 500");
        }
        this.switchPeriod = period;
    }

    public int getSwitchPeriod() {
        return this.switchPeriod;
    }

    public void setDutyCycle(int chan, double duty) throws DriverException {
        int high = Math.max(2, Math.min(this.switchPeriod - 2, (int)(duty * (double)this.switchPeriod)));
        int low = this.switchPeriod - high;
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        this.writeReg(regNum, this.readReg(regNum) & 0xFFFC0000 | low - 1 << 9 | high - 1);
    }

    public double getDutyCycle(int chan) throws DriverException {
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        int regVal = this.readReg(regNum);
        double high = (regVal & 0x1FF) + 1;
        double low = (regVal >> 9 & 0x1FF) + 1;
        return high / (high + low);
    }

    public void setVoltage(int chan, double volts) throws DriverException {
        this.checkChannelNumber(chan);
        double source = this.readMainVoltage();
        if (source < 1.0) {
            throw new DriverException("Board is not powered");
        }
        this.setDutyCycle(chan, this.conv.convVoltsAndDuty(true, chan, volts / source));
    }

    public double getVoltage(int chan) throws DriverException {
        this.checkChannelNumber(chan);
        return this.readMainVoltage() * this.conv.convVoltsAndDuty(false, chan, this.getDutyCycle(chan));
    }

    public void setOutput(int chan, boolean on) throws DriverException {
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        this.writeReg(regNum, this.readReg(regNum) & 0xF7FFFFFF | (on ? 1 : 0) << 27);
    }

    public boolean getOutput(int chan) throws DriverException {
        int regNum = 0 + 2 * this.checkChannelNumber(chan);
        return (this.readReg(regNum) & 0x8000000) != 0;
    }

    public double readVoltage(int chan) throws DriverException {
        return this.adc.readVoltage(this.checkChannelNumber(chan));
    }

    public double readCurrent(int chan) throws DriverException {
        return this.adc.readCurrent(this.checkChannelNumber(chan)) / 0.02;
    }

    public double readBoardTemperature() throws DriverException {
        return this.temp.readTemperature();
    }

    public int getMainModel() throws DriverException {
        return this.bulk.getModel();
    }

    public String getMainSerialNo() throws DriverException {
        return this.bulk.getSerialNo();
    }

    public String getMainFwVersion() throws DriverException {
        return this.bulk.getFwVersion();
    }

    public String getMainPrVersion() throws DriverException {
        return this.bulk.getPrVersion();
    }

    public String getMainPartNo() throws DriverException {
        return this.bulk.getPartNo();
    }

    public String getMainManuDate() throws DriverException {
        return this.bulk.getManuDate();
    }

    public String getMainManuLocn() throws DriverException {
        return this.bulk.getManuLocn();
    }

    public int readMainStatus() throws DriverException {
        return this.bulk.readStatus();
    }

    public double readMainVoltage() throws DriverException {
        return this.bulk.readVoltage();
    }

    public double readMainCurrent() throws DriverException {
        return this.bulk.readCurrent();
    }

    public double readMainTemperature() throws DriverException {
        return this.bulk.readTemperature();
    }

    public void setMainPowerOn(boolean on) throws DriverException {
        this.writeReg(137216, on ? 1 : 0);
    }

    public int getMainIoStatus() throws DriverException {
        return this.readReg(137216);
    }

    private int checkChannelNumber(int chan) throws DriverException {
        if (chan < 0 || chan >= 12) {
            throw new DriverException("Invalid heater channel number: " + chan);
        }
        return chan;
    }

    static {
        validTypes.add(Srp.BoardType.HEATER);
        validTypes.add(Srp.BoardType.SIMULATED);
    }
}

