/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.refrig.HeaterControl;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.data.RefrigState1;

public class RefrigMain1
implements HasLifecycle,
Monitor.AlarmHandler {
    public static final int ALARM_HEATER = 8;
    public static final int ALARM_ALL = 9;
    private static final int POWER_SET_INTVL = 5000;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, HeaterControl> tempControls = new HashMap<String, HeaterControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Line> allLines = new HashMap<String, Line>();
    private static final String REFRIG = "Refrig";
    private static final Logger LOG = Logger.getLogger(RefrigMain1.class.getName());
    private String[][] cmprPowerLines = new String[0][0];
    private String[] loadPowerLines = new String[0];
    private String[] alarmDsabChans = new String[0];
    private String tempCtrl;
    private boolean coldStart;
    private final List<List<Line>> cmprPowerLinesL = new ArrayList<List<Line>>();
    private final List<Line> loadPowerLinesL = new ArrayList<Line>();
    private final List<Channel> alarmDsabChansL = new ArrayList<Channel>();
    private PowerDevice loadPowerDevcD;
    private HeaterControl tempCtrlC;
    private final RefrigState1 state = new RefrigState1();
    private Double startPower = 0.0;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("heater-power", () -> this.setHeaterPower()).withPeriod(Duration.ofMillis(5000L));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.agentPropertiesService.setAgentProperty("refrigType", RefrigMain1.class.getCanonicalName());
        this.state.setTickMillis(this.getTickPeriod());
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
        for (String[] cLines : this.cmprPowerLines) {
            ArrayList<Line> lines = new ArrayList<Line>();
            for (String lName : cLines) {
                Line line = this.allLines.get(lName);
                if (line == null) continue;
                lines.add(line);
            }
            this.cmprPowerLinesL.add(lines);
        }
        this.state.setNumCmprs(Math.min(8, this.cmprPowerLinesL.size()));
        if (this.cmprPowerLinesL.isEmpty()) {
            LOG.severe("No valid compressors specified");
        } else if (this.state.getNumCmprs() != this.cmprPowerLines.length) {
            LOG.severe("Some compressors are invalid");
        }
        for (int j = 0; j < this.state.getNumCmprs(); ++j) {
            List<Line> lines = this.cmprPowerLinesL.get(j);
            if (lines.size() != this.cmprPowerLines[j].length) {
                LOG.log(Level.SEVERE, "Some (or all) control lines are invalid for compressor {0}", j);
                continue;
            }
            if (!lines.isEmpty()) continue;
            LOG.log(Level.SEVERE, "No control lines specified for compressor {0}", j);
        }
        for (String lName : this.loadPowerLines) {
            Line line = this.allLines.get(lName);
            if (line == null) continue;
            this.loadPowerLinesL.add(line);
        }
        if (this.loadPowerLinesL.size() != this.loadPowerLines.length) {
            LOG.severe("Some (or all) heater PS control lines are invalid");
        } else if (this.loadPowerLinesL.isEmpty()) {
            LOG.warning("No heater PS control lines specified: assume always on");
        }
        for (String cName : this.alarmDsabChans) {
            Channel chan = this.allChannels.get(cName);
            if (chan == null) continue;
            this.alarmDsabChansL.add(chan);
        }
        if (this.alarmDsabChansL.size() != this.alarmDsabChans.length) {
            LOG.severe("Some alarm disable channels are invalid");
        }
        this.tempCtrlC = this.tempControls.get(this.tempCtrl);
        if (this.tempCtrlC == null) {
            LOG.severe("No valid temperature controller (or heater control) specified");
            this.state.setHeaterControlState(3);
        } else {
            this.loadPowerDevcD = this.tempCtrlC.getPowerDevice();
        }
    }

    public void postStart() {
        for (List<Line> lines : this.cmprPowerLinesL) {
            for (Line line : lines) {
                line.setWarm(!this.coldStart);
            }
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(!this.coldStart);
        }
        for (List<Line> lines : this.cmprPowerLinesL) {
            for (Line line : lines) {
                line.setWarm(false);
            }
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(false);
        }
        for (int cmpr = 0; cmpr < this.state.getNumCmprs(); ++cmpr) {
            this.setCmprPowerEnable(cmpr, this.isCmprPowerOn(cmpr) ? 1 : 0);
        }
        this.setHeaterPowerEnable(this.isHeaterPowerOn() ? 1 : 0);
        LOG.log(Level.INFO, "Refrigeration subsystem ({0}) started", this.name);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigState1 getSystemState() {
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.state.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    public boolean processAlarm(int event, int parm, String cause, String name) {
        if (parm >= 0 && parm < this.state.getNumCmprs() || parm == 9) {
            int first = parm == 9 ? 0 : parm;
            int last = parm == 9 ? this.state.getNumCmprs() : parm + 1;
            for (int j = first; j < last; ++j) {
                if (event == 0) {
                    if (this.state.getCmprPowerState(j) == 2) continue;
                    this.state.setCmprPowerState(j, 2);
                    this.setCmprPowerSwitch(j);
                    this.publishState();
                    continue;
                }
                if (event != 3 || this.state.getCmprPowerState(j) != 2) continue;
                this.state.setCmprPowerState(j, 0);
                this.publishState();
            }
        }
        if (parm == 8 || parm == 9) {
            if (event == 0) {
                if (this.state.getHeaterPowerState() != 2) {
                    this.state.setHeaterPowerState(2);
                    this.setHeaterPowerSwitch();
                    this.publishState();
                }
            } else if (event == 3 && this.state.getHeaterPowerState() == 2) {
                this.state.setHeaterPowerState(0);
                this.publishState();
            }
        }
        return false;
    }

    @Command(type=Command.CommandType.ACTION, description="Set compressor power enabled state")
    public void setCmprPowerEnable(int cmpr, int value) {
        int newState;
        if (cmpr < 0 || cmpr >= this.state.getNumCmprs()) {
            LOG.severe("Invalid compressor number");
            return;
        }
        int oldState = this.state.getCmprPowerState(cmpr);
        int n = oldState == 2 ? oldState : (newState = value == 0 ? 0 : 1);
        if (newState != oldState) {
            this.state.setCmprPowerState(cmpr, newState);
            this.setCmprPowerSwitch(cmpr);
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int value) {
        int newState;
        int oldState = this.state.getHeaterPowerState();
        int n = oldState == 2 ? oldState : (newState = value == 0 ? 0 : 1);
        if (newState != oldState) {
            this.state.setHeaterPowerState(newState);
            this.setHeaterPowerSwitch();
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater control state")
    public void setHeaterControl(int value) {
        int oldState = this.state.getHeaterControlState();
        if (oldState != 3) {
            int newState;
            int n = value == 0 ? 0 : (value > 0 ? 1 : (newState = this.tempCtrlC != null ? 2 : 1));
            if (newState != oldState) {
                this.state.setHeaterControlState(newState);
                if (newState == 2) {
                    this.tempCtrlC.setTemp(this.state.getLoadTemp());
                    this.startTempControl();
                } else {
                    this.stopTempControl();
                    this.setHeaterPower();
                }
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load trip enabled state")
    public void setAlarmDisabled(int value) {
        boolean disable = value != 0;
        this.state.setAlarmDisabled(disable);
        for (Channel chan : this.alarmDsabChansL) {
            chan.enableAlarm(false, !disable);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power set point")
    public void setHeaterPower(double value) {
        this.state.setHeaterPower(value);
        if (this.startPower != null) {
            this.startPower = value;
        }
        this.setHeaterPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load temperature set point")
    public void setLoadTemp(double value) {
        this.state.setLoadTemp(value);
        if (this.tempCtrlC != null) {
            this.tempCtrlC.setTemp(value);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        this.sce.saveChangesForCategoriesAs(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.sce.loadCategories(new String[]{"Refrig:" + name});
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("RefrigState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void setCmprPowerSwitch(int cmpr) {
        boolean on = this.state.getCmprPowerState(cmpr) == 1;
        for (Line line : this.cmprPowerLinesL.get(cmpr)) {
            line.set(on);
        }
    }

    private void setHeaterPowerSwitch() {
        boolean on = this.state.getHeaterPowerState() == 1;
        for (Line line : this.loadPowerLinesL) {
            line.set(on);
        }
        if (this.loadPowerDevcD != null) {
            if (on) {
                this.loadPowerDevcD.enable();
                if (this.loadPowerLinesL.isEmpty()) {
                    this.loadPowerDevcD.enableOutput(0, true);
                }
                if (this.state.getHeaterControlState() == 2) {
                    this.startTempControl();
                }
            } else {
                this.stopTempControl();
                if (this.loadPowerLinesL.isEmpty()) {
                    this.loadPowerDevcD.enableOutput(0, false);
                } else {
                    this.loadPowerDevcD.disable();
                }
            }
        }
    }

    private void setHeaterPower() {
        if (this.loadPowerDevcD == null || !this.loadPowerDevcD.isOnline()) {
            return;
        }
        if (this.state.getHeaterPowerState() != 1) {
            return;
        }
        this.loadPowerDevcD.enableOutput(0, this.state.getHeaterControlState() != 0);
        if (this.state.getHeaterControlState() == 1) {
            double loadPower = this.state.getHeaterPower();
            this.loadPowerDevcD.setPower(0, loadPower);
            this.startPower = loadPower;
        }
    }

    private boolean isCmprPowerOn(int cmpr) {
        if (this.cmprPowerLinesL.isEmpty() || this.cmprPowerLinesL.get(cmpr).isEmpty()) {
            return false;
        }
        for (Line line : this.cmprPowerLinesL.get(cmpr)) {
            if (line.isSet().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean isHeaterPowerOn() {
        if (this.loadPowerLinesL.isEmpty()) {
            return true;
        }
        for (Line line : this.loadPowerLinesL) {
            if (line.isSet().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void startTempControl() {
        if (this.tempCtrlC != null) {
            if (this.startPower == null) {
                this.tempCtrlC.restart();
            } else {
                this.tempCtrlC.start(this.startPower);
                this.startPower = null;
            }
        }
    }

    private void stopTempControl() {
        if (this.tempCtrlC != null) {
            this.tempCtrlC.stop();
        }
    }
}

