/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.constants.ColdState;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.subsystem.refrig.data.UpdatePeriod;
import org.lsst.ccs.utilities.logging.Logger;

public class RefrigMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler,
AlertListener {
    private static final ColdState[] coldStates = new ColdState[]{ColdState.BOTH_OFF, ColdState.ONE_ON, ColdState.TWO_ON, ColdState.BOTH_ON};
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService peopertiesService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, ColdCompressor> coldCompMap = new LinkedHashMap<String, ColdCompressor>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, CryoCompressor> cryoCompMap = new LinkedHashMap<String, CryoCompressor>();
    private static final Logger LOG = Logger.getLogger((String)RefrigMain.class.getName());
    private final Compressor[] coldComps = new Compressor[2];
    private final Compressor[] cryoComps = new Compressor[6];
    private final RefrigState refrigState = new RefrigState();

    public RefrigMain() {
        super("refrig", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        String useFull = this.peopertiesService.getAgentProperty("org.lsst.ccs.use.full.paths");
        if (useFull == null || !useFull.equals("true")) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"org.lsst.ccs.use.full.paths", (String)"not defined as true");
        }
        AgentPeriodicTask pt = new AgentPeriodicTask("compressor-state", () -> this.publishUpdatedRefrigState()).withPeriod(Duration.ofMillis(2000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("update-time", () -> this.publishUpdateTime()).withPeriod(Duration.ofMillis(5000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        this.stateService.registerState(ColdState.class, "Overall cold compressor state", (Object)this);
        this.stateService.updateAgentState(new Enum[]{ColdState.UNKNOWN});
    }

    public void postInit() {
        int j;
        ArrayList<String> keys;
        int nComp;
        this.peopertiesService.setAgentProperty("compressorType", RefrigMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        if (this.coldCompMap.isEmpty() && this.cryoCompMap.isEmpty()) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"No compressors", (String)"defined");
        }
        if ((nComp = this.coldCompMap.size()) > 2) {
            LOG.warning((Object)("Too many (" + nComp + ") cold compressors specified: using only the first " + 2));
            keys = new ArrayList<String>(this.coldCompMap.keySet());
            for (j = 2; j < nComp; ++j) {
                this.coldCompMap.remove(keys.get(j));
            }
        }
        nComp = 0;
        keys = this.coldCompMap.values().iterator();
        while (keys.hasNext()) {
            Compressor comp;
            this.coldComps[nComp] = comp = (Compressor)keys.next();
            comp.setIndex(nComp++);
        }
        this.refrigState.setNumColdComps(nComp);
        nComp = this.cryoCompMap.size();
        if (nComp > 6) {
            LOG.warning((Object)("Too many (" + nComp + ") cryo compressors specified: using only the first " + 6));
            keys = new ArrayList<String>(this.cryoCompMap.keySet());
            for (j = 6; j < nComp; ++j) {
                this.cryoCompMap.remove(keys.get(j));
            }
        }
        nComp = 0;
        Iterator<CryoCompressor> iterator = this.cryoCompMap.values().iterator();
        while (iterator.hasNext()) {
            Compressor comp;
            this.cryoComps[nComp] = comp = (Compressor)iterator.next();
            comp.setIndex(nComp++);
        }
        this.refrigState.setNumCryoComps(nComp);
    }

    public void postStart() {
        LOG.info((Object)("Refrigeration subsystem started with " + this.coldCompMap.size() + " cold compressors and " + this.cryoCompMap.size() + " cryo compressors"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description="Get the refrigeration state")
    public RefrigState getSystemState() {
        RefrigState refrigState = this.refrigState;
        synchronized (refrigState) {
            this.refrigState.clearCompStates();
            this.refrigState.setTickMillis(this.getTickPeriod());
            for (Compressor compressor : this.coldCompMap.values()) {
                this.refrigState.addColdState(compressor.getState());
            }
            for (Compressor compressor : this.cryoCompMap.values()) {
                this.refrigState.addCryoState(compressor.getState());
            }
            return this.refrigState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        RefrigState refrigState = this.refrigState;
        synchronized (refrigState) {
            this.setTickPeriod(value);
            this.refrigState.clearCompStates();
            this.publishState();
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        String id = alert.getAlertId();
        for (String compName : this.coldCompMap.keySet()) {
            if (!id.startsWith(compName)) continue;
            return this.coldCompMap.get(compName).canClearAlert(alert);
        }
        for (String compName : this.cryoCompMap.keySet()) {
            if (!id.startsWith(compName)) continue;
            return this.cryoCompMap.get(compName).canClearAlert(alert);
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        block0: for (String id : event.getClearedIds()) {
            if (!id.endsWith("PLC")) continue;
            boolean reset = false;
            for (String compName : this.coldCompMap.keySet()) {
                if (!id.startsWith(compName)) continue;
                this.coldCompMap.get(compName).resetLatches();
                reset = true;
                break;
            }
            if (reset) continue;
            for (String compName : this.cryoCompMap.keySet()) {
                if (!id.startsWith(compName)) continue;
                this.cryoCompMap.get(compName).resetLatches();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishUpdatedRefrigState() {
        RefrigState refrigState = this.refrigState;
        synchronized (refrigState) {
            boolean changed = false;
            this.refrigState.clearCompStates();
            int running = 0;
            for (Compressor compressor : this.coldCompMap.values()) {
                CompressorState compState;
                compressor.checkLimits();
                if (compressor.updateState()) {
                    changed = true;
                    this.refrigState.addColdState(compressor.getState());
                }
                if ((compState = compressor.getState().getCompressorState()) != CompressorState.RUNNING && compState != CompressorState.WAITING) continue;
                running |= 1 << compressor.getIndex();
            }
            this.stateService.updateAgentState(new Enum[]{coldStates[running]});
            for (Compressor compressor : this.cryoCompMap.values()) {
                compressor.controlValves();
                compressor.checkLimits();
                if (!compressor.updateState()) continue;
                changed = true;
                this.refrigState.addCryoState(compressor.getState());
            }
            if (changed) {
                this.publishState();
            }
        }
    }

    private void publishUpdateTime() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("UpdatePeriod", (Serializable)new UpdatePeriod(this.getTickPeriod())));
    }

    private void publishState() {
        this.refrigState.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("RefrigState", (Serializable)this.refrigState));
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

