/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class CompSimMaq20Device
extends CompMaq20Device {
    private final boolean[] coldSwitches = new boolean[0];
    private final boolean[] cryoSwitches = new boolean[4];
    private boolean[] switches;
    private final Map<String, Integer> channelMap = new HashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        return new int[]{index, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return this.channelValues.get(type);
    }

    @Override
    public void setType(int type) {
        this.switches = type == 0 ? this.coldSwitches : this.cryoSwitches;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw - 1] = on;
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw - 1];
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws RefrigException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new RefrigException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

