/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Control;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.utilities.logging.Logger;

public class CompMaq20Device
extends Maq20Device
implements Compressor.SwitchDevice {
    public static final int NUM_COLD_SWITCHES = 0;
    public static final int SW_COOLANT_VALVE = 1;
    public static final int SW_ORIFICE_VALVE = 2;
    public static final int SW_BYPASS_VALVE = 3;
    public static final int SW_SURGE_HEATER = 4;
    public static final int NUM_CRYO_SWITCHES = 4;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20Control ctrl;
    private static final Logger LOG = Logger.getLogger((String)CompMaq20Device.class.getName());
    private int numSwitches = 0;

    public void setType(int type) {
        if (type == 1 && this.ctrl == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 discrete control", (String)"not defined");
        }
        this.numSwitches = type == 1 ? 4 : 0;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) throws RefrigException {
        try {
            this.ctrl.setLineOn(sw, on);
        }
        catch (DriverException e) {
            throw new RefrigException(e.getMessage());
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.ctrl.isLineOn(sw);
    }
}

