/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class WUDevice
extends Device
implements WattsUp.Listener {
    private static final int CHAN_WATTS = 0;
    private static final int CHAN_VOLTS = 1;
    private static final int CHAN_FREQ = 2;
    private static final int N_DEV_CHANS = 3;
    private static final int LOG_PERIOD = 1;
    private String node;
    private String serial;
    private static final Logger LOG = Logger.getLogger((String)WUDevice.class.getName());
    private WattsUp wtu;
    private final double[] value = new double[3];

    protected void initDevice() {
        super.configure(this.mon);
        this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.wtu == null) {
                this.wtu = new WattsUp();
                this.wtu.addListener((WattsUp.Listener)this);
            }
            this.wtu.openFtdi(this.serial, 0);
            this.wtu.restart();
            this.setOnline(true);
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(int chan, int type) {
        return this.online ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(65539);
                this.wtu.setExternalLogging(1);
            }
            catch (DriverException e) {
                LOG.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)));
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                this.value[j] = 0.0;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
        this.value[2] = data[16];
    }
}

