/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class PowerDevice
extends Device {
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int CONN_TYPE_NOT_CONFIG = 2;
    protected static final int DEVC_ID_NOT_CONFIG = 4;
    protected static final int DEVC_PARM_NOT_CONFIG = 8;
    protected static final int MON_TYPE_POWER = 0;
    protected static final int MON_TYPE_VOLTAGE = 1;
    protected static final int MON_TYPE_CURRENT = 2;
    private static final double MIN_VOLTAGE = 4.0;
    private static final double MAX_CURRENT = 3.0;
    private static final double TIMEOUT = 2.0;
    private static final String REFRIG = "Refrig";
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    protected static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="connType", category="Refrig", isFinal=true)
    protected DriverConstants.ConnType connType;
    @ConfigurationParameter(name="devcId", category="Refrig", isFinal=true)
    protected String devcId;
    @ConfigurationParameter(name="devcParm", category="Refrig", isFinal=true)
    protected int devcParm = 0;
    protected double[] maxCurrent;
    protected double timeout = 2.0;
    private static final Logger LOG;
    private final String devcName;
    protected PowerSupplyDriver psd;
    private final int options;
    private final int minChan;
    private final int maxChan;
    private final double[] voltages;
    private final double[] currents;
    private final Map<Integer, ChannelState> states = new HashMap<Integer, ChannelState>();

    public PowerDevice(String name, PowerSupplyDriver psd, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
        this.maxCurrent = new double[maxChan - minChan + 1];
        Arrays.fill(this.maxCurrent, 3.0);
        this.voltages = new double[maxChan - minChan + 1];
        this.currents = new double[maxChan - minChan + 1];
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the connection type")
    public DriverConstants.ConnType getConnType() {
        return this.connType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initDevice() {
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is missing");
        }
        if (this.connType == DriverConstants.ConnType.NET && (this.options & 1) != 0) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)CONN_TYPE, (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = this.devcName + (this.devcId.isEmpty() ? "" : " (" + this.devcId + ")");
    }

    protected void initialize() {
        try {
            this.psd.open(this.connType, this.devcId, this.devcParm);
            this.setOnline(true);
            this.initSensors();
            for (int j = 0; j < this.maxCurrent.length; ++j) {
                this.setCurrent(this.minChan + j, this.maxCurrent[j]);
            }
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType;
        if (hwChan < this.minChan || hwChan > this.maxChan) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        if ((iType = mTypeMap.get(type.toUpperCase())) == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void readChannelGroup() {
        Arrays.fill(this.voltages, Double.NaN);
        Arrays.fill(this.currents, Double.NaN);
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            try {
                switch (type) {
                    case 2: {
                        double d = this.readCurrent(hwChan);
                        this.currents[hwChan - this.minChan] = d;
                        value = d;
                        break;
                    }
                    case 1: {
                        double d = this.readVoltage(hwChan);
                        this.voltages[hwChan - this.minChan] = d;
                        value = d;
                        break;
                    }
                    case 0: {
                        value = this.voltages[hwChan - this.minChan] * this.currents[hwChan - this.minChan];
                        if (!Double.isNaN(value)) break;
                        value = this.readVoltage(hwChan) * this.readCurrent(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                this.logError("Error reading from", hwChan, e);
                this.setOnline(false);
            }
        }
        return value;
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (this.isOnline()) {
            for (int chan : this.states.keySet()) {
                ChannelState state = this.states.get(chan);
                try {
                    state.enabled = this.getOutput(chan);
                    state.power = (double)Math.round(10.0 * this.readVoltage(chan) * this.readCurrent(chan)) / 10.0;
                    state.voltError = false;
                    state.cantSet = false;
                    state.noLoad = false;
                }
                catch (DriverException e) {
                    this.logError("Error reading from", chan, e);
                }
            }
        }
    }

    public void enableOutput(int chan, boolean enable) {
        ChannelState state = this.getChannelState(chan);
        try {
            this.setOutput(chan, enable);
            state.enabled = enable;
            if (!enable) {
                state.voltError = false;
                state.cantSet = false;
                state.noLoad = false;
            }
        }
        catch (DriverException e) {
            this.logError("Error enabling output for", chan, e);
        }
    }

    public void setPower(int chan, double value) {
        double prevOhms;
        int j;
        double ohms;
        boolean okay;
        ChannelState state = this.getChannelState(chan);
        if (!state.enabled) {
            return;
        }
        ArrayList<Float> values = new ArrayList<Float>();
        if (!Double.isNaN(value)) {
            state.power = value;
        }
        if (state.resistance == 0.0) {
            okay = false;
            ohms = 0.0;
            for (j = 0; j < 10 && !okay; ++j) {
                prevOhms = ohms;
                this.setChanVoltage(chan, 4.0);
                double amps = this.readChanCurrent(chan);
                values.add(Float.valueOf((float)amps));
                ohms = amps <= 0.0 ? Double.NaN : this.readChanVoltage(chan) / amps;
                okay = this.areClose(ohms, prevOhms);
            }
            if (okay && ohms != 0.0) {
                state.resistance = ohms;
                state.noLoad = false;
            } else {
                if (!state.noLoad) {
                    this.logError("Unable to determine load resistance for", chan, null);
                }
                state.noLoad = true;
            }
        }
        if (state.resistance != 0.0) {
            okay = false;
            ohms = state.resistance;
            for (j = 0; j < 5 && !okay; ++j) {
                prevOhms = ohms;
                double volts = Math.sqrt(state.power * state.resistance);
                this.setChanVoltage(chan, volts);
                values.add(Float.valueOf((float)volts));
                double amps = this.readChanCurrent(chan);
                ohms = amps <= 0.0 ? 0.0 : this.readChanVoltage(chan) / amps;
                okay = this.areClose(ohms, prevOhms);
            }
            if (okay) {
                if (ohms != 0.0) {
                    state.resistance = ohms;
                    double volts = Math.sqrt(state.power * state.resistance);
                    this.setChanVoltage(chan, volts);
                    values.add(Float.valueOf((float)volts));
                }
                state.cantSet = false;
            } else {
                if (!state.cantSet) {
                    this.logError("Unable to set power consistently", chan, null);
                }
                state.cantSet = true;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("Setting " + this.name + " channel " + chan + " power to ");
            msg.append((float)state.power).append(": currents/voltages =");
            for (Float v : values) {
                msg.append(" ").append(v);
            }
            LOG.fine((Object)msg.toString());
        }
    }

    public void maintainPower(int chan) {
        this.setPower(chan, Double.NaN);
    }

    private boolean areClose(double val1, double val2) {
        if (val2 == 0.0) {
            return val1 == 0.0;
        }
        return Math.abs((val1 - val2) / val2) < 0.05;
    }

    public double getPower(int chan) {
        return this.getChannelState(chan).power;
    }

    public boolean isEnabled(int chan) {
        return this.getChannelState(chan).enabled;
    }

    public boolean hasVoltError(int chan) {
        return this.getChannelState(chan).voltError;
    }

    public boolean hasNoLoad(int chan) {
        return this.getChannelState(chan).noLoad;
    }

    public boolean hasCantSet(int chan) {
        return this.getChannelState(chan).cantSet;
    }

    private void setChanVoltage(int chan, double value) {
        if (!this.isOnline()) {
            return;
        }
        ChannelState state = this.getChannelState(chan);
        try {
            this.setVoltage(chan, value);
            state.voltError = false;
        }
        catch (DriverException e) {
            if (!state.voltError) {
                this.logError("Error setting voltage on", chan, e);
            }
            state.voltError = true;
        }
    }

    private double readChanVoltage(int chan) {
        if (!this.isOnline()) {
            return Double.NaN;
        }
        try {
            return this.readVoltage(chan);
        }
        catch (DriverException e) {
            this.logError("Error reading voltage from", chan, e);
            return Double.NaN;
        }
    }

    private double readChanCurrent(int chan) {
        if (!this.isOnline()) {
            return Double.NaN;
        }
        try {
            return this.readCurrent(chan);
        }
        catch (DriverException e) {
            this.logError("Error reading current from", chan, e);
            return Double.NaN;
        }
    }

    private boolean getChanOutput(int chan) {
        if (!this.isOnline()) {
            return false;
        }
        try {
            return this.getOutput(chan);
        }
        catch (DriverException e) {
            this.logError("Error getting output state from", chan, e);
            return false;
        }
    }

    public void setVoltage(int chan, double value) throws DriverException {
        this.psd.setVoltage(value, chan);
    }

    public void setCurrent(int chan, double value) throws DriverException {
        this.psd.setCurrent(value, chan);
    }

    public void setOutput(int chan, boolean value) throws DriverException {
        this.psd.setOutput(value, chan);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.psd.readVoltage(chan);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.psd.readCurrent(chan);
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.psd.getOutput(chan);
    }

    private ChannelState getChannelState(int chan) {
        ChannelState state = this.states.get(chan);
        if (state == null) {
            state = new ChannelState();
            this.states.put(chan, state);
        }
        return state;
    }

    private void logError(String msg, int chan, DriverException e) {
        LOG.severe((Object)(msg + " " + this.name + " channel " + chan + (e == null ? "" : ": " + (Object)((Object)e))));
    }

    static {
        mTypeMap.put("POWER", 0);
        mTypeMap.put("VOLTAGE", 1);
        mTypeMap.put("CURRENT", 2);
        LOG = Logger.getLogger((String)PowerDevice.class.getName());
    }

    public static class ChannelState {
        private double resistance;
        private double power;
        private boolean enabled;
        private boolean voltError;
        private boolean cantSet;
        private boolean noLoad;
    }
}

