/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.common.devices.Maq20PWMControl;

public class FanControl
implements HasLifecycle {
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput = 10.0;
    private Double awGain;
    private Double baseDuty;
    private Double tolerance;
    private double minOutput = 1.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String ambientTemp;
    private String cabinetTemp;
    private String fanCntrl;
    @LookupPath
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, Maq20PWMControl> allFans = new HashMap<String, Maq20PWMControl>();
    private static final Logger LOG = Logger.getLogger(FanControl.class.getName());
    private Channel ambChannel;
    private Channel cabChannel;
    private Maq20PWMControl maqControl;
    private PIController pic;
    private double lastDuty;
    private boolean active;
    private double setTemp = 1.0;

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask(this.name + "-timer", () -> this.iterateLoop()).withPeriod(Duration.ofMillis(this.updateTime.intValue()));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        if (this.gain == null) {
            this.reportConfigError("gain", "is missing");
        }
        if (this.timeConst == null) {
            this.reportConfigError("timeConst", "is missing");
        }
        if (this.smoothTime == null) {
            this.reportConfigError("smoothTime", "is missing");
        }
        if (this.maxOutput == null) {
            this.reportConfigError("maxOutput", "is missing");
        }
        if (this.awGain == null) {
            this.reportConfigError("awGain", "is missing");
        }
        if (this.baseDuty == null) {
            this.reportConfigError("baseDuty", "is missing");
        }
        if (this.tolerance == null) {
            this.reportConfigError("tolerance", "is missing");
        }
        if (this.updateTime == null) {
            this.reportConfigError("updateTime", "is missing");
        }
        Channel channel = this.ambChannel = this.ambientTemp == null ? null : this.allChannels.get(this.ambientTemp);
        if (this.ambChannel == null) {
            this.reportConfigError("ambientTemp", "is missing or is not a Channel");
        }
        Channel channel2 = this.cabChannel = this.cabinetTemp == null ? null : this.allChannels.get(this.cabinetTemp);
        if (this.cabChannel == null) {
            this.reportConfigError("cabinetTemp", "is missing or is not a Channel");
        }
        Maq20PWMControl maq20PWMControl = this.maqControl = this.fanCntrl == null ? null : this.allFans.get(this.fanCntrl);
        if (this.maqControl == null) {
            this.reportConfigError("fanCtrl", "is missing or is not a Maq20PWMControl");
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.baseDuty.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
        this.pic.setSetpoint(this.setTemp);
    }

    private void setDutyCycle(double duty) {
        try {
            this.maqControl.setDutyCycle1(duty);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error setting {0} fan speed: {1}", new Object[]{this.name, ex});
        }
    }

    public void setTemperature(double temp) {
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void setGain(double gain) {
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(gain, this.timeConst.doubleValue());
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) {
        this.timeConst = time;
        this.pic.setPID(this.gain.doubleValue(), this.timeConst.doubleValue());
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public synchronized void startLoop(double duty) {
        if (this.active) {
            return;
        }
        this.lastDuty = duty == 0.0 ? this.maxOutput : Math.min(1.0 / duty, this.maxOutput);
        this.startLoop();
    }

    public synchronized void startLoop() {
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastDuty - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() {
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() {
        this.pic.reset();
    }

    private synchronized void iterateLoop() {
        if (!this.active) {
            return;
        }
        double tempDiff = this.cabChannel.getValue() - this.ambChannel.getValue();
        if (!Double.isNaN(tempDiff)) {
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastDuty = this.pic.performPI(new double[]{tempDiff}, tod);
            this.setDutyCycle(1.0 / this.lastDuty);
        } else {
            LOG.log(Level.SEVERE, "{0} control loop iteration failed: temperature values not available", this.name);
        }
    }

    private void reportConfigError(String param, String desc) {
        LOG.log(Level.SEVERE, "{0} configuration parameter {1} {2}", new Object[]{this.name, param, desc});
        throw new RuntimeException("Fatal configuration error");
    }
}

