package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.subsystem.refrig.data.CompState;

/**
 *  Handles the simulated compressor MAQ20 device.
 *
 *  @author Owen Saxton
 */
public class CompSimMaq20Device extends CompMaq20Device {

    private final boolean[] coldSwitches = new boolean[NUM_COLD_SWITCHES];
    private final boolean[] cryoSwitches = new boolean[NUM_CRYO_SWITCHES];
    private boolean[] switches;


    /**
     *  Performs basic initialization.
     */
    @Override
    protected void initDevice()
    {
    }


    /**
     *  Performs full initialization.
     */
    @Override
    protected void initialize()
    {
        setOnline(true);
    }


    /**
     *  Closes device connection.
     */
    @Override
    protected void close()
    {
    }


    /**
     *  Checks a channel's parameters for validity.
     *
     *  @param  name     The channel name
     *  @param  hwChan   The hardware channel number
     *  @param  type     The channel type string
     *  @param  subtype  The channel subtype string
     *  @return  A two-element array containing the encoded type [0] and subtype [1] values.
     */
    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype)
    {
        return new int[]{0, 0};
    }


    /**
     *  Reads all referenced channels.
     */
    @Override
    protected void readChannelGroup()
    {
    }


    /**
     *  Reads a channel.
     *
     *  @param  hwChan   The hardware channel number.
     *  @param  type     The encoded channel type returned by checkChannel.
     *  @return  The read value
     */
    @Override
    protected double readChannel(int hwChan, int type)
    {
        return 0.0;
    }


    /**
     *  Sets the compressor type.
     *
     *  @param  type  The type (cold or cryo)
     */
    @Override
    public void setType(int type)
    {
        switches = type == CompState.TYPE_COLD ? coldSwitches : cryoSwitches;
    }


    /**
     *  Sets a switch on or off.
     *
     *  @param  sw  The switch number.
     *  @param  on  The on state to set: true or false
     */
    @Override
    public void setSwitchOn(int sw, boolean on)
    {
        switches[sw - 1] = on;
    }


    /**
     *  Gets the on state of a switch.
     *
     *  @param  sw  The switch number.
     *  @return  Whether the switch is on
     */
    @Override
    public Boolean isSwitchOn(int sw)
    {
        return switches[sw - 1];
    }

}
