/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class PowerDevice
extends Device {
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int CONN_TYPE_NOT_CONFIG = 2;
    protected static final int DEVC_ID_NOT_CONFIG = 4;
    protected static final int DEVC_PARM_NOT_CONFIG = 8;
    protected static final int MON_TYPE_POWER = 0;
    protected static final int MON_TYPE_VOLTAGE = 1;
    protected static final int MON_TYPE_CURRENT = 2;
    private static final double MIN_VOLTAGE = 4.0;
    private static final double MAX_CURRENT = 3.0;
    private static final double TIMEOUT = 2.0;
    private static final String REFRIG = "Refrig";
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    protected static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    private final Map<Integer, PowerState> states = new HashMap<Integer, PowerState>();
    @ConfigurationParameter(name="connType", category="Refrig", isFinal=true)
    protected DriverConstants.ConnType connType;
    @ConfigurationParameter(name="devcId", category="Refrig", isFinal=true)
    protected String devcId;
    @ConfigurationParameter(name="devcParm", category="Refrig", isFinal=true)
    protected int devcParm = 0;
    protected double[] maxCurrent;
    protected double timeout = 2.0;
    private static final Logger LOG;
    private final String devcName;
    protected PowerSupplyDriver psd;
    private final int options;
    private final int minChan;
    private final int maxChan;
    private final double[] voltages;
    private final double[] currents;

    public PowerDevice(String name, PowerSupplyDriver psd, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
        this.maxCurrent = new double[maxChan - minChan + 1];
        Arrays.fill(this.maxCurrent, 3.0);
        this.voltages = new double[maxChan - minChan + 1];
        this.currents = new double[maxChan - minChan + 1];
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the connection type")
    public DriverConstants.ConnType getConnType() {
        return this.connType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initDevice() {
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is missing");
        }
        if (this.connType == DriverConstants.ConnType.NET && (this.options & 1) != 0) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)CONN_TYPE, (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = this.devcName + (this.devcId.isEmpty() ? "" : " (" + this.devcId + ")");
    }

    protected void initialize() {
        try {
            this.psd.open(this.connType, this.devcId, this.devcParm);
            this.setOnline(true);
            this.initSensors();
            for (int j = 0; j < this.maxCurrent.length; ++j) {
                this.psd.setCurrent(this.maxCurrent[j], this.minChan + j);
            }
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType;
        if (hwChan < this.minChan || hwChan > this.maxChan) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        if ((iType = mTypeMap.get(type.toUpperCase())) == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void readChannelGroup() {
        Arrays.fill(this.voltages, Double.NaN);
        Arrays.fill(this.currents, Double.NaN);
    }

    protected double readChannel(int hwChan, int type) {
        double power = Double.NaN;
        if (this.online) {
            try {
                switch (type) {
                    case 2: {
                        double d = this.psd.readCurrent(hwChan);
                        this.currents[hwChan - this.minChan] = d;
                        power = d;
                        break;
                    }
                    case 1: {
                        double d = this.psd.readVoltage(hwChan);
                        this.voltages[hwChan - this.minChan] = d;
                        power = d;
                        break;
                    }
                    case 0: {
                        power = this.voltages[hwChan - this.minChan] * this.currents[hwChan - this.minChan];
                        if (!Double.isNaN(power)) break;
                        power = this.psd.readVoltage(hwChan) * this.psd.readCurrent(hwChan);
                    }
                }
            }
            catch (DriverException e) {
                LOG.severe((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return power;
    }

    public void enableOutput(int chan, boolean enable) {
        this.getPowerState(chan).enabled = enable;
        this.setOutput(chan, enable);
    }

    public void setPower(int chan, double value) {
        double prevOhms;
        int j;
        double ohms;
        boolean okay;
        PowerState state = this.getPowerState(chan);
        if (!state.enabled) {
            return;
        }
        ArrayList<Float> voltages = new ArrayList<Float>();
        state.power = value;
        if (state.resistance == 0.0) {
            okay = false;
            ohms = 0.0;
            for (j = 0; j < 5 && !okay; ++j) {
                prevOhms = ohms;
                this.setVoltage(chan, 4.0);
                double amps = this.readCurrent(chan);
                ohms = amps <= 0.0 ? 0.0 : this.readVoltage(chan) / amps;
                okay = this.areClose(ohms, prevOhms);
            }
            if (okay && ohms != 0.0) {
                state.resistance = ohms;
            } else {
                LOG.severe((Object)"Unable to determine load resistance");
                return;
            }
        }
        okay = false;
        ohms = 0.0;
        for (j = 0; j < 5 && !okay; ++j) {
            prevOhms = ohms;
            double volts = Math.sqrt(state.power * state.resistance);
            this.setVoltage(chan, volts);
            voltages.add(Float.valueOf((float)volts));
            double amps = this.readCurrent(chan);
            ohms = amps <= 0.0 ? 0.0 : this.readVoltage(chan) / amps;
            okay = this.areClose(ohms, state.resistance) || this.areClose(ohms, prevOhms);
        }
        if (okay) {
            if (ohms != 0.0) {
                state.resistance = ohms;
                double volts = Math.sqrt(state.power * state.resistance);
                this.setVoltage(chan, volts);
                voltages.add(Float.valueOf((float)volts));
            }
        } else {
            LOG.severe((Object)"Unable to set power consistently");
        }
        StringBuilder msg = new StringBuilder("Setting power to ");
        msg.append((float)value).append(": voltages =");
        for (Float v : voltages) {
            msg.append(" ").append(v);
        }
        LOG.fine((Object)msg.toString());
    }

    private boolean areClose(double val1, double val2) {
        if (val2 == 0.0) {
            return val1 == 0.0;
        }
        return Math.abs((val1 - val2) / val2) < 0.05;
    }

    public boolean isEnabled(int chan) {
        return this.getPowerState(chan).enabled;
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (online) {
            for (Integer chan : this.states.keySet()) {
                this.setPower(chan, this.states.get(chan).power);
            }
        }
    }

    public void setVoltage(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.psd.setVoltage(value, chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    public void setCurrent(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.psd.setCurrent(value, chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    public void setOutput(int chan, boolean value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.psd.setOutput(value, chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    public double readVoltage(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.psd.readVoltage(chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    public double readCurrent(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.psd.readCurrent(chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    public boolean getOutput(int chan) {
        if (!this.testOnline()) {
            return false;
        }
        try {
            return this.psd.getOutput(chan);
        }
        catch (DriverException e) {
            LOG.severe((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return false;
        }
    }

    private PowerState getPowerState(int chan) {
        PowerState state = this.states.get(chan);
        if (state == null) {
            state = new PowerState();
            this.states.put(chan, state);
        }
        return state;
    }

    static {
        mTypeMap.put("POWER", 0);
        mTypeMap.put("VOLTAGE", 1);
        mTypeMap.put("CURRENT", 2);
        LOG = Logger.getLogger((String)PowerDevice.class.getName());
    }

    public static class PowerState {
        private double resistance;
        private double power;
        private boolean enabled;
    }
}

