/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.Arrays;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;

public class CompSimPlutoDevice
extends CompPlutoDevice {
    private final boolean[] coldSwitches = new boolean[2];
    private final boolean[] cryoSwitches = new boolean[3];
    private final LatchState[] latches = new LatchState[10];
    private final ConditionState[] conditions = new ConditionState[16];
    private boolean[] switches;
    private long powerTime = 0L;

    public CompSimPlutoDevice() {
        Arrays.fill((Object[])this.latches, (Object)LatchState.CLEAR);
        Arrays.fill((Object[])this.conditions, (Object)ConditionState.YES);
        this.conditions[1] = ConditionState.NO;
        this.conditions[2] = ConditionState.NO;
        this.conditions[3] = ConditionState.NO;
    }

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) {
        return new int[]{0, 0};
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return 0.0;
    }

    @Override
    public void setType(int type) {
        this.switches = type == 0 ? this.coldSwitches : this.cryoSwitches;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
        if (sw == 0) {
            if (on) {
                this.powerTime = System.currentTimeMillis() + 30000L;
                this.conditions[1] = ConditionState.YES;
                if (this.areLatchesClear()) {
                    this.conditions[2] = ConditionState.YES;
                    this.conditions[3] = ConditionState.YES;
                }
            } else {
                this.powerTime = 0L;
                this.conditions[1] = ConditionState.NO;
                this.conditions[2] = ConditionState.NO;
                this.conditions[3] = ConditionState.NO;
            }
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (this.powerTime != 0L && System.currentTimeMillis() >= this.powerTime) {
            this.conditions[2] = ConditionState.NO;
            this.powerTime = 0L;
        }
        return this.switches[sw];
    }

    @Override
    public LatchState getLatchState(int cond) {
        return this.latches[cond];
    }

    @Override
    public ConditionState getConditionState(int cond) {
        return this.conditions[cond];
    }

    @Override
    public void resetLatches() {
        for (int cond = 0; cond < this.latches.length; ++cond) {
            LatchState state = this.latches[cond];
            this.latches[cond] = state == LatchState.LATCHED ? LatchState.CLEAR : state;
        }
        if (this.switches[0] && this.areLatchesClear()) {
            this.conditions[3] = ConditionState.YES;
        }
    }

    private boolean areLatchesClear() {
        boolean clear = true;
        for (LatchState state : this.latches) {
            if (state == LatchState.CLEAR) continue;
            clear = false;
            break;
        }
        return clear;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchActive(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = LatchState.ACTIVE;
        this.conditions[3] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchLatched(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = LatchState.LATCHED;
        this.conditions[3] = ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchWarning(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = LatchState.WARNING;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setCondition(@Argument(description="Running condition number") int cond, @Argument(description="Condition on state") boolean set) {
        if (cond != 3) {
            this.conditions[cond] = set ? ConditionState.YES : ConditionState.NO;
        }
    }
}

