/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.lsst.ccs.drivers.agilent.DL34970;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class DL34970Device
extends Device {
    private static final int BAUD_RATE = 9600;
    private static final String tcTypes = "JKTERSBN";
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, DL34970.TcType> tcMap;
    private String connType;
    private String devcId;
    private int baudRate = 9600;
    private static final Logger LOG;
    private DriverConstants.ConnType connTypeC;
    private DL34970 dl;
    private final Set<Integer> hwChanSet = new TreeSet<Integer>();
    private final Map<Integer, Integer> hwChanMap = new HashMap<Integer, Integer>();
    private double[] chanValues;
    private boolean reallyOnline;

    public DL34970Device(String connType, String devcId, int baudRate) {
        this.connType = connType;
        this.devcId = devcId;
        this.baudRate = baudRate == 0 ? 9600 : baudRate;
    }

    public DL34970Device() {
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"connType", (String)"is missing");
        }
        this.connTypeC = cTypeMap.get(this.connType);
        if (this.connTypeC == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"connType", (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"devcId", (String)"is missing");
        }
        this.fullName = "DL34970 Logger (" + this.devcId + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        try {
            if (!this.inited || this.dl == null) {
                this.dl = new DL34970();
            }
            this.dl.open(this.connTypeC, this.devcId, this.baudRate);
            this.setOnline(true);
            this.initSensors();
            if (this.online && !this.hwChanSet.isEmpty()) {
                int index = 0;
                int[] chans = new int[this.hwChanSet.size()];
                for (int chan : this.hwChanSet) {
                    this.hwChanMap.put(chan, index);
                    chans[index++] = chan;
                }
                this.dl.setScanList(chans);
                this.reallyOnline = true;
            }
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.dl != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        this.reallyOnline = false;
        try {
            this.dl.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        int iSubtype = 0;
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (iType == 0) {
            int n = iSubtype = subtype.length() == 1 ? tcTypes.indexOf(subtype) : -1;
            if (iSubtype < 0) {
                MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"subtype", (Object)subtype);
            }
        } else if (iType == 1) {
            try {
                double range = Math.abs(Double.valueOf(subtype));
                double exp = Math.floor(Math.log10(range));
                double fract = range / Math.pow(10.0, exp);
                iSubtype = (int)(exp - 3.0) << 16 | (int)(1000.0 * fract);
            }
            catch (NumberFormatException e) {
                MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"subtype", (Object)subtype);
            }
        }
        this.hwChanSet.add(hwChan);
        return new int[]{iType, iSubtype};
    }

    protected void initChannel(int chan, int type, int subtype) {
        if (!this.online) {
            return;
        }
        try {
            if (type == 0) {
                this.dl.configTC(tcMap.get(tcTypes.substring(subtype, subtype + 1)), new int[]{chan});
            } else if (type == 1) {
                this.dl.configVolts(Math.pow(10.0, subtype >> 16) * (double)(subtype & 0xFFFF), new int[]{chan});
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected void readChannelGroup() {
        if (!this.reallyOnline) {
            return;
        }
        try {
            if (!this.hwChanSet.isEmpty()) {
                this.chanValues = this.dl.readData();
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading data logger: " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        if (this.reallyOnline) {
            try {
                return this.chanValues[this.hwChanMap.get(hwChan)];
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading data logger: " + e));
                this.setOnline(false);
            }
        }
        return super.readChannel(hwChan, type);
    }

    static {
        cTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
        cTypeMap.put("FTDI", DriverConstants.ConnType.FTDI);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("VOLT", 1);
        tcMap = new HashMap<String, DL34970.TcType>();
        tcMap.put("J", DL34970.TcType.J);
        tcMap.put("K", DL34970.TcType.K);
        tcMap.put("T", DL34970.TcType.T);
        tcMap.put("E", DL34970.TcType.E);
        tcMap.put("R", DL34970.TcType.R);
        tcMap.put("S", DL34970.TcType.S);
        tcMap.put("B", DL34970.TcType.B);
        tcMap.put("N", DL34970.TcType.N);
        LOG = Logger.getLogger((String)DL34970Device.class.getName());
    }
}

