import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.refrig.ThermalMain
import org.lsst.ccs.subsystem.refrig.TempControl
import org.lsst.ccs.subsystem.refrig.ProtPlutoDevice
import org.lsst.ccs.subsystem.refrig.HeaterPsDevice
import org.lsst.ccs.subsystem.refrig.DcsDevice
import org.lsst.ccs.subsystem.refrig.BKXLNDevice
import org.lsst.ccs.subsystem.common.devices.Maq20Device
import org.lsst.ccs.monitor.Channel

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["thermal"]

builder.main (ThermalMain, nodeTags: taskConfig, coldTempCtrl: "ColdTempCtrl", cryoTempCtrl: "CryoTempCtrl",
              auxPowerNames: ["AuxPowerMY", "AuxPowerPY", "AuxPowerC"] as String[],  // Must be in this order
              coldTempNames: ["Cold_Temp/CLP-RTD-00", "Cold_Temp/CLP-RTD-02", "Cold_Temp/CLP-RTD-03",
                              "Cold_Temp/CLP-RTD-05", "Cold_Temp/CLP-RTD-50", "Cold_Temp/CLP-RTD-52",
                              "Cold_Temp/CLP-RTD-53", "Cold_Temp/CLP-RTD-55"]) {

    ColdTempCtrl (TempControl, gain: 5.0, timeConst: 1000.0, smoothTime: 120.0,
                  maxOutput: 250.0, awGain: 4.0, basePower: 0.0, tolerance: 0.05,
                  updateTime: 30000, powerDevc: "TrimPower", powerChan: HeaterPsDevice.CHANSET_COLD,
                  tempChans: ["Cold_Temp/CLP-RTD-03"] as String[])

    CryoTempCtrl (TempControl, gain: 25.0, timeConst: 1000.0, smoothTime: 120.0,
                  maxOutput: 250.0, awGain: 4.0, basePower: 0.0, tolerance: 0.05,
                  updateTime: 30000, powerDevc: "TrimPower", powerChan: HeaterPsDevice.CHANSET_CRYO,
                  tempChans: ["Cryo_Temp/CYP-RTD-12", "Cryo_Temp/CYP-RTD-13", "Cryo_Temp/CYP-RTD-14",
                              "Cryo_Temp/CYP-RTD-41", "Cryo_Temp/CYP-RTD-42", "Cryo_Temp/CYP-RTD-43"] as String[])

    Rtds       (Maq20Device, node: "192.168.1.128",
                modules: ["RTD:0121348-10",             // CRY-UTT-SCD-00
                          "RTD:0122975-01",             // CRY-UTT-SCD-01
                          "RTD:0119418-07",             // CRY-UTT-SCD-02
                          "RTD:0121348-02",             // CRY-UTT-SCD-03
                          "RTD:0114836-04",             // CRY-UTT-SCD-04
                          "RTD:0121348-04",             // CRY-UTT-SCD-05
                          "RTD:0121348-07",             // RFG-UTT-SCD-01
                          "RTD:0121348-06",             // RFG-UTT-SCD-00
                          "RTD:0121348-09",             // RFG-UTT-SCD-02
                          "RTD:0121348-08",             // RFG-UTT-SCD-03
                          "RTD:0122975-02",             // RFG-UTT-SCD-05
                          "RTD:0119418-08",             // RFG-UTT-SCD-04
                          "RTD:0121348-01",             // RFG-UTT-SCD-06                                     //    "
                          "IS:0104377-14",              // RFG-UTT-ISN-00
                          "IS:0104377-15"] as String[]) // RFG-UTT-ISN-01
                         

    ProtRtds  (ProtPlutoDevice, node: "192.168.1.132")

    TrimPower (HeaterPsDevice, node: 83)

    AuxPowerMY (DcsDevice, connType: "SERIAL", devcId: "/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104D6TG-if00-port0",
                maxCurrent: [6.0] as double[])

    AuxPowerPY (DcsDevice, connType: "SERIAL", devcId: "/dev/serial/by-id/usb-FTDI_FT232R_USB_UART_A104D6TI-if00-port0",
                maxCurrent: [6.0] as double[])

    AuxPowerC (BKXLNDevice, connType: "SERIAL",
               devcId: "/dev/serial/by-id/usb-Silicon_Labs_CP2102_USB_to_UART_Bridge_Controller_275G17131-if00-port0",
               maxCurrent: [30.0] as double[])

    "Cold_Temp/CLP-RTD-00" (Channel, description: "Cold Plate RTD 00", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:13", scale: 0.013125, offset: -215.5)

    "Cold_Temp/CLP-RTD-02" (Channel, description: "Cold Plate RTD 02", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "3", subtype: "R200")

    "Cold_Temp/CLP-RTD-03" (Channel, description: "Cold Plate RTD 03", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:12", scale: 0.013125, offset: -215.5)

    "Cold_Temp/CLP-RTD-05" (Channel, description: "Cold Plate RTD 05", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "3", subtype: "R200")

    "Cold_Temp/CLP-RTD-50" (Channel, description: "Cold Plate RTD 50", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "0", subtype: "R200")

    "Cold_Temp/CLP-RTD-52" (Channel, description: "Cold Plate RTD 52", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:11", scale: 0.013125, offset: -215.5)

    "Cold_Temp/CLP-RTD-53" (Channel, description: "Cold Plate RTD 53", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "0", subtype: "R200")

    "Cold_Temp/CLP-RTD-55" (Channel, description: "Cold Plate RTD 55", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:10", scale: 0.013125, offset: -215.5)

    "Cryo_Temp/CYP-RTD-02" (Channel, description: "Cryo Plate RTD 02", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "4", subtype: "R200")

    "Cryo_Temp/CYP-RTD-03" (Channel, description: "Cryo Plate RTD 03", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "4", subtype: "R200")

    "Cryo_Temp/CYP-RTD-04" (Channel, description: "Cryo Plate RTD 04", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 4, type: "3", subtype: "R200")

    "Cryo_Temp/CYP-RTD-12" (Channel, description: "Cryo Plate RTD 12", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:23", scale: 0.013125, offset: -215.5)

    "Cryo_Temp/CYP-RTD-13" (Channel, description: "Cryo Plate RTD 13", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 5, type: "3", subtype: "R200")

    "Cryo_Temp/CYP-RTD-14" (Channel, description: "Cryo Plate RTD 14", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:22", scale: 0.013125, offset: -215.5)

    "Cryo_Temp/CYP-RTD-21" (Channel, description: "Cryo Plate RTD 21", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "4", subtype: "R200")

    "Cryo_Temp/CYP-RTD-22" (Channel, description: "Cryo Plate RTD 22", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "4", subtype: "R200")

    "Cryo_Temp/CYP-RTD-24" (Channel, description: "Cryo Plate RTD 24", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "3", subtype: "R200")

    "Cryo_Temp/CYP-RTD-25" (Channel, description: "Cryo Plate RTD 25", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "3", subtype: "R200")

    "Cryo_Temp/CYP-RTD-30" (Channel, description: "Cryo Plate RTD 30", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "1", subtype: "R200")

    "Cryo_Temp/CYP-RTD-31" (Channel, description: "Cryo Plate RTD 31", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "1", subtype: "R200")

    "Cryo_Temp/CYP-RTD-33" (Channel, description: "Cryo Plate RTD 33", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "0", subtype: "R200")

    "Cryo_Temp/CYP-RTD-34" (Channel, description: "Cryo Plate RTD 34", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "0", subtype: "R200")

    "Cryo_Temp/CYP-RTD-41" (Channel, description: "Cryo Plate RTD 41", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:21", scale: 0.013125, offset: -215.5)

    "Cryo_Temp/CYP-RTD-42" (Channel, description: "Cryo Plate RTD 42", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 5, type: "0", subtype: "R200")

    "Cryo_Temp/CYP-RTD-43" (Channel, description: "Cryo Plate RTD 43", units: "\u00b0C",
                            devcName: "ProtRtds", hwChan: 0, type: "ADDREG:20", scale: 0.013125, offset: -215.5)

    "Cryo_Temp/CYP-RTD-51" (Channel, description: "Cryo Plate RTD 51", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "1", subtype: "R200")

    "Cryo_Temp/CYP-RTD-52" (Channel, description: "Cryo Plate RTD 52", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "1", subtype: "R200")

    "Cryo_Temp/CYP-RTD-53" (Channel, description: "Cryo Plate RTD 53", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 4, type: "0", subtype: "R200")

    "Grid_Temp/GRD-RTD-01" (Channel, description: "Grid RTD 01", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 4, type: "1", subtype: "R200")

    "Grid_Temp/GRD-RTD-02" (Channel, description: "Grid RTD 02", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 5, type: "1", subtype: "R200")

    "Grid_Temp/GRD-RTD-03" (Channel, description: "Grid RTD 03", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 4, type: "4", subtype: "R200")

    "Grid_Temp/GRD-RTD-04" (Channel, description: "Grid RTD 04", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 5, type: "4", subtype: "R200")

    "Grid_Temp/GFX-RTD-01" (Channel, description: "Grid Flexure RTD 01", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "2", subtype: "R200")

    "Grid_Temp/GFX-RTD-02" (Channel, description: "Grid Flexure RTD 02", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "2", subtype: "R200")

    "Grid_Temp/GFX-RTD-03" (Channel, description: "Grid Flexure RTD 03", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 0, type: "5", subtype: "R200")

    "Grid_Temp/GFX-RTD-04" (Channel, description: "Grid Flexure RTD 04", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 1, type: "5", subtype: "R200")

    "Grid_Temp/CFX-RTD-01" (Channel, description: "Cryo Flexure RTD 01", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "2", subtype: "R200")

    "Grid_Temp/CFX-RTD-02" (Channel, description: "Cryo Flexure RTD 02", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "2", subtype: "R200")

    "Grid_Temp/CFX-RTD-03" (Channel, description: "Cryo Flexure RTD 03", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 2, type: "5", subtype: "R200")

    "Grid_Temp/CFX-RTD-04" (Channel, description: "Cryo Flexure RTD 04", units: "\u00b0C",
                            devcName: "Rtds", hwChan: 3, type: "5", subtype: "R200")

    "HX_Temp/Cold1PreExpnTmp" (Channel, description: "Cold Circ 1 Pre Expansion Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 0, type: "12", subtype: "R200")

    "HX_Temp/Cold1EvapExitTmp" (Channel, description: "Cold Circ 1 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 1, type: "12", subtype: "R200")

    "HX_Temp/Cold1HexRtrnTmp" (Channel, description: "Cold Circ 1 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 2, type: "12", subtype: "R200")

    "HX_Temp/Cold2PreExpnTmp" (Channel, description: "Cold Circ 2 Pre Expansion Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 3, type: "12", subtype: "R200")

    "HX_Temp/Cold2EvapExitTmp" (Channel, description: "Cold Circ 2 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "12", subtype: "R200")

    "HX_Temp/Cold2HexRtrnTmp" (Channel, description: "Cold Circ 2 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "12", subtype: "R200")

    "HX_Temp/Cryo1C3ExitTmp" (Channel, description: "Cryo Circ 1 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "6", subtype: "R200")

    "HX_Temp/Cryo1PreC3Tmp" (Channel, description: "Cryo Circ 1 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "6", subtype: "R200")

    "HX_Temp/Cryo1PreC4Tmp" (Channel, description: "Cryo Circ 1 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "6", subtype: "R200")

    "HX_Temp/Cryo1C4ExitTmp" (Channel, description: "Cryo Circ 1 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "6", subtype: "R200")

    "HX_Temp/Cryo1EvapExitTmp" (Channel, description: "Cryo Circ 1 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "6", subtype: "R200")

    "HX_Temp/Cryo1HexRtrnTmp" (Channel, description: "Cryo Circ 1 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "6", subtype: "R200")

    "HX_Temp/Cryo2C3ExitTmp" (Channel, description: "Cryo Circ 2 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "7", subtype: "R200")

    "HX_Temp/Cryo2PreC3Tmp" (Channel, description: "Cryo Circ 2 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "7", subtype: "R200")

    "HX_Temp/Cryo2PreC4Tmp" (Channel, description: "Cryo Circ 2 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "7", subtype: "R200")

    "HX_Temp/Cryo2C4ExitTmp" (Channel, description: "Cryo Circ 2 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "7", subtype: "R200")

    "HX_Temp/Cryo2EvapExitTmp" (Channel, description: "Cryo Circ 2 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "7", subtype: "R200")

    "HX_Temp/Cryo2HexRtrnTmp" (Channel, description: "Cryo Circ 2 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "7", subtype: "R200")

    "HX_Temp/Cryo3C3ExitTmp" (Channel, description: "Cryo Circ 3 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "8", subtype: "R200")

    "HX_Temp/Cryo3PreC3Tmp" (Channel, description: "Cryo Circ 3 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "8", subtype: "R200")

    "HX_Temp/Cryo3PreC4Tmp" (Channel, description: "Cryo Circ 3 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "8", subtype: "R200")

    "HX_Temp/Cryo3C4ExitTmp" (Channel, description: "Cryo Circ 3 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "8", subtype: "R200")

    "HX_Temp/Cryo3EvapExitTmp" (Channel, description: "Cryo Circ 3 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "8", subtype: "R200")

    "HX_Temp/Cryo3HexRtrnTmp" (Channel, description: "Cryo Circ 3 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "8", subtype: "R200")

    "HX_Temp/Cryo4C3ExitTmp" (Channel, description: "Cryo Circ 4 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "9", subtype: "R200")

    "HX_Temp/Cryo4PreC3Tmp" (Channel, description: "Cryo Circ 4 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "9", subtype: "R200")

    "HX_Temp/Cryo4PreC4Tmp" (Channel, description: "Cryo Circ 4 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "9", subtype: "R200")

    "HX_Temp/Cryo4C4ExitTmp" (Channel, description: "Cryo Circ 4 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "9", subtype: "R200")

    "HX_Temp/Cryo4EvapExitTmp" (Channel, description: "Cryo Circ 4 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "9", subtype: "R200")

    "HX_Temp/Cryo4HexRtrnTmp" (Channel, description: "Cryo Circ 4 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "9", subtype: "R200")

    "HX_Temp/Cryo5C3ExitTmp" (Channel, description: "Cryo Circ 5 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "10", subtype: "R200")

    "HX_Temp/Cryo5PreC3Tmp" (Channel, description: "Cryo Circ 5 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "10", subtype: "R200")

    "HX_Temp/Cryo5PreC4Tmp" (Channel, description: "Cryo Circ 5 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "10", subtype: "R200")

    "HX_Temp/Cryo5C4ExitTmp" (Channel, description: "Cryo Circ 5 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "10", subtype: "R200")

    "HX_Temp/Cryo5EvapExitTmp" (Channel, description: "Cryo Circ 5 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "10", subtype: "R200")

    "HX_Temp/Cryo5HexRtrnTmp" (Channel, description: "Cryo Circ 5 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "10", subtype: "R200")

    "HX_Temp/Cryo6C3ExitTmp" (Channel, description: "Cryo Circ 6 C3 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 0, type: "11", subtype: "R200")

    "HX_Temp/Cryo6PreC3Tmp" (Channel, description: "Cryo Circ 6 Pre C3 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 1, type: "11", subtype: "R200")

    "HX_Temp/Cryo6PreC4Tmp" (Channel, description: "Cryo Circ 6 Pre C4 Temp", units: "\u00b0C",
                             devcName: "Rtds", hwChan: 2, type: "11", subtype: "R200")

    "HX_Temp/Cryo6C4ExitTmp" (Channel, description: "Cryo Circ 6 C4 Exit Temp", units: "\u00b0C",
                              devcName: "Rtds", hwChan: 3, type: "11", subtype: "R200")

    "HX_Temp/Cryo6EvapExitTmp" (Channel, description: "Cryo Circ 6 Evaporator Exit Temp", units: "\u00b0C",
                                devcName: "Rtds", hwChan: 4, type: "11", subtype: "R200")

    "HX_Temp/Cryo6HexRtrnTmp" (Channel, description: "Cryo Circ 6 HX Return Temp", units: "\u00b0C",
                               devcName: "Rtds", hwChan: 5, type: "11", subtype: "R200")

    "HX_Press/Cold1SupplyPrs" (Channel, description: "Cold Circ 1 Supply Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 2, type: "14", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cold1ReturnPrs" (Channel, description: "Cold Circ 1 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 3, type: "14", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cold2SupplyPrs" (Channel, description: "Cold Circ 2 Supply Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 4, type: "14", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cold2ReturnPrs" (Channel, description: "Cold Circ 2 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 5, type: "14", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo1VaporPrs" (Channel, description: "Cryo Circ 1 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 0, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo1LiquidPrs" (Channel, description: "Cryo Circ 1 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 1, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo1ReturnPrs" (Channel, description: "Cryo Circ 1 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 2, type: "13", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo2VaporPrs" (Channel, description: "Cryo Circ 2 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 3, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo2LiquidPrs" (Channel, description: "Cryo Circ 2 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 4, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo2ReturnPrs" (Channel, description: "Cryo Circ 2 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 5, type: "13", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo3VaporPrs" (Channel, description: "Cryo Circ 3 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 6, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo3LiquidPrs" (Channel, description: "Cryo Circ 3 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 7, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo3ReturnPrs" (Channel, description: "Cryo Circ 3 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 8, type: "13", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo4VaporPrs" (Channel, description: "Cryo Circ 4 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 9, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo4LiquidPrs" (Channel, description: "Cryo Circ 4 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 10, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo4ReturnPrs" (Channel, description: "Cryo Circ 4 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 11, type: "13", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo5VaporPrs" (Channel, description: "Cryo Circ 5 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 12, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo5LiquidPrs" (Channel, description: "Cryo Circ 5 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 13, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo5ReturnPrs" (Channel, description: "Cryo Circ 5 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 14, type: "13", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "HX_Press/Cryo6VaporPrs" (Channel, description: "Cryo Circ 6 Vapor Pressure", units: "Psia",
                              devcName: "Rtds", hwChan: 15, type: "13", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo6LiquidPrs" (Channel, description: "Cryo Circ 6 Liquid Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 0, type: "14", subtype: "MA4_20", offset: -187.5, scale: 46875.0)

    "HX_Press/Cryo6ReturnPrs" (Channel, description: "Cryo Circ 6 Return Pressure", units: "Psia",
                               devcName: "Rtds", hwChan: 1, type: "14", subtype: "MA4_20", offset: -125.0, scale: 31250.0)

    "Trim_Htrs/HtrPsTmp" (Channel, description: "Heater PS Temperature", units: "\u00b0C",
                           devcName: "TrimPower", hwChan: 0, type: "TEMP")

    "Trim_Htrs/HtrBulkTmp" (Channel, description: "Heater Bulk PS Temperature", units: "\u00b0C",
                             devcName: "TrimPower", hwChan: 0, type: "MAINTEMP")

    "Trim_Htrs/HtrBulk_V" (Channel, description: "Heater Bulk PS Voltage", units: "Volts",
                           devcName: "TrimPower", hwChan: 0, type: "MAINVOLTS")

    "Trim_Htrs/HtrBulk_I" (Channel, description: "Heater Bulk PS Current", units: "Amps",
                           devcName: "TrimPower", hwChan: 0, type: "MAINCURR")

    "Trim_Htrs/HtrBulk_P" (Channel, description: "Heater Bulk PS Power", units: "Watts",
                           devcName: "TrimPower", hwChan: 0, type: "MAINPOWER")

    "Trim_Htrs/CryoHtr0_V" (Channel, description: "Cryo Heater 0 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 0, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr0_I" (Channel, description: "Cryo Heater 0 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 0, type: "CURRENT")

    "Trim_Htrs/CryoHtr0_P" (Channel, description: "Cryo Heater 0 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 0, type: "POWER")

    "Trim_Htrs/CryoHtr1_V" (Channel, description: "Cryo Heater 1 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 1, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr1_I" (Channel, description: "Cryo Heater 1 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 1, type: "CURRENT")

    "Trim_Htrs/CryoHtr1_P" (Channel, description: "Cryo Heater 1 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 1, type: "POWER")

    "Trim_Htrs/CryoHtr2_V" (Channel, description: "Cryo Heater 2 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 2, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr2_I" (Channel, description: "Cryo Heater 2 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 2, type: "CURRENT")

    "Trim_Htrs/CryoHtr2_P" (Channel, description: "Cryo Heater 2 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 2, type: "POWER")

    "Trim_Htrs/CryoHtr3_V" (Channel, description: "Cryo Heater 3 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 3, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr3_I" (Channel, description: "Cryo Heater 3 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 3, type: "CURRENT")

    "Trim_Htrs/CryoHtr3_P" (Channel, description: "Cryo Heater 3 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 3, type: "POWER")

    "Trim_Htrs/CryoHtr4_V" (Channel, description: "Cryo Heater 4 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 4, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr4_I" (Channel, description: "Cryo Heater 4 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 4, type: "CURRENT")

    "Trim_Htrs/CryoHtr4_P" (Channel, description: "Cryo Heater 4 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 4, type: "POWER")

    "Trim_Htrs/CryoHtr5_V" (Channel, description: "Cryo Heater 5 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 5, type: "VOLTAGE")

    "Trim_Htrs/CryoHtr5_I" (Channel, description: "Cryo Heater 5 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 5, type: "CURRENT")

    "Trim_Htrs/CryoHtr5_P" (Channel, description: "Cryo Heater 5 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 5, type: "POWER")

    "Trim_Htrs/CryoTotal_P" (Channel, description: "Cryo Total Power", units: "Watts",
                             devcName: "TrimPower", hwChan: HeaterPsDevice.CHANSET_CRYO, type: "TOTALPOWER")

    "Trim_Htrs/ColdHtr0_V" (Channel, description: "Cold Heater 0 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 6, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr0_I" (Channel, description: "Cold Heater 0 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 6, type: "CURRENT")

    "Trim_Htrs/ColdHtr0_P" (Channel, description: "Cold Heater 0 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 6, type: "POWER")

    "Trim_Htrs/ColdHtr1_V" (Channel, description: "Cold Heater 1 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 7, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr1_I" (Channel, description: "Cold Heater 1 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 7, type: "CURRENT")

    "Trim_Htrs/ColdHtr1_P" (Channel, description: "Cold Heater 1 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 7, type: "POWER")

    "Trim_Htrs/ColdHtr2_V" (Channel, description: "Cold Heater 2 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 8, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr2_I" (Channel, description: "Cold Heater 2 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 8, type: "CURRENT")

    "Trim_Htrs/ColdHtr2_P" (Channel, description: "Cold Heater 2 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 8, type: "POWER")

    "Trim_Htrs/ColdHtr3_V" (Channel, description: "Cold Heater 3 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 9, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr3_I" (Channel, description: "Cold Heater 3 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 9, type: "CURRENT")

    "Trim_Htrs/ColdHtr3_P" (Channel, description: "Cold Heater 3 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 9, type: "POWER")

    "Trim_Htrs/ColdHtr4_V" (Channel, description: "Cold Heater 4 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 10, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr4_I" (Channel, description: "Cold Heater 4 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 10, type: "CURRENT")

    "Trim_Htrs/ColdHtr4_P" (Channel, description: "Cold Heater 4 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 10, type: "POWER")

    "Trim_Htrs/ColdHtr5_V" (Channel, description: "Cold Heater 5 Voltage", units: "Volts",
                            devcName: "TrimPower", hwChan: 11, type: "VOLTAGE")

    "Trim_Htrs/ColdHtr5_I" (Channel, description: "Cold Heater 5 Current", units: "Amps",
                            devcName: "TrimPower", hwChan: 11, type: "CURRENT")

    "Trim_Htrs/ColdHtr5_P" (Channel, description: "Cold Heater 5 Power", units: "Watts",
                            devcName: "TrimPower", hwChan: 11, type: "POWER")

    "Trim_Htrs/ColdTotal_P" (Channel, description: "Cold Total Power", units: "Watts",
                             devcName: "TrimPower", hwChan: HeaterPsDevice.CHANSET_COLD, type: "TOTALPOWER")

    "Aux_Htrs/-YHtr_V" (Channel, description: "-Y Aux Heater Voltage", units: "Volts",
                        devcName: "AuxPowerMY", hwChan: 0, type: "VOLTAGE")

    "Aux_Htrs/-YHtr_I" (Channel, description: "-Y Aux Heater Current", units: "Amps",
                        devcName: "AuxPowerMY", hwChan: 0, type: "CURRENT")

    "Aux_Htrs/-YHtr_P" (Channel, description: "-Y Aux Heater Power", units: "Watts",
                        devcName: "AuxPowerMY", hwChan: 0, type: "POWER")

    "Aux_Htrs/+YHtr_V" (Channel, description: "+Y Aux Heater Voltage", units: "Volts",
                        devcName: "AuxPowerPY", hwChan: 0, type: "VOLTAGE")

    "Aux_Htrs/+YHtr_I" (Channel, description: "+Y Aux Heater Current", units: "Amps",
                        devcName: "AuxPowerPY", hwChan: 0, type: "CURRENT")

    "Aux_Htrs/+YHtr_P" (Channel, description: "+Y Aux Heater Power", units: "Watts",
                        devcName: "AuxPowerPY", hwChan: 0, type: "POWER")

    "Aux_Htrs/CenterHtr_V" (Channel, description: "Center Aux Heater Voltage", units: "Volts",
                            devcName: "AuxPowerC", hwChan: 0, type: "VOLTAGE")

    "Aux_Htrs/CenterHtr_I" (Channel, description: "Center Aux Heater Current", units: "Amps",
                            devcName: "AuxPowerC", hwChan: 0, type: "CURRENT")

    "Aux_Htrs/CenterHtr_P" (Channel, description: "Center Aux Heater Power", units: "Watts",
                            devcName: "AuxPowerC", hwChan: 0, type: "POWER")

}
