/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.subsystem.refrig.constants.HeaterControlState;
import org.lsst.ccs.subsystem.refrig.constants.HeaterPowerState;

public class ThermalState
implements Serializable {
    public static final String KEY = "ThermalState";
    public static final int TRIM_HEATER_COLD = 0;
    public static final int TRIM_HEATER_CRYO = 1;
    public static final int NUM_TRIM_HEATERS = 2;
    public static final int COLD_SECTION_MINUS_Y = 0;
    public static final int COLD_SECTION_PLUS_Y = 1;
    public static final int NUM_COLD_SECTIONS = 2;
    public static final int AUX_HEATER_MINUS_Y = 0;
    public static final int AUX_HEATER_PLUS_Y = 1;
    public static final int AUX_HEATER_CENTER = 2;
    public static final int NUM_AUX_HEATERS = 3;
    private int tickMillis;
    private final HeaterPowerState[] trimHeaterState = new HeaterPowerState[2];
    private final HeaterControlState[] trimHeaterCtrlState = new HeaterControlState[2];
    private final double[] trimHeaterPower = new double[2];
    private final double[] plateTemperature = new double[2];
    private final boolean[] coldTrimEnabled = new boolean[2];
    private final HeaterPowerState[] auxHeaterState = new HeaterPowerState[3];
    private final double[] auxHeaterPower = new double[3];
    private static final long serialVersionUID = 6388078567612517895L;

    public ThermalState() {
        Arrays.fill((Object[])this.auxHeaterState, (Object)HeaterPowerState.OFFLINE);
        Arrays.fill((Object[])this.trimHeaterState, (Object)HeaterPowerState.OFFLINE);
        Arrays.fill((Object[])this.trimHeaterCtrlState, (Object)HeaterControlState.OFFLINE);
        Arrays.fill(this.coldTrimEnabled, true);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setTrimHeaterState(int heater, HeaterPowerState state) {
        this.trimHeaterState[heater] = state;
    }

    public HeaterPowerState getTrimHeaterState(int heater) {
        return this.trimHeaterState[heater];
    }

    public void setTrimHeaterCtrlState(int heater, HeaterControlState state) {
        this.trimHeaterCtrlState[heater] = state;
    }

    public HeaterControlState getTrimHeaterCtrlState(int heater) {
        return this.trimHeaterCtrlState[heater];
    }

    public void setTrimHeaterPower(int heater, double value) {
        this.trimHeaterPower[heater] = value;
    }

    public double getTrimHeaterPower(int heater) {
        return this.trimHeaterPower[heater];
    }

    public void setPlateTemperature(int heater, double value) {
        this.plateTemperature[heater] = value;
    }

    public double getPlateTemperature(int heater) {
        return this.plateTemperature[heater];
    }

    public void enableColdSection(int section, boolean value) {
        this.coldTrimEnabled[section] = value;
    }

    public boolean isColdSectionEnabled(int section) {
        return this.coldTrimEnabled[section];
    }

    public void setAuxHeaterState(int heater, HeaterPowerState state) {
        this.auxHeaterState[heater] = state;
    }

    public HeaterPowerState getAuxHeaterState(int heater) {
        return this.auxHeaterState[heater];
    }

    public void setAuxHeaterPower(int heater, double value) {
        this.auxHeaterPower[heater] = value;
    }

    public double getAuxHeaterPower(int heater) {
        return this.auxHeaterPower[heater];
    }
}

