/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;
import org.lsst.ccs.utilities.logging.Logger;

public class ThermalMain
implements HasLifecycle,
Monitor.AlarmHandler {
    public static final int ALARM_COLD_HEATER = 0;
    public static final int ALARM_CRYO_HEATER = 1;
    private static final int POWER_SET_INTVL = 5000;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, TempControl> tempControls = new HashMap<String, TempControl>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> allChannels = new HashMap<String, Channel>();
    private static final String REFRIG = "Refrig";
    private static final Logger LOG = Logger.getLogger((String)ThermalMain.class.getName());
    private String[] alarmDsabChans = new String[0];
    private String coldTempCtrl;
    private String cryoTempCtrl;
    private final List<Channel> alarmDsabChansL = new ArrayList<Channel>();
    private final Heater[] heaters = new Heater[2];
    private final ThermalState state = new ThermalState();

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("heater-power", () -> this.setHeaterPower()).withPeriod(Duration.ofMillis(5000L));
        this.pts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        TempControl ctrl;
        this.subsys.setAgentProperty("thermalType", ThermalMain.class.getCanonicalName());
        this.state.setTickMillis(this.getTickPeriod());
        for (String cName : this.alarmDsabChans) {
            Channel chan = this.allChannels.get(cName);
            if (chan == null) continue;
            this.alarmDsabChansL.add(chan);
        }
        if (this.alarmDsabChansL.size() != this.alarmDsabChans.length) {
            LOG.error((Object)"Some alarm disable channels are invalid");
        }
        if ((ctrl = this.tempControls.get(this.coldTempCtrl)) == null) {
            LOG.error((Object)"No coldplate temperature controller (or heater control) specified");
            this.state.setHeaterPowerState(0, 3);
            this.state.setHeaterControlState(0, 3);
        } else {
            this.heaters[0] = new Heater(ctrl, ctrl.getPowerDevice(), ctrl.getPowerChannel());
        }
        ctrl = this.tempControls.get(this.cryoTempCtrl);
        if (ctrl == null) {
            LOG.error((Object)"No cryoplate temperature controller (or heater control) specified");
            this.state.setHeaterPowerState(1, 3);
            this.state.setHeaterControlState(1, 3);
        } else {
            this.heaters[1] = new Heater(ctrl, ctrl.getPowerDevice(), ctrl.getPowerChannel());
        }
    }

    public void postStart() {
        LOG.info((Object)("Thermal control system (" + this.name + ") started"));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the thermal control state")
    public ThermalState getSystemState() {
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.state.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    public boolean processAlarm(int event, int parm, String cause, String name) {
        if (parm == 0 || parm == 1) {
            int heater;
            int n = heater = parm == 0 ? 0 : 1;
            if (event == 0) {
                if (this.state.getHeaterPowerState(heater) != 2) {
                    this.state.setHeaterPowerState(heater, 2);
                    this.setHeaterPowerSwitch(heater);
                    this.publishState();
                }
            } else if (event == 3 && this.state.getHeaterPowerState(heater) == 2) {
                this.state.setHeaterPowerState(heater, 0);
                this.publishState();
            }
        }
        return false;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int heater, int value) {
        int oldState = this.state.getHeaterPowerState(heater);
        if (oldState != 3) {
            int newState;
            int n = oldState == 2 ? oldState : (newState = value == 0 ? 0 : 1);
            if (newState != oldState) {
                this.state.setHeaterPowerState(heater, newState);
                this.setHeaterPowerSwitch(heater);
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater control state")
    public void setHeaterControl(int heater, int value) {
        int oldState = this.state.getHeaterControlState(heater);
        if (oldState != 3) {
            int newState;
            Heater htr = this.heaters[heater];
            int n = value == 0 ? 0 : (value > 0 ? 1 : (newState = htr != null ? 2 : 1));
            if (newState != oldState) {
                this.state.setHeaterControlState(heater, newState);
                if (newState == 2) {
                    htr.tempCtrl.setTemp(this.state.getPlateTemp(heater));
                    this.startTempControl(heater);
                } else {
                    this.stopTempControl(heater);
                    this.setHeaterPower(heater);
                }
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load trip enabled state")
    public void setAlarmDisabled(int value) {
        boolean disable = value != 0;
        this.state.setAlarmDisabled(disable);
        for (Channel chan : this.alarmDsabChansL) {
            chan.enableAlarm(false, !disable);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power set point")
    public void setHeaterPower(int heater, double value) {
        Heater htr = this.heaters[heater];
        if (htr != null) {
            this.state.setHeaterPower(heater, value);
            if (htr.startPower != null) {
                htr.startPower = value;
            }
            this.setHeaterPower(heater);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load temperature set point")
    public void setPlateTemp(int heater, double value) {
        Heater htr = this.heaters[heater];
        if (htr != null) {
            this.state.setPlateTemp(heater, value);
            htr.tempCtrl.setTemp(value);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        this.sce.saveChangesForCategoriesAs(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.sce.loadCategories(new String[]{"Refrig:" + name});
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ThermalState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void setHeaterPowerSwitch(int heater) {
        Heater htr = this.heaters[heater];
        if (htr != null) {
            boolean on;
            boolean bl = on = this.state.getHeaterPowerState(heater) == 1;
            if (on) {
                htr.powerDevc.enableOutput(htr.powerChan, true);
                if (this.state.getHeaterControlState(heater) == 2) {
                    this.startTempControl(heater);
                }
            } else {
                this.stopTempControl(heater);
                htr.powerDevc.enableOutput(htr.powerChan, false);
            }
        }
    }

    private void setHeaterPower() {
        this.setHeaterPower(0);
        this.setHeaterPower(1);
    }

    private void setHeaterPower(int heater) {
        Heater htr = this.heaters[heater];
        if (htr == null || !htr.powerDevc.isOnline()) {
            return;
        }
        if (this.state.getHeaterPowerState(heater) != 1) {
            return;
        }
        htr.powerDevc.enableOutput(htr.powerChan, this.state.getHeaterControlState(heater) != 0);
        if (this.state.getHeaterControlState(heater) == 1) {
            double loadPower = this.state.getHeaterPower(heater);
            htr.powerDevc.setPower(htr.powerChan, loadPower);
            htr.startPower = loadPower;
        }
    }

    private void startTempControl(int heater) {
        Heater htr = this.heaters[heater];
        if (htr != null) {
            if (htr.startPower == null) {
                htr.tempCtrl.restart();
            } else {
                htr.tempCtrl.start(htr.startPower);
                htr.startPower = null;
            }
        }
    }

    private void stopTempControl(int heater) {
        Heater htr = this.heaters[heater];
        if (htr != null) {
            htr.tempCtrl.stop();
        }
    }

    static class Heater {
        TempControl tempCtrl;
        PowerDevice powerDevc;
        int powerChan;
        Double startPower = 0.0;

        Heater(TempControl tempCtrl, PowerDevice powerDevc, int powerChan) {
            this.tempCtrl = tempCtrl;
            this.powerDevc = powerDevc;
            this.powerChan = powerChan;
        }
    }
}

