/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.Iterator;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.CompMaq20Device;
import org.lsst.ccs.subsystem.refrig.CompPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.CompState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.utilities.logging.Logger;

public class Compressor
implements HasLifecycle,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService as;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService ass;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompPlutoDevice plutoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private CompMaq20Device maq20Devc;
    private static final Logger LOG = Logger.getLogger((String)Compressor.class.getName());
    private final CompState state;
    private final SwitchDevice[] switchDevices;
    private final int[] switchChannels;
    private final int type;

    public Compressor(CompState state) {
        this.state = state;
        this.type = state.getType();
        this.switchDevices = new SwitchDevice[7];
        this.switchChannels = new int[7];
    }

    public void postInit() {
        if (this.plutoDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"plutoDevc", (String)"not specified");
        }
        if (this.maq20Devc == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maq20Devc", (String)"not specified");
        }
        if (this.type == 0) {
            this.switchDevices[0] = this.plutoDevc;
            this.switchChannels[0] = 0;
            this.switchDevices[2] = this.plutoDevc;
            this.switchChannels[2] = 1;
        } else {
            this.switchDevices[0] = this.plutoDevc;
            this.switchChannels[0] = 0;
            this.switchDevices[2] = this.plutoDevc;
            this.switchChannels[2] = 1;
            this.switchDevices[1] = this.plutoDevc;
            this.switchChannels[1] = 2;
            this.switchDevices[3] = this.maq20Devc;
            this.switchChannels[3] = 2;
            this.switchDevices[4] = this.maq20Devc;
            this.switchChannels[4] = 1;
            this.switchDevices[5] = this.maq20Devc;
            this.switchChannels[5] = 3;
            this.switchDevices[6] = this.maq20Devc;
            this.switchChannels[6] = 4;
        }
        this.state.setName(this.name);
        this.plutoDevc.setType(this.type);
        this.maq20Devc.setType(this.type);
    }

    public void setIndex(int index) {
        this.state.setIndex(index);
    }

    public int getIndex() {
        return this.state.getIndex();
    }

    @Command(type=Command.CommandType.ACTION, description="Set a compressor's switch state")
    public void setSwitchOn(@Argument(description="Switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws RefrigException {
        if (!this.state.getValidSwitches().contains(sw)) {
            throw new RefrigException("Invalid switch number: " + sw);
        }
        this.switchDevices[sw].setSwitchOn(this.switchChannels[sw], on);
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a compressor's latches")
    public void resetLatches() {
        this.plutoDevc.resetLatches();
    }

    public boolean updateState() {
        int cond;
        boolean changed = false;
        CompressorState compState = null;
        Iterator iterator = this.state.getValidSwitches().iterator();
        while (iterator.hasNext()) {
            int sw = (Integer)iterator.next();
            Boolean on = this.switchDevices[sw].isSwitchOn(this.switchChannels[sw]);
            SwitchState swState = on == null ? SwitchState.OFFLINE : (on != false ? SwitchState.ON : SwitchState.OFF);
            if (swState == this.state.getSwitchState(sw)) continue;
            this.state.setSwitchState(sw, swState);
            changed = true;
        }
        iterator = this.state.getValidLatches().iterator();
        while (iterator.hasNext()) {
            cond = (Integer)iterator.next();
            LatchState latchState = this.plutoDevc.getLatchState(cond);
            if (latchState == this.state.getLatchState(cond)) continue;
            this.state.setLatchState(cond, latchState);
            changed = true;
        }
        iterator = this.state.getValidConditions().iterator();
        while (iterator.hasNext()) {
            cond = (Integer)iterator.next();
            ConditionState condState = this.plutoDevc.getConditionState(cond);
            if (condState == ConditionState.OFF) {
                compState = CompressorState.OFFLINE;
            }
            if (condState == this.state.getConditionState(cond)) continue;
            this.state.setConditionState(cond, condState);
            changed = true;
        }
        if (compState == null) {
            CompressorState compressorState = this.state.getConditionState(3) == ConditionState.YES ? CompressorState.RUNNING : (this.state.getConditionState(2) == ConditionState.YES ? CompressorState.WAITING : (compState = this.state.getConditionState(11) == ConditionState.NO ? CompressorState.HW_DSAB : CompressorState.STOPPED));
        }
        if (compState != this.state.getCompressorState()) {
            this.state.setCompressorState(compState);
            changed = true;
        }
        return changed;
    }

    public CompState getState() {
        return this.state;
    }

    public boolean processAlarm(int event, int parm, String cause, String name) {
        switch (parm) {
            case 0: {
                if (event == 0 || event != 3) break;
                break;
            }
        }
        return false;
    }

    public static interface SwitchDevice {
        public void setSwitchOn(int var1, boolean var2) throws RefrigException;

        public Boolean isSwitchOn(int var1);
    }
}

