/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mcc;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestMccUsb {
    private static final Map<Integer, String> devNames = new HashMap<Integer, String>();
    private static final Map<Integer, String> itemNames;
    private static final Map<Integer, String> subiNames;
    private static final CmndProcess.Lookup stypNames;
    private static final CmndProcess.Lookup stypsNames;
    private static final CmndProcess.Lookup frateNames;
    private static final CmndProcess.Lookup fratsNames;
    private static final CmndProcess.Lookup tctypNames;
    private static final CmndProcess.Lookup gainNames;
    private static final CmndProcess.Lookup rangeNames;
    private static final CmndProcess.Lookup vconnNames;
    private static final CmndProcess.Lookup vconsNames;
    private static final CmndProcess.Lookup excitNames;
    private static final CmndProcess.Lookup tconnNames;
    private static final CmndProcess.Lookup tconsNames;
    private static final PrintStream out;
    private final MccUsb mcc = new MccUsb();
    private static final String[] caption;
    private static final boolean[] isValue;
    private static final boolean[] isExtra;
    private static final int[] loSubitem;
    private static final int[] hiSubitem;

    static {
        devNames.put(0, "tcai");
        devNames.put(1, "tc");
        devNames.put(2, "temp");
        itemNames = new HashMap<Integer, String>();
        itemNames.put(0, "adc0");
        itemNames.put(1, "adc1");
        itemNames.put(2, "adc2");
        itemNames.put(3, "adc3");
        subiNames = new HashMap<Integer, String>();
        subiNames.put(0, "senstype");
        subiNames.put(1, "conntype");
        subiNames.put(2, "filtrate");
        subiNames.put(3, "excitation");
        subiNames.put(4, "vref");
        subiNames.put(5, "ival0");
        subiNames.put(6, "ival1");
        subiNames.put(7, "ival2");
        subiNames.put(8, "vval0");
        subiNames.put(9, "vval1");
        subiNames.put(10, "vval2");
        subiNames.put(16, "tc0");
        subiNames.put(17, "tc1");
        subiNames.put(18, "gain0");
        subiNames.put(19, "gain1");
        subiNames.put(20, "coef00");
        subiNames.put(21, "coef01");
        subiNames.put(22, "coef10");
        subiNames.put(23, "coef11");
        subiNames.put(24, "coef20");
        subiNames.put(25, "coef21");
        subiNames.put(26, "coef30");
        subiNames.put(27, "coef31");
        subiNames.put(28, "vconn0");
        subiNames.put(29, "vconn1");
        stypNames = new CmndProcess.Lookup(6);
        stypNames.add("rtd", 0);
        stypNames.add("thermistor", 1);
        stypNames.add("thermocouple", 2);
        stypNames.add("semiconductor", 3);
        stypNames.add("disabled", 4);
        stypNames.add("voltage", 5);
        stypsNames = new CmndProcess.Lookup(6);
        stypsNames.add("rtd", 0);
        stypsNames.add("thermis", 1);
        stypsNames.add("thermoc", 2);
        stypsNames.add("semicon", 3);
        stypsNames.add("disabld", 4);
        stypsNames.add("voltage", 5);
        frateNames = new CmndProcess.Lookup(14);
        frateNames.add("500 Hz", 1);
        frateNames.add("250 Hz", 2);
        frateNames.add("125 Hz", 3);
        frateNames.add("62.5 Hz", 4);
        frateNames.add("50 Hz", 5);
        frateNames.add("39.2 Hz", 6);
        frateNames.add("33.3 Hz", 7);
        frateNames.add("19.6 Hz", 8);
        frateNames.add("16.7 Hz", 9);
        frateNames.add("12.5 Hz", 11);
        frateNames.add("10 Hz", 12);
        frateNames.add("8.33 Hz", 13);
        frateNames.add("6.25 Hz", 14);
        frateNames.add("4.17 Hz", 15);
        fratsNames = new CmndProcess.Lookup(14);
        fratsNames.add("500Hz", 1);
        fratsNames.add("250Hz", 2);
        fratsNames.add("125Hz", 3);
        fratsNames.add("62Hz", 4);
        fratsNames.add("50Hz", 5);
        fratsNames.add("39Hz", 6);
        fratsNames.add("33Hz", 7);
        fratsNames.add("19Hz", 8);
        fratsNames.add("16Hz", 9);
        fratsNames.add("12Hz", 11);
        fratsNames.add("10Hz", 12);
        fratsNames.add("8Hz", 13);
        fratsNames.add("6Hz", 14);
        fratsNames.add("4Hz", 15);
        tctypNames = new CmndProcess.Lookup(8);
        tctypNames.add("J", 0);
        tctypNames.add("K", 1);
        tctypNames.add("T", 2);
        tctypNames.add("E", 3);
        tctypNames.add("R", 4);
        tctypNames.add("S", 5);
        tctypNames.add("B", 6);
        tctypNames.add("N", 7);
        gainNames = new CmndProcess.Lookup(8);
        gainNames.add("1X", 0);
        gainNames.add("2X", 1);
        gainNames.add("4X", 2);
        gainNames.add("8X", 3);
        gainNames.add("16X", 4);
        gainNames.add("32X", 5);
        gainNames.add("64X", 6);
        gainNames.add("128X", 7);
        rangeNames = new CmndProcess.Lookup(4);
        rangeNames.add("10V", 2);
        rangeNames.add("5V", 3);
        rangeNames.add("2.5V", 4);
        rangeNames.add("1.25V", 5);
        vconnNames = new CmndProcess.Lookup(4);
        vconnNames.add("differential", 0);
        vconnNames.add("single-ended", 1);
        vconnNames.add("grounded", 2);
        vconnNames.add("calibration", 3);
        vconsNames = new CmndProcess.Lookup(4);
        vconsNames.add("differ", 0);
        vconsNames.add("snglend", 1);
        vconsNames.add("ground", 2);
        vconsNames.add("calib", 3);
        excitNames = new CmndProcess.Lookup(3);
        excitNames.add("off", 0);
        excitNames.add("10 uA", 1);
        excitNames.add("210 uA", 2);
        tconnNames = new CmndProcess.Lookup(4);
        tconnNames.add("2-wire, 1-sensor", 0);
        tconnNames.add("2-wire, 2-sensor", 1);
        tconnNames.add("3-wire", 2);
        tconnNames.add("4-wire", 3);
        tconsNames = new CmndProcess.Lookup(4);
        tconsNames.add("2-wire1", 0);
        tconsNames.add("2-wire2", 1);
        tconsNames.add("3-wire", 2);
        tconsNames.add("4-wire", 3);
        out = System.out;
        caption = new String[]{"Sensor type", "Therm conn", "Excitation", "Filter rate", "TC type", "Gain", "Voltage conn", "Refc voltage", "I value 0", "I value 1", "I value 2", "V value 0", "V value 1", "V value 2", "Coeff 0", "Coeff 1", "Coeff 2", "Coeff 3"};
        boolean[] blArray = new boolean[18];
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        isValue = blArray;
        boolean[] blArray2 = new boolean[18];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        blArray2[15] = true;
        blArray2[16] = true;
        blArray2[17] = true;
        isExtra = blArray2;
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 16;
        nArray[5] = 18;
        nArray[6] = 28;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray[11] = 8;
        nArray[12] = 9;
        nArray[13] = 10;
        nArray[14] = 20;
        nArray[15] = 22;
        nArray[16] = 24;
        nArray[17] = 26;
        loSubitem = nArray;
        int[] nArray2 = new int[18];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 17;
        nArray2[5] = 19;
        nArray2[6] = 29;
        nArray2[7] = 4;
        nArray2[8] = 5;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 8;
        nArray2[12] = 9;
        nArray2[13] = 10;
        nArray2[14] = 21;
        nArray2[15] = 23;
        nArray2[16] = 25;
        nArray2[17] = 27;
        hiSubitem = nArray2;
    }

    @Command(name="open", description="Open a connection")
    public void open(@Argument(name="name", description="The MCC device name") DevName name, @Argument(name="serial", description="The USB serial number") String serial, @Argument(name="force", description="Force the interface claim") boolean force) throws DriverException {
        if (serial.length() == 0) {
            serial = null;
        }
        this.mcc.open(name.getValue(), serial, force);
    }

    @Command(name="open", description="Open a connection & force the claim")
    public void open(@Argument(name="name", description="The MCC device name") DevName name, @Argument(name="serial", description="The USB serial number") String serial) throws DriverException {
        if (serial.length() == 0) {
            serial = null;
        }
        this.mcc.open(name.getValue(), serial, true);
    }

    @Command(name="open", description="Open a connection & force the claim")
    public void open(@Argument(name="name", description="The MCC device name") DevName name) throws DriverException {
        this.mcc.open(name.getValue(), null, true);
    }

    @Command(name="close", description="Close a connection")
    public void close() throws DriverException {
        this.mcc.close();
    }

    @Command(name="diocfg", description="Configure the DIO port")
    public void dioCfg(@Argument(name="value", description="The value: 0 = out; ~0 = in") int value) throws DriverException {
        this.mcc.dioConfig(value);
    }

    @Command(name="diocfgbit", description="Configure one DIO line")
    public void dioCfgBit(@Argument(name="bitnum", description="The line to configure") int bitnum, @Argument(name="value", description="The value: 0 = out; ~0 = in") int value) throws DriverException {
        this.mcc.dioConfigBit(bitnum, value);
    }

    @Command(name="dioin", description="Read the DIO port")
    public void dioIn() throws DriverException {
        out.format("Value = 0x%02x\n", this.mcc.dioIn());
    }

    @Command(name="dioinbit", description="Read a DIO line")
    public void dioInBit(@Argument(name="bitnum", description="The line to read") int bitnum) throws DriverException {
        out.println("Value = " + this.mcc.dioInBit(bitnum));
    }

    @Command(name="dioout", description="Write to the DIO port")
    public void dioOut(@Argument(name="value", description="The value to write") int value) throws DriverException {
        this.mcc.dioOut(value);
    }

    @Command(name="diooutbit", description="Write a DIO line")
    public void dioOutBit(@Argument(name="bitnum", description="The line to write") int bitnum, @Argument(name="value", description="The value to write") int value) throws DriverException {
        this.mcc.dioOutBit(bitnum, value);
    }

    @Command(name="adin", description="Read an ADC channel")
    public void adIn(@Argument(name="chan", description="The channel to read") int chan, @Argument(name="units", description="The units for the value") AdUnits units) throws DriverException {
        out.println("Value = " + this.mcc.adcIn(chan, units.getValue()));
    }

    @Command(name="adin", description="Read an ADC channel")
    public void adIn(@Argument(name="chan", description="The channel to read") int chan) throws DriverException {
        this.adIn(chan, AdUnits.CONV);
    }

    @Command(name="adscan", description="Scan ADC channels")
    public void adScan(@Argument(name="fchan", description="The first channel to read") int fChan, @Argument(name="lchan", description="The last channel to read") int lChan, @Argument(name="units", description="The units for the values") AdUnits units) throws DriverException {
        float[] value = new float[8];
        int count = this.mcc.adcScan(fChan, lChan, units.getValue(), value);
        if (count <= 0) {
            return;
        }
        out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < count) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                out.print("\n        ");
                posn = 8;
            }
            out.print(sValue);
            ++j;
        }
        out.println();
    }

    @Command(name="adscan", description="Scan ADC channels")
    public void adScan(@Argument(name="fchan", description="The first channel to read") int fChan, @Argument(name="lchan", description="The last channel to read") int lChan) throws DriverException {
        this.adScan(fChan, lChan, AdUnits.CONV);
    }

    @Command(name="cntrinit", description="Initialize the counter")
    public void cntrinit() throws DriverException {
        this.mcc.cntrInit();
    }

    @Command(name="cntrread", description="Read the counter")
    public void cntrread() throws DriverException {
        out.println("Value = " + this.mcc.cntrRead());
    }

    @Command(name="blink", description="Blink the LED")
    public void blink() throws DriverException {
        this.mcc.blink();
    }

    @Command(name="reset", description="Reset the device")
    public void reset() throws DriverException {
        this.mcc.reset();
    }

    @Command(name="status", description="Show the calibration status")
    public void status() throws DriverException {
        out.format("Value = 0x%02x\n", this.mcc.getStatus());
    }

    @Command(name="itemset", description="Display set configuration help")
    public void itemSet(@Argument(name="item", description="The item name") ItemName itemE, @Argument(name="subitem", description="The subitem name") SubiName subitemE) throws DriverException {
        itemE.ordinal();
        int subItem = subitemE.getValue();
        if (subItem == 0) {
            this.showNames("sensor type", stypNames);
        } else if (subItem == 1) {
            this.showNames("thermal connection type", tconsNames);
        } else if (subItem == 2) {
            this.showNames("filter rate", fratsNames);
        } else if (subItem == 3) {
            this.showNames("excitation", excitNames);
        } else if (subItem == 16 || subItem == 17) {
            this.showNames("thermocouple type", tctypNames);
        } else if (subItem == 18 || subItem == 19) {
            this.showNames("gain", gainNames);
        } else if (subItem == 28 || subItem == 29) {
            this.showNames("voltage connection type", vconnNames);
        } else {
            out.println("Missing value argument");
        }
    }

    @Command(name="itemset", description="Set a configuration item")
    public void itemSet(@Argument(name="item", description="The item name") ItemName itemE, @Argument(name="subitem", description="The subitem name") SubiName subitemE, @Argument(name="value", description="The value to set") String sValue) throws DriverException {
        int item = itemE.ordinal();
        int subItem = subitemE.getValue();
        if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
            try {
                this.mcc.setItem(item, subItem, Float.valueOf(sValue).floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                out.println("Invalid floating point number");
            }
        } else {
            try {
                int iValue = subItem == 0 ? this.encode(stypNames, sValue) : (subItem == 1 ? this.encode(tconsNames, sValue) : (subItem == 2 ? this.encode(fratsNames, sValue) : (subItem == 3 ? this.encode(excitNames, sValue) : (subItem == 16 || subItem == 17 ? this.encode(tctypNames, sValue) : (subItem == 18 || subItem == 19 ? this.encode(gainNames, sValue) : (subItem == 28 || subItem == 29 ? this.encode(vconnNames, sValue) : Integer.decode(sValue).intValue()))))));
                this.mcc.setItem(item, subItem, iValue);
            }
            catch (NumberFormatException numberFormatException) {
                out.println("Invalid keyword or integer");
            }
        }
    }

    @Command(name="itemshow", description="Show a configuration item")
    public void itemShow(@Argument(name="item", description="The item name") ItemName itemE, @Argument(name="subitem", description="The subitem name") SubiName subitemE) throws DriverException {
        int item = itemE.ordinal();
        int subItem = subitemE.getValue();
        float value = this.mcc.getItem(item, subItem);
        if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
            out.println("Value = " + value);
        } else {
            int iValue = (int)value;
            if (subItem == 0) {
                out.format("Value = %s (%s)\n", iValue, stypNames.decode(iValue));
            } else if (subItem == 1) {
                out.format("Value = %s (%s)\n", iValue, tconnNames.decode(iValue));
            } else if (subItem == 2) {
                out.format("Value = %s (%s)\n", iValue, frateNames.decode(iValue));
            } else if (subItem == 3) {
                out.format("Value = %s (%s)\n", iValue, excitNames.decode(iValue));
            } else if (subItem == 16 || subItem == 17) {
                out.format("Value = %s (%s)\n", iValue, tctypNames.decode(iValue));
            } else if (subItem == 18 || subItem == 19) {
                out.format("Value = %s (%s)\n", iValue, gainNames.decode(iValue));
            } else if (subItem == 28 || subItem == 29) {
                out.format("Value = %s (%s)\n", iValue, vconnNames.decode(iValue));
            } else {
                out.println("Value = " + iValue);
            }
        }
    }

    @Command(name="alarmset", description="Set an alarm configuration")
    public void alarmSet(@Argument(name="alarm", description="The alarm number") int alarm, @Argument(name="ioptns", description="The input options") int iOptns, @Argument(name="ooptns", description="The output options") int oOptns, @Argument(name="value1", description="The first alarm value") double value1, @Argument(name="value2", description="The second alarm value") double value2) throws DriverException {
        this.mcc.configAlarm(alarm, iOptns, oOptns, (float)value1, (float)value2);
    }

    @Command(name="alarmshow", description="Show an alarm configuration")
    public void alarmShow(@Argument(name="alarm", description="The alarm number") int alarm) throws DriverException {
        int[] optns = new int[2];
        float[] values = new float[]{0.0f, 0.0f};
        this.mcc.getAlarmConfig(alarm, optns, values);
        out.format("InOptns = 0x%02x, OutOptns = 0x%02x, Value1 = %s, Value2 = %s\n", optns[0], optns[1], Float.valueOf(values[0]), Float.valueOf(values[1]));
    }

    @Command(name="showdev", description="Show the name of the open device")
    public void showDev() throws DriverException {
        int devId = this.mcc.getDevId();
        if (devId < 0) {
            out.println("No device open");
        } else {
            out.format("Device = %s\n", devNames.get(devId));
        }
    }

    @Command(name="showchan", description="Show channel configuration")
    public void showChan(@Argument(name="channel", description="The channel number") int chan, @Argument(name="type", description="Display type (brief or full)") DispType type) throws DriverException {
        this.showChannel(chan, type.getValue());
    }

    @Command(name="showchan", description="Show channel configuration")
    public void showChan(@Argument(name="type", description="Display type (brief or full)") DispType type) throws DriverException {
        this.showChannel(-1, type.getValue());
    }

    @Command(name="showchan", description="Show channel configuration")
    public void showChan() throws DriverException {
        this.showChannel(-1, false);
    }

    @Command(name="showburn", description="Show and reset the burnout status")
    public void showBurn(@Argument(name="mask", description="The mask of channels to not reset") int mask) throws DriverException {
        out.format("Value = 0x%02x\n", this.mcc.getBurnout(mask));
    }

    @Command(name="showcal", description="Show the number of calibration steps")
    public void showCal() throws DriverException {
        int[] steps = new int[2];
        this.mcc.calSteps(steps);
        out.format("Calibration steps: temp = %s, voltage = %s\n", steps[0], steps[1]);
    }

    @Command(name="calcfg", description="Configure a calibration")
    public void calCfg(@Argument(name="gain", description="The gain selector") int gain, @Argument(name="polarity", description="The polarity (positive or negative)") CalPol polar, @Argument(name="path", description="The path (high or low)") CalPath path) throws DriverException {
        this.mcc.calConfig(gain, polar.ordinal(), path.ordinal());
    }

    @Command(name="calibrate", description="Perform a calibration")
    public void calibrate(@Argument(name="type", description="The type (temp, voltage or abort)") CalType type) throws DriverException {
        this.mcc.calibrate(type.ordinal());
    }

    private void showChannel(int chan, boolean all) throws DriverException {
        int first = chan < 0 ? 0 : chan & 7;
        int last = chan < 0 ? 7 : chan & 7;
        out.print("              ");
        int j = first;
        while (j <= last) {
            out.format("   Ch %s ", j);
            ++j;
        }
        out.println();
        out.print("              ");
        j = first;
        while (j <= last) {
            out.print(" -------");
            ++j;
        }
        out.println();
        int k = 0;
        while (k < caption.length) {
            if (!isExtra[k] || all) {
                out.format("%-12s: ", caption[k]);
                int highSub = hiSubitem[k];
                int lowSub = loSubitem[k];
                boolean isVal = isValue[k];
                int j2 = first;
                while (j2 <= last) {
                    float value = this.mcc.getItem(j2 >> 1, (j2 & 1) != 0 ? highSub : lowSub);
                    if (isVal) {
                        out.format(" %7.7s", Float.valueOf(value));
                    } else {
                        String desc = "huh?";
                        if (lowSub == 0) {
                            desc = stypsNames.decode((int)value);
                        } else if (lowSub == 1) {
                            desc = tconsNames.decode((int)value);
                        } else if (lowSub == 3) {
                            desc = excitNames.decode((int)value);
                        } else if (lowSub == 2) {
                            desc = frateNames.decode((int)value);
                        } else if (lowSub == 16) {
                            desc = tctypNames.decode((int)value);
                        } else if (lowSub == 18) {
                            desc = gainNames.decode((int)value);
                        } else if (lowSub == 28) {
                            desc = vconsNames.decode((int)value);
                        }
                        out.format(" %7s", desc);
                    }
                    ++j2;
                }
                out.println();
            }
            ++k;
        }
    }

    private void showNames(String desc, CmndProcess.Lookup lookup) {
        out.println("Possible " + desc + " names (values):");
        int j = 0;
        while (j < lookup.count()) {
            out.format("  %s (%s)\n", lookup.name(j), lookup.code(j));
            ++j;
        }
    }

    private int encode(CmndProcess.Lookup lookup, String token) throws NumberFormatException {
        int value;
        block2: {
            try {
                value = Integer.valueOf(token);
            }
            catch (NumberFormatException e) {
                value = lookup.encode(token, false);
                if (value >= 0) break block2;
                throw e;
            }
        }
        return value;
    }

    protected static enum AdUnits {
        CONV(0),
        RAW(1);

        int value;

        private AdUnits(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum CalPath {
        HIGH,
        LOW;

    }

    protected static enum CalPol {
        POSITIVE,
        NEGATIVE;

    }

    protected static enum CalType {
        TEMPERATURE,
        VOLTAGE,
        ABORT;

    }

    protected static enum DevName {
        TCAI(0),
        TC(1),
        TEMP(2);

        int value;

        private DevName(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum DispType {
        BRIEF(false),
        FULL(true);

        boolean value;

        private DispType(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }

    protected static enum ItemName {
        ADC0,
        ADC1,
        ADC2,
        ADC3;

    }

    protected static enum SubiName {
        SENSTYPE(0),
        CONNTYPE(1),
        FILTRATE(2),
        EXCITATION(3),
        VREF(4),
        IVAL0(5),
        IVAL1(6),
        IVAL2(7),
        VVAL0(8),
        VVAL1(9),
        VVAL2(10),
        TC0(16),
        TC1(17),
        GAIN0(18),
        GAIN1(19),
        COEF00(20),
        COEF01(21),
        COEF10(22),
        COEF11(23),
        COEF20(24),
        COEF21(25),
        COEF30(26),
        COEF31(27),
        VCONN0(28),
        VCONN1(29);

        int value;

        private SubiName(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

