/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class SimDevice
extends Device {
    private static final int MAIN_POWER_LINE = 0;
    private static final int LOAD_POWER_LINE = 1;
    private static final int N_DEV_CHANS = 64;
    private static final int N_DEV_LINES = 8;
    private static final double LOAD_POWER_FCTR = 6.667E-4;
    private String loadTmpChan;
    private String loadPwrChan;
    private static final Logger LOG = Logger.getLogger((String)SimDevice.class.getName());
    private final ChannelSim[] chanData = new ChannelSim[64];
    private static SimDevice sim;
    private static Power power;
    private ChannelSim loadTmpChanC;
    private ChannelSim loadPwrChanC;
    private double loadFract = 0.6;
    private final boolean[] lineOn = new boolean[8];
    private boolean loadAlwaysOn;

    public SimDevice(String loadTmpChan, String loadPwrChan) {
        this.loadTmpChan = loadTmpChan;
        this.loadPwrChan = loadPwrChan;
    }

    public SimDevice() {
    }

    protected void initDevice() {
        super.configure(this.mon);
        if (this.loadTmpChan == null || this.mon.getChannel(this.loadTmpChan) == null) {
            LOG.error((Object)"No valid load temperature channel defined");
        }
        if (power == null && (this.loadPwrChan == null || this.mon.getChannel(this.loadPwrChan) == null)) {
            LOG.error((Object)"No valid load power channel defined");
        }
        if (this.loadAlwaysOn) {
            this.lineOn[1] = true;
        }
        this.fullName = "Simulated devices";
        sim = this;
    }

    protected void initialize() {
        this.setOnline(true);
        this.initSensors();
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 64) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        String[] flds = subtype.split(":");
        try {
            ChannelSim chan;
            double onValue = Double.valueOf(flds[0]);
            double onTime = Double.valueOf(flds[1]);
            double offValue = Double.valueOf(flds[2]);
            double offTime = Double.valueOf(flds[3]);
            this.chanData[hwChan] = chan = new ChannelSim(hwChan, onValue, onTime, offValue, offTime);
            if (name.equals(this.loadTmpChan)) {
                this.loadTmpChanC = chan;
            } else if (name.equals(this.loadPwrChan)) {
                this.loadPwrChanC = chan;
            }
        }
        catch (Exception e) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"subtype", (Object)subtype);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int hwChan, int type, int subtype) {
        this.chanData[hwChan].initialize();
    }

    protected double readChannel(int hwChan, int type) {
        ChannelSim chan = this.chanData[hwChan];
        chan.read();
        return chan.value;
    }

    protected void checkHwLine(String name, int line) throws Exception {
        if (line < 0 || line >= 8) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"line number", (Object)line);
        }
    }

    protected void setHwLine(int line, boolean on) {
        this.lineOn[line] = on;
        System.out.print("Line states:");
        for (boolean lon : this.lineOn) {
            System.out.print(lon ? " on" : " off");
        }
        System.out.println();
        if (line == 0) {
            this.setMainPower();
        } else if (line == 1) {
            this.setLoadPower();
        }
    }

    protected Boolean isHwLineSet(int line) {
        return this.lineOn[line];
    }

    public void setLoadFract(double fract) {
        this.loadFract = fract;
        this.setLoadPower();
    }

    void setLoadTmpRate(double loadPower) {
        ChannelSim tc = this.loadTmpChanC;
        if (tc != null) {
            tc.powerOn();
            tc.rate += 6.667E-4 * loadPower;
        }
    }

    private void setMainPower() {
        for (ChannelSim chan : this.chanData) {
            if (chan == null || chan == this.loadPwrChanC) continue;
            chan.powerOn();
        }
    }

    private void setLoadPower() {
        if (power != null) {
            power.setOn(this.lineOn[1]);
        } else {
            if (this.loadPwrChanC == null) {
                return;
            }
            double value = 0.0;
            if (this.lineOn[0] && this.lineOn[1]) {
                value = this.loadFract * this.loadPwrChanC.onValue;
            }
            this.setLoadTmpRate(value);
            this.loadPwrChanC.endValue = value;
            this.loadPwrChanC.value = value;
        }
    }

    class ChannelSim {
        int hwChan;
        double onValue;
        double onTime;
        double offValue;
        double offTime;
        double endValue;
        double rate;
        boolean negative;
        double value;
        long currTime;

        public ChannelSim(int hwChan, double onValue, double onTime, double offValue, double offTime) {
            this.hwChan = hwChan;
            this.onValue = onValue;
            this.onTime = onTime;
            this.offValue = offValue;
            this.offTime = offTime;
            this.currTime = System.currentTimeMillis();
        }

        void initialize() {
            if (this == SimDevice.this.loadPwrChanC) {
                this.onTime = 0.0;
                this.offValue = 0.0;
                this.offTime = 0.0;
            }
            this.endValue = this.offValue;
            this.value = this.offValue;
        }

        void read() {
            if (this == SimDevice.this.loadPwrChanC && power != null) {
                this.value = power.isOn() ? power.readVoltage(0) * power.readCurrent(0) : Double.NaN;
            } else {
                long thisTime = System.currentTimeMillis();
                double intvl = (double)(thisTime - this.currTime) / 1000.0;
                this.currTime = thisTime;
                this.value += this.rate * intvl;
                if (this.negative) {
                    if (this.value < this.endValue) {
                        this.value = this.endValue;
                    }
                } else if (this.value > this.endValue) {
                    this.value = this.endValue;
                }
            }
        }

        void powerOn() {
            this.currTime = System.currentTimeMillis();
            this.rate = 0.0;
            if (SimDevice.this.lineOn[0]) {
                this.endValue = this.onValue;
                if (this.onTime != 0.0) {
                    this.rate = (this.onValue - this.offValue) / this.onTime;
                }
            } else {
                this.endValue = this.offValue;
                if (this.offTime != 0.0) {
                    this.rate = (this.offValue - this.onValue) / this.offTime;
                }
            }
            if (this.rate == 0.0) {
                this.value = this.endValue;
            }
            this.negative = this.rate < 0.0;
        }
    }

    public static class Power
    extends PowerDevice {
        private static final int N_DEV_CHANS = 3;
        private static final int CHAN_WATTS = 0;
        private static final int CHAN_VOLTS = 1;
        private static final int CHAN_AMPS = 2;
        private static final double LOAD_OHMS = 50.0;
        private double setVolts;
        private double setAmps;
        private double loadVolts;
        private double loadAmps;
        private double loadWatts;
        private boolean outputOn;
        private boolean powerOn;

        protected void initDevice() {
            super.configure(this.mon);
            this.fullName = "Simulated power supply";
            power = this;
            this.disabled = true;
        }

        public void initialize() {
            if (this.checkOn()) {
                this.setCurrent(0, 3.0);
                this.setOnline(true);
                this.initSensors();
            }
        }

        public void close() {
        }

        public int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
            if (hwChan < 0 || hwChan >= 3) {
                MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
            }
            return new int[]{0, 0};
        }

        public double readChannel(int hwChan, int type) {
            this.checkOn();
            switch (hwChan) {
                case 0: {
                    return this.loadWatts;
                }
                case 1: {
                    return this.loadVolts;
                }
                case 2: {
                    return this.loadAmps;
                }
            }
            return 0.0;
        }

        @Override
        public void setVoltage(int chan, double value) {
            if (this.checkOn()) {
                this.setVolts = value;
                this.setPower();
            }
        }

        @Override
        public void setCurrent(int chan, double value) {
            if (this.checkOn()) {
                this.setAmps = value;
                this.setPower();
            }
        }

        @Override
        public void setOutput(int chan, boolean value) {
            if (this.checkOn()) {
                this.outputOn = value;
                this.setPower();
            }
        }

        @Override
        public double readVoltage(int chan) {
            this.checkOn();
            return this.loadVolts;
        }

        @Override
        public double readCurrent(int chan) {
            this.checkOn();
            return this.loadAmps;
        }

        @Override
        public boolean getOutput(int chan) {
            this.checkOn();
            return this.outputOn;
        }

        void setOn(boolean on) {
            this.powerOn = on;
            if (!on) {
                this.outputOn = false;
                this.setVolts = 0.0;
                this.setAmps = 0.0;
            }
        }

        boolean isOn() {
            return this.powerOn;
        }

        private void setPower() {
            if (!this.outputOn) {
                this.loadVolts = 0.0;
                this.loadAmps = 0.0;
            } else {
                double amps = this.setVolts / 50.0;
                if (amps > this.setAmps) {
                    amps = this.setAmps;
                }
                this.loadVolts = amps * 50.0;
                this.loadAmps = amps;
            }
            this.loadWatts = this.loadVolts * this.loadAmps;
            sim.setLoadTmpRate(this.loadWatts);
        }

        private boolean checkOn() {
            if (!this.powerOn) {
                LOG.error((Object)"Simulated power supply is turned off");
                this.setOnline(false);
            }
            return this.powerOn;
        }
    }
}

