/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.Compressor;
import org.lsst.ccs.subsystem.refrig.Compressor0;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.constants.CompressorState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.utilities.logging.Logger;

public class RefrigMain
extends Subsystem
implements HasLifecycle,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService as;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService ass;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, ColdCompressor> coldComps = new LinkedHashMap<String, ColdCompressor>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, CryoCompressor> cryoComps = new LinkedHashMap<String, CryoCompressor>();
    private static final Logger LOG = Logger.getLogger((String)Compressor0.class.getName());
    private final RefrigState state = new RefrigState();

    public RefrigMain() {
        super("refrig", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        AgentPeriodicTask pt = new AgentPeriodicTask("compressor-state", () -> this.updateRefrigState()).withPeriod(Duration.ofMillis(3000L));
        this.apts.scheduleAgentPeriodicTask(pt);
        this.ass.registerState(CompressorState.class, "Compressor state", (Object)this);
        this.ass.updateAgentState(new Enum[]{CompressorState.OFFLINE});
    }

    /*
     * WARNING - void declaration
     */
    public void postInit() {
        ArrayList<String> keys;
        int nComp;
        this.subsys.setAgentProperty("compressorType", RefrigMain.class.getCanonicalName());
        if (this.coldComps.isEmpty() && this.cryoComps.isEmpty()) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"No compressors", (String)"defined");
        }
        if ((nComp = this.coldComps.size()) > 2) {
            void var3_4;
            LOG.warning((Object)("Too many (" + nComp + ") cold compressors specified: using only the first " + 2));
            keys = new ArrayList<String>(this.coldComps.keySet());
            int n = 2;
            while (var3_4 < nComp) {
                this.coldComps.remove(keys.get((int)var3_4));
                ++var3_4;
            }
        }
        nComp = 0;
        for (Compressor compressor : this.coldComps.values()) {
            compressor.setIndex(nComp++);
        }
        this.state.setNumColdComps(nComp);
        nComp = this.cryoComps.size();
        if (nComp > 6) {
            void var3_7;
            LOG.warning((Object)("Too many (" + nComp + ") cryo compressors specified: using only the first " + 6));
            keys = new ArrayList<String>(this.cryoComps.keySet());
            int n = 6;
            while (var3_7 < nComp) {
                this.cryoComps.remove(keys.get((int)var3_7));
                ++var3_7;
            }
        }
        nComp = 0;
        for (Compressor compressor : this.cryoComps.values()) {
            compressor.setIndex(nComp++);
        }
        this.state.setNumCryoComps(nComp);
    }

    public void postStart() {
        LOG.info((Object)("Refrigeration subsystem started with " + this.coldComps.size() + " cold compressors and " + this.cryoComps.size() + " cryo compressors"));
    }

    @Command(type=Command.CommandType.QUERY, description="Get the refrigeration state")
    public RefrigState getSystemState() {
        this.state.clearCompStates();
        this.state.setTickMillis(this.getTickPeriod());
        for (Compressor compressor : this.coldComps.values()) {
            this.state.addColdState(compressor.getState());
        }
        for (Compressor compressor : this.cryoComps.values()) {
            this.state.addCryoState(compressor.getState());
        }
        return this.state;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setUpdatePeriod(int value) {
        this.setTickPeriod(value);
        this.state.clearCompStates();
        this.publishState();
    }

    public boolean processAlarm(int event, int parm, String cause, String name) {
        switch (parm) {
            case 0: {
                if (event == 0 || event != 3) break;
                break;
            }
        }
        return false;
    }

    private void updateRefrigState() {
        boolean changed = false;
        this.state.clearCompStates();
        for (Compressor compressor : this.coldComps.values()) {
            if (!compressor.updateState()) continue;
            changed = true;
            this.state.addColdState(compressor.getState());
        }
        for (Compressor compressor : this.cryoComps.values()) {
            if (!compressor.updateState()) continue;
            changed = true;
            this.state.addCryoState(compressor.getState());
        }
        if (changed) {
            this.publishState();
        }
    }

    private void publishState() {
        this.state.setTickMillis(this.getTickPeriod());
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("RefrigState", (Serializable)this.state));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

