/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.HeaterPS;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class HeaterPsDevice
extends PowerDevice {
    public static final int CHANSET_COLD = 0;
    public static final int CHANSET_CRYO = 1;
    public static final int TYPE_VOLTAGE = 0;
    public static final int TYPE_CURRENT = 1;
    public static final int TYPE_POWER = 2;
    public static final int TYPE_TEMP = 3;
    public static final int TYPE_MAIN_VOLTS = 4;
    public static final int TYPE_MAIN_CURR = 5;
    public static final int TYPE_MAIN_POWER = 6;
    public static final int TYPE_MAIN_TEMP = 7;
    public static final int TYPE_MAIN_STATUS = 8;
    private static final int N_HW_CHANS = 12;
    private static final String NODE = "node";
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="node", category="Refrig", isFinal=true)
    private Integer node;
    private int[] cryoChannels = new int[]{0, 1, 2, 3, 4, 5};
    private int[] coldChannels = new int[]{6, 7, 8, 9, 10, 11};
    private double heaterOhms = 12.5;
    private static final Logger LOG;
    private final HeaterPS htr = new HeaterPS();
    private final Set<Integer> coldChannelSet = new HashSet<Integer>();
    private final Set<Integer> cryoChannelSet = new HashSet<Integer>();
    private final Set<Integer>[] channelSets = new Set[2];
    private final double[] currents = new double[12];

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)NODE, (String)"is missing");
        }
        for (int chan : this.coldChannels) {
            if (chan < 0 || chan >= 12) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("coldChannel " + chan), (String)" is invalid");
            }
            if (this.coldChannelSet.add(chan)) continue;
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("coldChannel " + chan), (String)" is a duplicate");
        }
        for (int chan : this.cryoChannels) {
            if (chan < 0 || chan >= 12) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is invalid");
            }
            if (this.coldChannelSet.contains(chan)) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is a coldChannel");
            }
            if (this.cryoChannelSet.add(chan)) continue;
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)("cryoChannel " + chan), (String)" is a duplicate");
        }
        this.channelSets[0] = this.coldChannelSet;
        this.channelSets[1] = this.cryoChannelSet;
        this.fullName = "Heater power supply (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.htr.open(this.node.intValue());
            this.htr.setMainPowerOn(true);
            this.setOnline(true);
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.htr != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.htr.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (int j = 0; j < 12; ++j) {
            this.currents[j] = 0.0;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (!(iType != 0 && iType != 1 && iType != 2 || hwChan >= 0 && hwChan < 12)) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"HW channel", (Object)hwChan);
        }
        return new int[]{iType, 0};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            for (int chan = 0; chan < 12; ++chan) {
                this.currents[chan] = this.htr.readCurrent(chan);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading currents from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            try {
                switch (type) {
                    case 0: {
                        value = this.heaterOhms * this.currents[hwChan];
                        break;
                    }
                    case 1: {
                        value = this.currents[hwChan];
                        break;
                    }
                    case 2: {
                        value = this.heaterOhms * this.currents[hwChan] * this.currents[hwChan];
                        break;
                    }
                    case 3: {
                        value = this.htr.readBoardTemperature();
                        break;
                    }
                    case 4: {
                        value = this.htr.readMainVoltage();
                        break;
                    }
                    case 5: {
                        value = this.htr.readMainCurrent();
                        break;
                    }
                    case 6: {
                        value = this.htr.readMainVoltage() * this.htr.readMainCurrent();
                        break;
                    }
                    case 7: {
                        value = this.htr.readMainTemperature();
                        break;
                    }
                    case 8: {
                        value = this.htr.readMainStatus();
                    }
                }
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading value from " + this.fullName + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    @Override
    public void setOutput(int chanSet, boolean value) {
        if (!this.online) {
            return;
        }
        try {
            for (int chan : this.channelSets[chanSet]) {
                this.htr.setOutput(chan, value);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chanSet) {
        if (!this.online) {
            return false;
        }
        try {
            boolean state = false;
            for (int chan : this.channelSets[chanSet]) {
                state |= this.htr.getOutput(chan);
            }
            return state;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return false;
        }
    }

    @Override
    @Command(description="Set the voltage", type=Command.CommandType.ACTION)
    public void setVoltage(int chanSet, double value) {
        if (!this.online) {
            return;
        }
        try {
            for (int chan : this.channelSets[chanSet]) {
                this.htr.setVoltage(chan, value);
            }
        }
        catch (DriverException e) {
            LOG.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chanSet) {
        if (!this.online) {
            return -1.0;
        }
        try {
            double current = 0.0;
            for (int chan : this.channelSets[chanSet]) {
                current += this.htr.readCurrent(chan);
            }
            return this.heaterOhms * current / (double)this.channelSets[chanSet].size();
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
    }

    @Override
    public double readCurrent(int chanSet) {
        if (!this.online) {
            return -1.0;
        }
        try {
            double current = 0.0;
            for (int chan : this.channelSets[chanSet]) {
                current += this.htr.readCurrent(chan);
            }
            return current;
        }
        catch (DriverException e) {
            LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    static {
        typeMap.put("VOLTAGE", 0);
        typeMap.put("CURRENT", 1);
        typeMap.put("POWER", 2);
        typeMap.put("TEMP", 3);
        typeMap.put("MAINVOLTS", 4);
        typeMap.put("MAINCURR", 5);
        typeMap.put("MAINPOWER", 6);
        typeMap.put("MAINTEMP", 7);
        typeMap.put("MAINSTAT", 8);
        LOG = Logger.getLogger((String)HeaterPsDevice.class.getName());
    }
}

