/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.subsystem.monitor.Device;
import org.lsst.ccs.subsystem.monitor.Monitor;

public class WUDevice
extends Device
implements WattsUp.Listener {
    private static final int CHAN_WATTS = 0;
    private static final int CHAN_VOLTS = 1;
    private static final int CHAN_FREQ = 2;
    private static final int N_DEV_CHANS = 3;
    private static final int LOG_PERIOD = 1;
    private String node;
    private String serial;
    private WattsUp wtu;
    private final double[] value = new double[3];

    public WUDevice(String nodeName, String serialNo) {
        this.node = nodeName;
        this.serial = serialNo;
    }

    public WUDevice() {
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        this.fullName = "WattsUp meter (" + (this.node == null ? "local" : this.node) + (this.serial == null ? "" : ":" + this.serial) + ")";
    }

    protected void initialize() {
        try {
            if (!this.inited || this.wtu == null) {
                this.wtu = new WattsUp();
                this.wtu.addListener((WattsUp.Listener)this);
            }
            this.wtu.open(this.node, 0, this.serial);
            this.wtu.restart();
            this.setOnline(true);
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
    }

    protected double readChannel(int chan, int type) {
        return this.online ? this.value[chan] : super.readChannel(chan, type);
    }

    public void setPowered(boolean on) {
        if (on) {
            try {
                this.wtu.setLoggedFields(65539);
                this.wtu.setExternalLogging(1);
            }
            catch (DriverException e) {
                this.log.error((Object)("Error configuring " + this.fullName + ": " + (Object)((Object)e)));
            }
        } else {
            for (int j = 0; j < 3; ++j) {
                this.value[j] = 0.0;
            }
        }
    }

    public void setClosed() {
        this.setOnline(false);
    }

    public void processData(double[] data) {
        this.value[0] = data[0];
        this.value[1] = data[1];
        this.value[2] = data[16];
    }
}

