/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PIController;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class TempControl
extends ConfigurableComponent {
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput;
    private Double awGain;
    private Double basePower;
    private Double tolerance;
    private double minOutput = 0.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private PIController pic;
    private PowerDevice powerDevc;
    private List<Channel> tempChans;
    private double[] temps;
    private double lastPower;
    private boolean running;
    private Timer loopTimer;

    public TempControl(double gain, double timeConst, double smoothTime, double maxOutput, double awGain, double basePower, double tolerance, int updateTime) {
        this.gain = gain;
        this.timeConst = timeConst;
        this.smoothTime = smoothTime;
        this.maxOutput = maxOutput;
        this.awGain = awGain;
        this.basePower = basePower;
        this.tolerance = tolerance;
        this.updateTime = updateTime;
    }

    public TempControl() {
    }

    public void initialize(List tempChans, PowerDevice powerDevc, Monitor mon) {
        if (this.gain == null) {
            mon.reportConfigError(this.getName(), "gain", "is missing");
        }
        if (this.timeConst == null) {
            mon.reportConfigError(this.getName(), "timeConst", "is missing");
        }
        if (this.smoothTime == null) {
            mon.reportConfigError(this.getName(), "smoothTime", "is missing");
        }
        if (this.maxOutput == null) {
            mon.reportConfigError(this.getName(), "maxOutput", "is missing");
        }
        if (this.awGain == null) {
            mon.reportConfigError(this.getName(), "awGain", "is missing");
        }
        if (this.basePower == null) {
            mon.reportConfigError(this.getName(), "basePower", "is missing");
        }
        if (this.tolerance == null) {
            mon.reportConfigError(this.getName(), "tolerance", "is missing");
        }
        if (this.updateTime == null) {
            mon.reportConfigError(this.getName(), "updateTime", "is missing");
        }
        this.tempChans = tempChans;
        this.powerDevc = powerDevc;
        this.temps = new double[tempChans.size()];
        this.pic = new PIController(this.gain, this.timeConst);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setAwGain(this.awGain);
        this.pic.setBaseOutput(this.basePower);
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setTolerance(this.tolerance);
    }

    public void setTemp(double value) {
        this.pic.setSetpoint(value);
    }

    public void reset() {
        this.pic.reset();
    }

    public void restart() {
        this.start(this.lastPower);
    }

    public void start(double power) {
        if (this.running) {
            return;
        }
        this.running = true;
        this.pic.reset();
        this.pic.setIntegral(power - this.basePower);
        this.loopTimer = new Timer(true);
        this.loopTimer.schedule((TimerTask)new Iterate(), 0L, (long)this.updateTime.intValue());
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.loopTimer.cancel();
    }

    private class Iterate
    extends TimerTask {
        private Iterate() {
        }

        @Override
        public void run() {
            int index = 0;
            for (Channel tempChan : TempControl.this.tempChans) {
                ((TempControl)TempControl.this).temps[index++] = tempChan.getValue();
            }
            double tod = (double)System.currentTimeMillis() / 1000.0;
            TempControl.this.lastPower = TempControl.this.pic.performPI(TempControl.this.temps, tod);
            TempControl.this.powerDevc.setPower(0, TempControl.this.lastPower);
        }
    }
}

