/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.sorensen.Dcs;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class DcsDevice
extends PowerDevice {
    static final int CHAN_POWER = 0;
    static final int CHAN_VOLTAGE = 1;
    static final int CHAN_CURRENT = 2;
    static final int N_HW_CHANS = 3;
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private static final Map<String, Integer> typeMap;
    private String connType;
    private String ident;
    private double maxCurrent = 3.0;
    private DriverConstants.ConnType connTypeC;
    private Dcs dcs;
    private final double[] values = new double[3];

    protected void configure(Monitor mon) {
        super.configure(mon);
        if (this.connType == null) {
            mon.reportConfigError(this.getName(), "connType", "is missing");
        }
        this.connTypeC = cTypeMap.get(this.connType);
        if (this.connTypeC == null) {
            mon.reportConfigError(this.getName(), "connType", "is invalid: " + this.connType);
        }
        if (this.ident == null) {
            mon.reportConfigError(this.getName(), "ident", "is missing");
        }
        this.fullName = "Sorensen DCS module (" + this.ident + ")";
        this.disabled = true;
    }

    protected void initialize() {
        if (this.connTypeC == null) {
            return;
        }
        try {
            if (!this.inited || this.dcs == null) {
                this.dcs = new Dcs();
            }
            this.dcs.open(this.connTypeC, this.ident);
            this.dcs.setCurrent(this.maxCurrent);
            this.setOnline(true);
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.dcs != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.dcs.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (int j = 0; j < 3; ++j) {
            this.values[j] = 0.0;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "HW channel", (Object)hwChan);
        }
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        return new int[]{iType, iSubtype};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            this.values[1] = this.dcs.readVoltage();
            this.values[2] = this.dcs.readCurrent();
            this.values[0] = this.values[1] * this.values[2];
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.online ? this.values[hwChan] : super.readChannel(hwChan, type);
    }

    @Override
    public void setOutput(int chan, boolean value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setOutput(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chan) {
        if (!this.testOnline()) {
            return false;
        }
        try {
            return this.dcs.getOutput();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return false;
        }
    }

    @Override
    public void setVoltage(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setVoltage(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.dcs.readVoltage();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.dcs.setCurrent(value);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readCurrent(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.dcs.readCurrent();
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    static {
        cTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
        cTypeMap.put("FTDI", DriverConstants.ConnType.FTDI);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("POWER", 2);
    }
}

