import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.LongLines;
import org.lsst.ccs.subsystem.refrig.MCCDevice;
import org.lsst.ccs.subsystem.refrig.WUDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-longlines"]

builder.main (LongLines, argMap("main", 10000, 1000, 0, "MainLine", "LoadLine")) {

    Daq1       (MCCDevice, argMap("TC_AI", "00087534"))

    Daq2       (MCCDevice, argMap("TC_AI", "00097615"))

    Daq3       (MCCDevice, argMap("TEMP", "01714C6C"))

    WattsLoad  (WUDevice, argMap(null, "A4007Rxc"))

    WattsCmpr  (WUDevice, argMap(null, "A100KS6F"))

    LED0       (Line, argMap("Daq1", 0, "Daq2", 0))

    LED1       (Line, argMap("Daq1", 1, "Daq2", 1))

    LED2       (Line, argMap("Daq1", 2, "Daq2", 2))

    LED3       (Line, argMap("Daq1", 3, "Daq2", 3))

    LED4       (Line, argMap("Daq1", 4, "Daq2", 4))

    LED5       (Line, argMap("Daq1", 5, "Daq2", 5))

    LoadLine   (Line, argMap("Daq1", 6, "Daq2", 6))

    MainLine   (Line, argMap("Daq1", 7, null, -1))

    Alarm0     (Alarm, argMap("Turns LED0 red", "LED0", -1))

    Alarm1     (Alarm, argMap("Turns LED1 red", "LED1", -1))

    Alarm2     (Alarm, argMap("Turns LED2 red", "LED2", -1))

    Alarm3     (Alarm, argMap("Turns LED3 red", "LED3", -1))

    Alarm4     (Alarm, argMap("Turns LED4 red", "LED4", -1))

    Alarm5     (Alarm, argMap("Turns LED5 red", "LED5", -1))

    Alarm0Main (Alarm, argMap("Turns LED0 red & trips off all power",
                              "LED0", 0))

    Alarm1Main (Alarm, argMap("Turns LED1 red & trips off all power",
                              "LED1", 0))

    Alarm4Load (Alarm, argMap("Turns LED4 red & turns off load power",
                              "LED4", 1))

    AlarmMain  (Alarm, argMap("Trips off all power", null, 0))

    CmpDisTmp  (Channel,
                argMap("Compressor discharge temperature", "\u00b0C",
                       "Daq1", 0, "TEMP", "TC:T", 0.0, 1.0,
                       "alarm", 0.0, 0.0, "Alarm0",
                       "alarm", 0.0, 0.0, "Alarm0Main"))

    CmpDisPrs  (Channel,
                argMap("Compressor discharge pressure", "Psig",
                       "Daq1", 6, "VOLTS", "1.25V", -5.0, 10000.0,
                       "alarm", 0.0, 0.0, "Alarm1",
                       "alarm", 0.0, 0.0, "Alarm1Main"))

    DwrLiqPrs  (Channel,
                argMap("Dewar liquid pressure", "Psig",
                       "Daq2", 4, "VOLTS", "1.25V", 0.0, 5000.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    DwrVapPrs  (Channel,
                argMap("Dewar vapor pressure", "Psig",
                       "Daq2", 5, "VOLTS", "1.25V", 0.0, 5000.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    DwrPrsDiff (Channel,
                argMap("Dewar L/V pressure difference", "Psi",
                       null, 0, "DIFF", "DwrLiqPrs:DwrVapPrs", 0, 0,
                       "none", 0.0, 0.0, null,
                       "none", 0.0, 0.0, null))

    C3LiqdTmp  (Channel,
                argMap("C3 liquid cap temperature", "\u00b0C",
                       "Daq1", 1, "TEMP", "TC:T", 0.0, 1.0,
                       "alarm", 0.0, 0.0, "Alarm2",
                       "alarm", 0.0, 0.0, "Alarm2"))

    PreC4Tmp   (Channel,
                argMap("Pre C4 evaporator temperature", "\u00b0C",
                       "Daq1", 2, "TEMP", "TC:T", 0.0, 1.0,
                       "alarm", 0.0, 0.0, "Alarm3",
                       "alarm", 0.0, 0.0, "Alarm3"))

    PostC4Tmp  (Channel,
                argMap("Post C4 temperature", "\u00b0C",
                       "Daq2", 2, "TEMP", "TC:T", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    PostEvpTmp (Channel,
                argMap("Post evaporator temperature", "\u00b0C",
                       "Daq2", 0, "TEMP", "TC:T", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    LoadTmp    (Channel,
                argMap("Heat load temperature", "\u00b0C",
                       "Daq3", 0, "TEMP", "RTD:3WIRE", 0.0, 1.0,
                       "alarm", 0.0, 0.0, "Alarm4",
                       "alarm", 0.0, 2.0, "Alarm4Load"))

    DwrSucPrs  (Channel,
                argMap("Dewar suction pressure", "Psig",
                       "Daq1", 5, "VOLTS", "5V", 0.0, 20.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    CmpSucPrs  (Channel,
                argMap("Compressor suction pressure", "Psig",
                       "Daq1", 7, "VOLTS", "1.25V", -0.53, 1000.0,
                       "alarm", 0.0, 0.0, "Alarm5",
                       "alarm", 0.0, 0.0, "Alarm5"))

    SucPrsDiff (Channel,
                argMap("Suction pressure difference", "Psi",
                       null, 0, "DIFF", "DwrSucPrs:CmpSucPrs", 0, 0,
                       "none", 0.0, 0.0, null,
                       "none", 0.0, 0.0, null))

    LoadPower  (Channel,
                argMap("Heat load power", "Watts",
                       "WattsLoad", 0, "POWER", "", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    CmprPower  (Channel,
                argMap("Compressor power", "Watts",
                       "WattsCmpr", 0, "POWER", "", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "alarm", 0.0, 0.0, "AlarmMain"))

    CmprVolts  (Channel,
                argMap("Compressor line voltage", "Volts",
                       "WattsCmpr", 1, "POWER", "", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))

    AmbientTmp (Channel,
                argMap("Ambient Temperature", "\u00b0C",
                       "Daq2", 1, "TEMP", "TC:T", 0.0, 1.0,
                       "flag", 0.0, 0.0, null,
                       "flag", 0.0, 0.0, null))
}
