import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.refrig.RefrigMain;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.DcsDevice;
import org.lsst.ccs.subsystem.refrig.DL34970Device;
import org.lsst.ccs.subsystem.refrig.Maq20Device;
import org.lsst.ccs.subsystem.refrig.PlutoDevice;
import org.lsst.ccs.subsystem.monitor.Alarm;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Channel;

String limitLo = "limitLo"
String limitHi = "limitHi"

CCSBuilder builder = ["ccs-refrig-cold"]

builder.main (RefrigMain, tickMillis: 10000, monMillis: 1000, checkMillis: 7500,
              cmprPowerLines: [["CmprLine"]] as List[],
              loadPowerDevc: "Power",
              loadTempChans: ["Htr5OutTmp"] as String[],
              tempCtrl: "TempCtrl") {

    TempCtrl   (TempControl, gain: 10, timeConst: 1000, smoothTime: 120,
                maxOutput: 900, awGain: 4, basePower: 0, tolerance: 0.05,
                updateTime: 30000)

    MaqCmpr    (Maq20Device, node: "192.168.128.100",
                serial: ["0107000-12", "0098488-08"] as String[])

    PlutoCmpr  (PlutoDevice, node: "192.168.0.100", areas: [1, 1, 1, 2, 1, 3])

    Logger     (DL34970Device, connType: "SERIAL", devcId: "/dev/ttyS0")

    Power      (DcsDevice, connType: "FTDI", ident: "AH0315MY", maxCurrent: 7.5)

    CmprLine   (Line, devcName: "PlutoCmpr", chan: 16)

//    ResetLine  (Line, devcName: "PlutoCmpr", chan: 0)

    AlarmCmpr  (Alarm, description: "Trips off compressor power", eventParm: 0)

    AlarmHtr   (Alarm, description: "Trips off heater power", eventParm: RefrigMain.ALARM_HEATER)

    AlarmAll   (Alarm, description: "Trips off all power", eventParm: RefrigMain.ALARM_ALL)

/*
    Chanxxx    (Channel, description: "",
                format: ".2f", units: "", devcName: "xxx, hwChan: 0,
                type: "", subtype: "", offset: 0, scale: 1,
                checkLo: "flag", limitLo: 0.0, dbandLo: 0.0, alarmLo: null,
                checkHi: "flag", limitHi: 0.0, dbandHi: 0.0, alarmHi: null)
*/

    CmprPower  (Channel, description: "Compressor\\Power", units: "Watts",
                devcName: null, type: "PROD", subtype: "CmpVolts:CmpCurr", scale: 2.785,
                checkLo: "alarm", alarmLo: "AlarmAll",
                checkHi: "alarm", alarmHi: "AlarmAll")

    CmpDisPrs  (Channel, description: "Discharge pressure", units: "Psig",
                devcName: "PlutoCmpr", hwChan: 1, type: "ADDREG:0", offset: 0.0, scale: 0.1,
                checkHi: "alarm", alarmHi: "AlarmAll")

    CmpSucPrs  (Channel, description: "Suction pressure", units: "Psig",
                devcName: "PlutoCmpr", hwChan: 0, type: "ADDREG:1", offset: 0.0, scale: 0.1,
                checkLo: "alarm", alarmLo: "AlarmAll")

    CmpDisTmp  (Channel, description: "Discharge temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 2, type: "TTC:1", subtype: "T220",
                checkHi: "alarm", alarmHi: "AlarmAll")

    CmpSucTmp  (Channel, description: "Suction temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 0, type: "TTC:1", subtype: "T220")

    CmpLiqTmp  (Channel, description: "Liquid line temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 3, type: "TTC:1", subtype: "T220",
                checkHi: "alarm", alarmHi: "AlarmAll")

    CmpSucRtnTmp  (Channel, description: "Suction return temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 4, type: "TTC:1", subtype: "T220")

    CmpWtrTmp  (Channel, description: "Water supply temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 5, type: "TTC:1", subtype: "T220")

    CmpWtrRtnTmp  (Channel, description: "Water return temperature", units: "\u00b0C",
                devcName: "MaqCmpr", hwChan: 1, type: "TTC:1", subtype: "T220")

    CmpVolts   (Channel, description: "Line voltage", units: "Volts",
                devcName: "MaqCmpr", hwChan: 0, type: "VOLT:0", subtype: "V5", scale: 50.0,
                checkLo: "alarm", alarmLo: "AlarmAll",
                checkHi: "alarm", alarmHi: "AlarmAll")

    CmpCurr    (Channel, description: "Current", units: "Amps",
                devcName: "MaqCmpr", hwChan: 1, type: "VOLT:0", subtype: "V5", scale: 5.0)

    EvapOutPrs (Channel, description: "Heat Exchanger/Evaporator\\Evaporator outlet pressure", units: "psig",
                devcName: "Logger", hwChan: 120, type: "VOLT", subtype: "0.5", scale: 1000)
/*
    HxSuppPrs  (Channel, description: "Supply pressure", units: "psig",
                devcName: "Logger", hwChan: 120, type: "VOLT", subtype: "0.5", scale: 1000)

    HxRetnPrs  (Channel, description: "Return pressure", units: "psig",
                devcName: "Logger", hwChan: 101, type: "VOLT", subtype: "T")
*/
    HxSuppTmp  (Channel, description: "Supply temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 101, type: "TEMP", subtype: "T")

    Hx2DinTmp  (Channel, description: "HX2-D-in temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 102, type: "TEMP", subtype: "T")

    PreExpTmp  (Channel, description: "Pre-expansion temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 103, type: "TEMP", subtype: "T")

    PostExpTmp (Channel, description: "Post-expansion temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 104, type: "TEMP", subtype: "T")

    CoilInTmp  (Channel, description: "Coil in temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 105, type: "TEMP", subtype: "T")

    CoilHighTmp (Channel, description: "Coil high temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 106, type: "TEMP", subtype: "T")

    Htr1InTmp  (Channel, description: "Heater 1 inlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 107, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr2InTmp  (Channel, description: "Heater 2 inlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 108, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr3InTmp  (Channel, description: "Heater 3 inlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 109, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr3OutTmp (Channel, description: "Heater 3 outlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 110, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr4InTmp  (Channel, description: "Heater 4 inlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 111, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr5InTmp  (Channel, description: "Heater 5 inlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 112, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    Htr5OutTmp (Channel, description: "Heater 5 outlet temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 113, type: "TEMP", subtype: "T",
                checkHi: "alarm", alarmHi: "AlarmHtr")

    CoillowTmp (Channel, description: "Coil low temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 114, type: "TEMP", subtype: "T")

    CoilOutTmp (Channel, description: "Coil out temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 115, type: "TEMP", subtype: "T")

    Hx2SinTmp  (Channel, description: "HX2-S-in temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 116, type: "TEMP", subtype: "T")

    Hx1SinTmp  (Channel, description: "HX1-S-in temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 117, type: "TEMP", subtype: "T")

    HxRetnTmp  (Channel, description: "Return temperature", units: "\u00b0C",
                devcName: "Logger", hwChan: 118, type: "TEMP", subtype: "T")

    LoadPower  (Channel, description: "Heat load power", units: "Watts",
                devcName: "Power", hwChan: 0, type: "POWER")

    LoadVolts  (Channel, description: "Heat load voltage", units: "Volts",
                devcName: "Power", hwChan: 1, type: "POWER")

    CmprOnSw   (Channel, description: "Control\\Compressor ON switch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 6, type: "GLOBAL:1")

    CmprPerm   (Channel, description: "CCS compressor permit", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 20, type: "GLOBAL:1")

    CmprEnab   (Channel, description: "Compressor enable", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 31, type: "GLOBAL:1")

    CmprPwr    (Channel, description: "Compressor power", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 16, type: "GLOBAL:1")

    PermLatch  (Channel, description: "External permit latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 30, type: "GLOBAL:1")

    FlowLatch  (Channel, description: "Water flow OK latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 29, type: "GLOBAL:1")

    LiqdTmpOk  (Channel, description: "Liquid temp valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 21, type: "GLOBAL:1")

    LiqdTmpHi  (Channel, description: "Liquid temp high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 22, type: "GLOBAL:1")

    CompTmpOk  (Channel, description: "Compressor temp valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 23, type: "GLOBAL:1")

    CompTmpHi  (Channel, description: "Compressor temp high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 24, type: "GLOBAL:1")

    DisPrsOk   (Channel, description: "Discharge pressure valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 25, type: "GLOBAL:1")

    DisPrsHigh (Channel, description: "Discharge pressure high latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 26, type: "GLOBAL:1")

    SucPrsOk   (Channel, description: "Suction pressure valid", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 27, type: "GLOBAL:1")

    SucPrsLow  (Channel, description: "Suction pressure low latch", format: ".0f",
                devcName: "PlutoCmpr", hwChan: 28, type: "GLOBAL:1")

}
