/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Channel;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.MonitorCommands;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.PowerDevice;
import org.lsst.ccs.subsystem.refrig.TempControl;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;
import org.lsst.ccs.utilities.logging.Logger;

public class RefrigMain
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    public static final int ALARM_HEATER = 8;
    public static final int ALARM_ALL = 9;
    private static final int TICK_INTERVAL = 10000;
    private static final int POWER_SET_INTERVAL = 5000;
    private static final String REFRIG = "Refrig";
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.refrig");
    private int monMillis = 1000;
    private int checkMillis = 0;
    private String loadPowerDevc;
    private String[][] cmprPowerLines = new String[0][0];
    private String[] loadPowerLines = new String[0];
    private String[] alarmDsabChans = new String[0];
    private String[] loadTempChans = new String[0];
    private String tempCtrl;
    private boolean coldStart;
    private boolean running;
    private final List<List<Line>> cmprPowerLinesL = new ArrayList<List<Line>>();
    private final List<Line> loadPowerLinesL = new ArrayList<Line>();
    private final List<Channel> alarmDsabChansL = new ArrayList<Channel>();
    private final List<Channel> loadTempChansL = new ArrayList<Channel>();
    private ConfigurableSubsystem subsys;
    private PowerDevice loadPowerDevcD;
    private TempControl tempCtrlC;
    private Monitor mon;
    private final RefrigState state = new RefrigState();
    private Double startPower = 0.0;

    public void initModule() {
        Object cmpt;
        this.setName("main");
        if (this.getTickMillis() <= 0) {
            this.setTickMillis(10000);
        }
        this.state.setTickMillis(this.getTickMillis());
        this.subsys = (ConfigurableSubsystem)this.getSubsystem();
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
        this.loadPowerDevcD = (PowerDevice)((Object)this.getComponent(this.loadPowerDevc, PowerDevice.class));
        for (String[] stringArray : this.cmprPowerLines) {
            ArrayList<Line> lines = new ArrayList<Line>();
            this.cmprPowerLinesL.add(lines);
            for (String cName : stringArray) {
                Object cmpt2 = this.getComponent(cName, Line.class);
                if (cmpt2 == null) continue;
                lines.add((Line)cmpt2);
            }
        }
        this.state.setNumCmprs(Math.min(8, this.cmprPowerLinesL.size()));
        for (String[] stringArray : this.loadPowerLines) {
            cmpt = this.getComponent((String)stringArray, Line.class);
            if (cmpt == null) continue;
            this.loadPowerLinesL.add((Line)cmpt);
        }
        for (String[] stringArray : this.alarmDsabChans) {
            cmpt = this.getComponent((String)stringArray, Channel.class);
            if (cmpt == null) continue;
            this.alarmDsabChansL.add((Channel)cmpt);
        }
        for (String[] stringArray : this.loadTempChans) {
            cmpt = this.getComponent((String)stringArray, Channel.class);
            if (cmpt == null) continue;
            this.loadTempChansL.add((Channel)cmpt);
        }
        this.tempCtrlC = (TempControl)((Object)this.getComponent(this.tempCtrl, TempControl.class));
        if (this.cmprPowerLinesL.isEmpty()) {
            this.sLog.error((Object)"No valid compressors specified");
        } else if (this.state.getNumCmprs() != this.cmprPowerLines.length) {
            this.sLog.error((Object)"Some compressors are invalid");
        }
        for (int j = 0; j < this.state.getNumCmprs(); ++j) {
            List<Line> lines = this.cmprPowerLinesL.get(j);
            if (lines.size() != this.cmprPowerLines[j].length) {
                this.sLog.error((Object)("Some (or all) control lines are invalid for compressor " + j));
                continue;
            }
            if (!lines.isEmpty()) continue;
            this.sLog.error((Object)("No control lines specified for compressor " + j));
        }
        if (this.loadPowerLinesL.size() != this.loadPowerLines.length) {
            this.sLog.error((Object)"Some (or all) heater PS control lines are invalid");
        } else if (this.loadPowerLinesL.isEmpty()) {
            this.sLog.warn((Object)"No heater PS control lines specified: assume always on");
        }
        if (this.loadPowerDevcD == null) {
            this.sLog.warn((Object)"No heater PS device specified: assume no heater control");
            this.state.setHeaterControlState(3);
        }
        if (this.alarmDsabChansL.size() != this.alarmDsabChans.length) {
            this.sLog.error((Object)"Some alarm disable channels are invalid");
        }
        if (this.loadTempChansL.size() != this.loadTempChans.length) {
            this.sLog.error((Object)"Some load temperature channels are invalid");
        }
        if (this.tempCtrlC == null) {
            this.sLog.error((Object)"No valid temperature controller specified");
        }
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, this.sLog);
        this.mon.initConfiguration();
        this.subsys.addCommandsFromObject((Object)new MonitorCommands(this.mon), "");
        if (this.tempCtrlC != null) {
            this.tempCtrlC.initialize(this.loadTempChansL, this.loadPowerDevcD, this.mon);
        }
    }

    public TreeWalkerDiag checkHardware() {
        for (List<Line> lines : this.cmprPowerLinesL) {
            for (Line line : lines) {
                line.setWarm(!this.coldStart);
            }
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        for (List<Line> lines : this.cmprPowerLinesL) {
            for (Line line : lines) {
                line.setWarm(false);
            }
        }
        for (Line line : this.loadPowerLinesL) {
            line.setWarm(false);
        }
        for (int cmpr = 0; cmpr < this.state.getNumCmprs(); ++cmpr) {
            this.setCmprPowerEnable(cmpr, this.isCmprPowerOn(cmpr) ? 1 : 0);
        }
        this.setHeaterPowerEnable(this.isHeaterPowerOn() ? 1 : 0);
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        this.sLog.info((Object)"checkStarted was called");
    }

    public void checkStopped() {
        this.sLog.info((Object)"checkStopped was called");
    }

    public void postStart() throws HardwareException {
        this.running = true;
        this.mon.start(this.monMillis);
        this.sLog.info((Object)("Refrigeration subsystem (" + this.subsys.getName() + ") started"));
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        new Timer("SetPower", true).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                RefrigMain.this.setHeaterPower();
            }
        }, 5000L, 5000L);
        super.postStart();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.state.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void processAlarm(int event, int parm) {
        if (parm >= 0 && parm < this.state.getNumCmprs() || parm == 9) {
            int first = parm == 9 ? 0 : parm;
            int last = parm == 9 ? this.state.getNumCmprs() : parm + 1;
            for (int j = first; j < last; ++j) {
                if (event == 0) {
                    if (this.state.getCmprPowerState(j) == 2) continue;
                    this.state.setCmprPowerState(j, 2);
                    this.setCmprPowerSwitch(j);
                    this.publishState();
                    continue;
                }
                if (event != 2 || this.state.getCmprPowerState(j) != 2) continue;
                this.state.setCmprPowerState(j, 0);
                this.publishState();
            }
        }
        if (parm == 8 || parm == 9) {
            if (event == 0) {
                if (this.state.getHeaterPowerState() != 2) {
                    this.state.setHeaterPowerState(2);
                    this.setHeaterPowerSwitch();
                    this.publishState();
                }
            } else if (event == 2 && this.state.getHeaterPowerState() == 2) {
                this.state.setHeaterPowerState(0);
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set compressor power enabled state")
    public void setCmprPowerEnable(int cmpr, int value) {
        int newState;
        if (cmpr < 0 || cmpr >= this.state.getNumCmprs()) {
            this.sLog.error((Object)"Invalid compressor number");
            return;
        }
        int oldState = this.state.getCmprPowerState(cmpr);
        int n = oldState == 2 ? oldState : (newState = value == 0 ? 0 : 1);
        if (newState != oldState) {
            this.state.setCmprPowerState(cmpr, newState);
            this.setCmprPowerSwitch(cmpr);
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int value) {
        int newState;
        int oldState = this.state.getHeaterPowerState();
        int n = oldState == 2 ? oldState : (newState = value == 0 ? 0 : 1);
        if (newState != oldState) {
            this.state.setHeaterPowerState(newState);
            this.setHeaterPowerSwitch();
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater control state")
    public void setHeaterControl(int value) {
        int oldState = this.state.getHeaterControlState();
        if (oldState != 3) {
            int newState;
            int n = value == 0 ? 0 : (value > 0 ? 1 : (newState = this.tempCtrlC != null ? 2 : 1));
            if (newState != oldState) {
                this.state.setHeaterControlState(newState);
                if (newState == 2) {
                    this.tempCtrlC.setTemp(this.state.getLoadTemp());
                    this.startTempControl();
                } else {
                    this.stopTempControl();
                    this.setHeaterPower();
                }
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load trip enabled state")
    public void setAlarmDisabled(int value) {
        boolean disable = value != 0;
        this.state.setAlarmDisabled(disable);
        for (Channel chan : this.alarmDsabChansL) {
            chan.enableAlarm(false, !disable);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power set point")
    public void setHeaterPower(double value) {
        this.state.setHeaterPower(value);
        if (this.startPower != null) {
            this.startPower = value;
        }
        this.setHeaterPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load temperature set point")
    public void setLoadTemp(double value) {
        this.state.setLoadTemp(value);
        if (this.tempCtrlC != null) {
            this.tempCtrlC.setTemp(value);
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        this.subsys.saveChangesForCategoriesAs(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.subsys.loadCategories(new String[]{"Refrig:" + name});
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState getFullState() {
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState(this.state, monState);
    }

    private void publishState() {
        KeyValueData data = new KeyValueData("RefrigState", (Serializable)this.state);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setCmprPowerSwitch(int cmpr) {
        boolean on = this.state.getCmprPowerState(cmpr) == 1;
        for (Line line : this.cmprPowerLinesL.get(cmpr)) {
            line.set(on);
        }
    }

    private void setHeaterPowerSwitch() {
        boolean on = this.state.getHeaterPowerState() == 1;
        for (Line line : this.loadPowerLinesL) {
            line.set(on);
        }
        if (this.loadPowerDevcD != null) {
            if (on) {
                this.loadPowerDevcD.enable();
                if (this.loadPowerLinesL.isEmpty()) {
                    this.loadPowerDevcD.enableOutput(0, true);
                }
                if (this.state.getHeaterControlState() == 2) {
                    this.startTempControl();
                }
            } else {
                this.stopTempControl();
                if (this.loadPowerLinesL.isEmpty()) {
                    this.loadPowerDevcD.enableOutput(0, false);
                } else {
                    this.loadPowerDevcD.disable();
                }
            }
        }
    }

    private void setHeaterPower() {
        if (this.loadPowerDevcD == null || !this.loadPowerDevcD.isOnline()) {
            return;
        }
        if (this.state.getHeaterPowerState() != 1) {
            return;
        }
        this.loadPowerDevcD.enableOutput(0, this.state.getHeaterControlState() != 0);
        if (this.state.getHeaterControlState() == 1) {
            double loadPower = this.state.getHeaterPower();
            this.loadPowerDevcD.setPower(0, loadPower);
            this.startPower = loadPower;
        }
    }

    private boolean isCmprPowerOn(int cmpr) {
        if (this.cmprPowerLinesL.isEmpty() || this.cmprPowerLinesL.get(cmpr).isEmpty()) {
            return false;
        }
        for (Line line : this.cmprPowerLinesL.get(cmpr)) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private boolean isHeaterPowerOn() {
        if (this.loadPowerLinesL.isEmpty()) {
            return true;
        }
        for (Line line : this.loadPowerLinesL) {
            if (line.isSet()) continue;
            return false;
        }
        return true;
    }

    private void startTempControl() {
        if (this.tempCtrlC != null) {
            if (this.startPower == null) {
                this.tempCtrlC.restart();
            } else {
                this.tempCtrlC.start(this.startPower);
                this.startPower = null;
            }
        }
    }

    private void stopTempControl() {
        if (this.tempCtrlC != null) {
            this.tempCtrlC.stop();
        }
    }

    private Object getComponent(String name, Class cls) {
        Object cmpt = this.getComponentByName(name);
        if (cmpt != null && !cls.isInstance(cmpt)) {
            cmpt = null;
        }
        return cmpt;
    }
}

