/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.MonitorCommands;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState0;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;
import org.lsst.ccs.utilities.logging.Logger;

public class LongLines
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int EVENT_ID_MAIN_POWER = 0;
    private static final int EVENT_ID_LOAD_POWER = 1;
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.refrig");
    private final boolean coldStart;
    private final int monMillis;
    private final int checkMillis;
    private final String mainPower;
    private final String loadPower;
    private ConfigurableSubsystem subsys;
    private Monitor mon;
    private boolean loadAlarm;
    private int state = 4;
    private Line mainPowerLine;
    private Line loadPowerLine;

    public LongLines(String name, int tickMillis, int monMillis, int checkMillis, String mainPower, String loadPower) {
        super(name, tickMillis);
        this.monMillis = monMillis;
        this.checkMillis = checkMillis;
        this.mainPower = mainPower;
        this.loadPower = loadPower;
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
    }

    public void initModule() {
        this.subsys = (ConfigurableSubsystem)this.getSubsystem();
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, this.sLog);
        this.mon.initConfiguration();
        this.subsys.addCommandsFromObject((Object)new MonitorCommands(this.mon), "");
        this.mainPowerLine = this.mon.getLine(this.mainPower);
        if (this.mainPowerLine == null) {
            this.sLog.error((Object)"Main power line not defined");
        }
        this.loadPowerLine = this.mon.getLine(this.loadPower);
        if (this.loadPowerLine == null) {
            this.sLog.error((Object)"Load power line not defined");
        }
    }

    public TreeWalkerDiag checkHardware() {
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        if (this.mainPowerLine != null) {
            this.mainPowerLine.setWarm(false);
        }
        this.setMainPowerEnable(this.isMainPowerOn() ? 1 : 0);
        this.setLoadPower();
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        this.sLog.info((Object)"checkStarted was called");
    }

    public void checkStopped() {
        this.sLog.info((Object)"checkStopped was called");
    }

    public void postStart() throws HardwareException {
        this.mon.start(this.monMillis);
        this.sLog.info((Object)"Refrigeration long lines test system started");
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        super.postStart();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        this.publishState();
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setMainPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
                break;
            }
            case 1: {
                if (event == 0) {
                    this.loadAlarm = true;
                    if ((this.state & 8) == 0) break;
                    this.state &= 0xFFFFFFFB;
                    this.setLoadPower();
                    this.publishState();
                    break;
                }
                if (event != 2) break;
                this.loadAlarm = false;
                if ((this.state & 8) == 0) break;
                this.state |= 4;
                this.setLoadPower();
                this.publishState();
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setMainPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFFE;
        }
        this.setMainPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the load power trip enabled state")
    public void setLoadTripEnable(int value) {
        if (value != 0) {
            this.state |= 8;
            if (this.loadAlarm) {
                this.state &= 0xFFFFFFFB;
                this.setLoadPower();
            }
        } else {
            this.state &= 0xFFFFFFF7;
            if ((this.state & 4) == 0) {
                this.state |= 4;
                this.setLoadPower();
            }
        }
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState0 getFullState() {
        RefrigState0 refgState = new RefrigState0(this.state, this.getTickMillis(), 0.0, 0.0);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState0(refgState, monState);
    }

    int getState() {
        return this.state;
    }

    void publishState() {
        RefrigState0 rState = new RefrigState0(this.state, this.getTickMillis(), 0.0, 0.0);
        KeyValueData data = new KeyValueData("RefrigState", (Serializable)rState);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    void setMainPower() {
        if (this.mainPowerLine != null) {
            this.mainPowerLine.set((this.state & 1) != 0);
        }
    }

    void setLoadPower() {
        if (this.loadPowerLine != null) {
            this.loadPowerLine.set((this.state & 4) != 0);
        }
    }

    boolean isMainPowerOn() {
        return this.mainPowerLine != null && this.mainPowerLine.isSet();
    }

    boolean isLoadPowerOn() {
        return this.loadPowerLine != null && this.loadPowerLine.isSet();
    }
}

