/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.monitor.Line;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.monitor.MonitorCommands;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.refrig.data.RefrigFullState0;
import org.lsst.ccs.subsystem.refrig.data.RefrigState0;
import org.lsst.ccs.utilities.logging.Logger;

public class Compressor
extends Module
implements HardwareController,
Monitor.AlarmHandler {
    private static final int TICK_INTERVAL = 10000;
    private static final int EVENT_ID_MAIN_POWER = 0;
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.refrig");
    private int monMillis = 1000;
    private int checkMillis = 0;
    private String cmprPowerLine;
    private String heaterPowerLine;
    private String resetLine;
    private boolean coldStart;
    private boolean running;
    private ConfigurableSubsystem subsys;
    private Line cmprPowerLineL;
    private Line heaterPowerLineL;
    private Line resetLineL;
    private Monitor mon;
    private int state = 0;

    public Compressor(String name, int tickMillis, int monMillis, int checkMillis, String compPowerLine, String heaterPowerLine, String resetLine) {
        super(name, tickMillis);
        this.monMillis = monMillis;
        this.checkMillis = checkMillis;
        this.cmprPowerLine = compPowerLine;
        this.heaterPowerLine = heaterPowerLine;
        this.resetLine = resetLine;
    }

    public Compressor() {
    }

    public void initModule() {
        this.setName("main");
        if (this.getTickMillis() <= 0) {
            this.setTickMillis(10000);
        }
        this.subsys = (ConfigurableSubsystem)this.getSubsystem();
        String cold = System.getProperty("lsst.ccs.refrig.coldstart", "");
        this.coldStart = cold.equals("true");
        if (this.cmprPowerLine != null) {
            this.cmprPowerLineL = (Line)this.getComponent(this.cmprPowerLine, Line.class);
        }
        if (this.heaterPowerLine != null) {
            this.heaterPowerLineL = (Line)this.getComponent(this.heaterPowerLine, Line.class);
        }
        if (this.resetLine != null) {
            this.resetLineL = (Line)this.getComponent(this.resetLine, Line.class);
        }
        if (this.cmprPowerLineL == null) {
            this.sLog.error((Object)"Compressor power line not specified");
        }
        if (this.heaterPowerLineL == null) {
            this.sLog.error((Object)"Heater power line not specified");
        }
        if (this.resetLineL == null) {
            this.sLog.error((Object)"Reset line not specified");
        }
        this.mon = new Monitor((Module)this, (Monitor.AlarmHandler)this, this.sLog);
        this.mon.initConfiguration();
        this.subsys.addCommandsFromObject((Object)new MonitorCommands(this.mon), "");
    }

    public TreeWalkerDiag checkHardware() {
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.setWarm(!this.coldStart);
        }
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.setWarm(!this.coldStart);
        }
        this.mon.initSensors(this.checkMillis);
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.setWarm(false);
        }
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.setWarm(false);
        }
        this.setCompPowerEnable(this.isCompPowerOn() ? 1 : 0);
        this.setHeaterPowerEnable(this.isHeaterPowerOn() ? 1 : 0);
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() {
        this.sLog.info((Object)"checkStarted was called");
    }

    public void checkStopped() {
        this.sLog.info((Object)"checkStopped was called");
    }

    public void postStart() throws HardwareException {
        this.running = true;
        this.mon.start(this.monMillis);
        this.sLog.info((Object)("Refrigeration subsystem (" + this.subsys.getName() + ") started"));
        this.publishState();
        this.mon.publishState();
        this.mon.publishLimits();
        super.postStart();
    }

    public void tick() {
        this.mon.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the tick interval")
    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void processAlarm(int event, int parm) {
        switch (parm) {
            case 0: {
                if (event == 0) {
                    if ((this.state & 2) != 0) break;
                    this.state |= 2;
                    this.setCompPowerEnable(0);
                    this.publishState();
                    break;
                }
                if (event != 2 || (this.state & 2) == 0) break;
                this.state &= 0xFFFFFFFD;
                this.publishState();
                break;
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the main power enabled state")
    public void setCompPowerEnable(int value) {
        if (value != 0) {
            if ((this.state & 2) == 0) {
                this.state |= 1;
            }
        } else {
            this.state &= 0xFFFFFFDE;
        }
        this.setCompPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the heater power enabled state")
    public void setHeaterPowerEnable(int value) {
        this.state = value != 0 ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.setHeaterPower();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the latches")
    public void reset() {
        if (this.resetLineL != null) {
            this.resetLineL.set(true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.resetLineL.set(false);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full refrigeration state")
    public RefrigFullState0 getFullState() {
        RefrigState0 refgState = new RefrigState0(this.state, this.getTickMillis(), 0.0, 0.0);
        MonitorFullState monState = this.mon.getFullState();
        return new RefrigFullState0(refgState, monState);
    }

    private void publishState() {
        RefrigState0 rState = new RefrigState0(this.state, this.getTickMillis(), 0.0, 0.0);
        KeyValueData data = new KeyValueData("RefrigState", (Serializable)rState);
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setCompPower() {
        boolean on;
        boolean bl = on = (this.state & 1) != 0;
        if (this.cmprPowerLineL != null) {
            this.cmprPowerLineL.set(on);
        }
    }

    private void setHeaterPower() {
        boolean on;
        boolean bl = on = (this.state & 4) != 0;
        if (this.heaterPowerLineL != null) {
            this.heaterPowerLineL.set(on);
        }
    }

    private boolean isCompPowerOn() {
        return this.cmprPowerLineL != null && this.cmprPowerLineL.isSet();
    }

    private boolean isHeaterPowerOn() {
        return this.heaterPowerLineL != null && this.heaterPowerLineL.isSet();
    }

    private Object getComponent(String name, Class cls) {
        Object cmpt = this.getComponentByName(name);
        return cls.isInstance(cmpt) ? cmpt : null;
    }
}

