/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.bk.Model1696;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.subsystem.refrig.PowerDevice;

public class BK1696Device
extends PowerDevice {
    private static final double MAX_CURRENT = 3.0;
    private static final int CHAN_POWER = 0;
    private static final int CHAN_VOLTAGE = 1;
    private static final int CHAN_CURRENT = 2;
    private static final int N_HW_CHANS = 3;
    private static final int BK_CHANNEL = 0;
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private static final Map<String, Integer> typeMap;
    private final Model1696 bk = new Model1696();
    private String connType;
    private String ident;
    private DriverConstants.ConnType connTypeC;
    private final double[] values = new double[3];

    @Deprecated
    public BK1696Device(String connType, String devcId) {
        this.connType = connType;
        this.ident = devcId;
    }

    public BK1696Device() {
    }

    protected void configure(Monitor mon) {
        super.configure(mon);
        if (this.connType == null) {
            mon.reportConfigError(this.getName(), "connType", "is missing");
        }
        this.connTypeC = cTypeMap.get(this.connType);
        if (this.connTypeC == null) {
            mon.reportConfigError(this.getName(), "connType", "is invalid: " + this.connType);
        }
        if (this.ident == null) {
            mon.reportConfigError(this.getName(), "ident", "is missing");
        }
        this.fullName = "B&K model 1696 PS (" + this.ident + ")";
        this.disabled = true;
    }

    protected void initialize() {
        try {
            this.bk.open(this.connTypeC, this.ident);
            this.bk.setTimeout(2.0);
            this.bk.setCurrent(3.0, 0);
            this.setOnline(true);
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            if (this.bk != null) {
                this.close();
            }
        }
        finally {
            this.inited = true;
        }
    }

    protected void close() {
        try {
            this.bk.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        for (int j = 0; j < 3; ++j) {
            this.values[j] = 0.0;
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        if (hwChan < 0 || hwChan >= 3) {
            this.mon.reportError(name, "HW channel", (Object)hwChan);
        }
        Integer iSubtype = 0;
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            this.mon.reportError(name, "type", (Object)type);
        }
        return new int[]{iType, iSubtype};
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        try {
            this.values[1] = this.bk.readVoltage(0);
            this.values[2] = this.bk.readCurrent(0);
            this.values[0] = this.values[1] * this.values[2];
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    protected double readChannel(int hwChan, int type) {
        return this.online ? this.values[hwChan] : super.readChannel(hwChan, type);
    }

    @Override
    public void setOutput(int chan, boolean value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setOutput(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public boolean getOutput(int chan) {
        if (!this.testOnline()) {
            return false;
        }
        try {
            return this.bk.getOutput(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return false;
        }
    }

    @Override
    public void setVoltage(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setVoltage(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readVoltage(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.bk.readVoltage(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    @Override
    public void setCurrent(int chan, double value) {
        if (!this.testOnline()) {
            return;
        }
        try {
            this.bk.setCurrent(value, 0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error writing to " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
        }
    }

    @Override
    public double readCurrent(int chan) {
        if (!this.testOnline()) {
            return -1.0;
        }
        try {
            return this.bk.readCurrent(0);
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
            this.setOnline(false);
            return -1.0;
        }
    }

    static {
        cTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
        cTypeMap.put("FTDI", DriverConstants.ConnType.FTDI);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("POWER", 2);
    }
}

